<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OperatingCarrierDisclosure StructType
 * Meta information extracted from the WSDL
 * - documentation: Operating carrier disclosure
 * @subpackage Structs
 */
class OperatingCarrierDisclosure extends AbstractStructBase
{
    /**
     * The AirlineCode
     * Meta information extracted from the WSDL
     * - documentation: Airline code. Example: AA
     * - base: xs:string
     * - minOccurs: 0
     * - ref: AirlineCode
     * @var string
     */
    public $AirlineCode;
    /**
     * The AirlineName
     * Meta information extracted from the WSDL
     * - documentation: Airline name. Example: American Airlines
     * - base: xs:string
     * - ref: AirlineName
     * @var string
     */
    public $AirlineName;
    /**
     * The FlightNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: FlightNumber
     * @var \StructType\FlightNumberWithSuffixType
     */
    public $FlightNumber;
    /**
     * Constructor method for OperatingCarrierDisclosure
     * @uses OperatingCarrierDisclosure::setAirlineCode()
     * @uses OperatingCarrierDisclosure::setAirlineName()
     * @uses OperatingCarrierDisclosure::setFlightNumber()
     * @param string $airlineCode
     * @param string $airlineName
     * @param \StructType\FlightNumberWithSuffixType $flightNumber
     */
    public function __construct($airlineCode = null, $airlineName = null, \StructType\FlightNumberWithSuffixType $flightNumber = null)
    {
        $this
            ->setAirlineCode($airlineCode)
            ->setAirlineName($airlineName)
            ->setFlightNumber($flightNumber);
    }
    /**
     * Get AirlineCode value
     * @return string|null
     */
    public function getAirlineCode()
    {
        return $this->AirlineCode;
    }
    /**
     * Set AirlineCode value
     * @param string $airlineCode
     * @return \StructType\OperatingCarrierDisclosure
     */
    public function setAirlineCode($airlineCode = null)
    {
        // validation for constraint: string
        if (!is_null($airlineCode) && !is_string($airlineCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineCode, true), gettype($airlineCode)), __LINE__);
        }
        $this->AirlineCode = $airlineCode;
        return $this;
    }
    /**
     * Get AirlineName value
     * @return string|null
     */
    public function getAirlineName()
    {
        return $this->AirlineName;
    }
    /**
     * Set AirlineName value
     * @param string $airlineName
     * @return \StructType\OperatingCarrierDisclosure
     */
    public function setAirlineName($airlineName = null)
    {
        // validation for constraint: string
        if (!is_null($airlineName) && !is_string($airlineName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($airlineName, true), gettype($airlineName)), __LINE__);
        }
        $this->AirlineName = $airlineName;
        return $this;
    }
    /**
     * Get FlightNumber value
     * @return \StructType\FlightNumberWithSuffixType|null
     */
    public function getFlightNumber()
    {
        return $this->FlightNumber;
    }
    /**
     * Set FlightNumber value
     * @param \StructType\FlightNumberWithSuffixType $flightNumber
     * @return \StructType\OperatingCarrierDisclosure
     */
    public function setFlightNumber(\StructType\FlightNumberWithSuffixType $flightNumber = null)
    {
        $this->FlightNumber = $flightNumber;
        return $this;
    }
}
