<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OnTimePerformance StructType
 * Meta information extracted from the WSDL
 * - documentation: On time Performance (OTP) for the specific flight segment. >Delayed Over 30min % >Delayed over 60min % >Cancelled %
 * @subpackage Structs
 */
class OnTimePerformance extends AbstractStructBase
{
    /**
     * The Late
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\Late[]
     */
    public $Late;
    /**
     * The Percent
     * Meta information extracted from the WSDL
     * - documentation: Accuracy % of OTP of a segment
     * @var string
     */
    public $Percent;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - documentation: Month and year of when tyhe OTP has been calculated
     * @var string
     */
    public $Period;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - documentation: Used if unable provide information of is not applicable
     * @var string
     */
    public $Type;
    /**
     * The CancelledPercent
     * Meta information extracted from the WSDL
     * - documentation: The % of cancellation
     * @var string
     */
    public $CancelledPercent;
    /**
     * The SpecialHighlightInd
     * Meta information extracted from the WSDL
     * - documentation: When True the flight has more tha 30 minutes of scheduled arrival morethan 50% of the time
     * @var string
     */
    public $SpecialHighlightInd;
    /**
     * The DatedOperatingSegmentRefID
     * @var string
     */
    public $DatedOperatingSegmentRefID;
    /**
     * Constructor method for OnTimePerformance
     * @uses OnTimePerformance::setLate()
     * @uses OnTimePerformance::setPercent()
     * @uses OnTimePerformance::setPeriod()
     * @uses OnTimePerformance::setType()
     * @uses OnTimePerformance::setCancelledPercent()
     * @uses OnTimePerformance::setSpecialHighlightInd()
     * @uses OnTimePerformance::setDatedOperatingSegmentRefID()
     * @param \StructType\Late[] $late
     * @param string $percent
     * @param string $period
     * @param string $type
     * @param string $cancelledPercent
     * @param string $specialHighlightInd
     * @param string $datedOperatingSegmentRefID
     */
    public function __construct(array $late = array(), $percent = null, $period = null, $type = null, $cancelledPercent = null, $specialHighlightInd = null, $datedOperatingSegmentRefID = null)
    {
        $this
            ->setLate($late)
            ->setPercent($percent)
            ->setPeriod($period)
            ->setType($type)
            ->setCancelledPercent($cancelledPercent)
            ->setSpecialHighlightInd($specialHighlightInd)
            ->setDatedOperatingSegmentRefID($datedOperatingSegmentRefID);
    }
    /**
     * Get Late value
     * @return \StructType\Late[]|null
     */
    public function getLate()
    {
        return $this->Late;
    }
    /**
     * This method is responsible for validating the values passed to the setLate method
     * This method is willingly generated in order to preserve the one-line inline validation within the setLate method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateLateForArrayConstraintsFromSetLate(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $onTimePerformanceLateItem) {
            // validation for constraint: itemType
            if (!$onTimePerformanceLateItem instanceof \StructType\Late) {
                $invalidValues[] = is_object($onTimePerformanceLateItem) ? get_class($onTimePerformanceLateItem) : sprintf('%s(%s)', gettype($onTimePerformanceLateItem), var_export($onTimePerformanceLateItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Late property can only contain items of type \StructType\Late, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Late value
     * @throws \InvalidArgumentException
     * @param \StructType\Late[] $late
     * @return \StructType\OnTimePerformance
     */
    public function setLate(array $late = array())
    {
        // validation for constraint: array
        if ('' !== ($lateArrayErrorMessage = self::validateLateForArrayConstraintsFromSetLate($late))) {
            throw new \InvalidArgumentException($lateArrayErrorMessage, __LINE__);
        }
        $this->Late = $late;
        return $this;
    }
    /**
     * Add item to Late value
     * @throws \InvalidArgumentException
     * @param \StructType\Late $item
     * @return \StructType\OnTimePerformance
     */
    public function addToLate(\StructType\Late $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Late) {
            throw new \InvalidArgumentException(sprintf('The Late property can only contain items of type \StructType\Late, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Late[] = $item;
        return $this;
    }
    /**
     * Get Percent value
     * @return string|null
     */
    public function getPercent()
    {
        return $this->Percent;
    }
    /**
     * Set Percent value
     * @param string $percent
     * @return \StructType\OnTimePerformance
     */
    public function setPercent($percent = null)
    {
        // validation for constraint: string
        if (!is_null($percent) && !is_string($percent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($percent, true), gettype($percent)), __LINE__);
        }
        $this->Percent = $percent;
        return $this;
    }
    /**
     * Get Period value
     * @return string|null
     */
    public function getPeriod()
    {
        return $this->Period;
    }
    /**
     * Set Period value
     * @param string $period
     * @return \StructType\OnTimePerformance
     */
    public function setPeriod($period = null)
    {
        // validation for constraint: string
        if (!is_null($period) && !is_string($period)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($period, true), gettype($period)), __LINE__);
        }
        $this->Period = $period;
        return $this;
    }
    /**
     * Get Type value
     * @return string|null
     */
    public function getType()
    {
        return $this->Type;
    }
    /**
     * Set Type value
     * @param string $type
     * @return \StructType\OnTimePerformance
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        $this->Type = $type;
        return $this;
    }
    /**
     * Get CancelledPercent value
     * @return string|null
     */
    public function getCancelledPercent()
    {
        return $this->CancelledPercent;
    }
    /**
     * Set CancelledPercent value
     * @param string $cancelledPercent
     * @return \StructType\OnTimePerformance
     */
    public function setCancelledPercent($cancelledPercent = null)
    {
        // validation for constraint: string
        if (!is_null($cancelledPercent) && !is_string($cancelledPercent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cancelledPercent, true), gettype($cancelledPercent)), __LINE__);
        }
        $this->CancelledPercent = $cancelledPercent;
        return $this;
    }
    /**
     * Get SpecialHighlightInd value
     * @return string|null
     */
    public function getSpecialHighlightInd()
    {
        return $this->SpecialHighlightInd;
    }
    /**
     * Set SpecialHighlightInd value
     * @param string $specialHighlightInd
     * @return \StructType\OnTimePerformance
     */
    public function setSpecialHighlightInd($specialHighlightInd = null)
    {
        // validation for constraint: string
        if (!is_null($specialHighlightInd) && !is_string($specialHighlightInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($specialHighlightInd, true), gettype($specialHighlightInd)), __LINE__);
        }
        $this->SpecialHighlightInd = $specialHighlightInd;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentRefID value
     * @return string|null
     */
    public function getDatedOperatingSegmentRefID()
    {
        return $this->DatedOperatingSegmentRefID;
    }
    /**
     * Set DatedOperatingSegmentRefID value
     * @param string $datedOperatingSegmentRefID
     * @return \StructType\OnTimePerformance
     */
    public function setDatedOperatingSegmentRefID($datedOperatingSegmentRefID = null)
    {
        // validation for constraint: string
        if (!is_null($datedOperatingSegmentRefID) && !is_string($datedOperatingSegmentRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($datedOperatingSegmentRefID, true), gettype($datedOperatingSegmentRefID)), __LINE__);
        }
        $this->DatedOperatingSegmentRefID = $datedOperatingSegmentRefID;
        return $this;
    }
}
