<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OffersGroupType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offers grouped by Carrier.
 * @subpackage Structs
 */
class OffersGroupType extends AbstractStructBase
{
    /**
     * The CarrierOffers
     * Meta information extracted from the WSDL
     * - documentation: Carrier Offers grouping of Offers returned by a single ORA.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\CarrierOffersType[]
     */
    public $CarrierOffers;
    /**
     * The AllOffersSummary
     * Meta information extracted from the WSDL
     * - documentation: Offer summary that includes highest, lowest, and number of matched offers included in the response.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OffersSummaryType
     */
    public $AllOffersSummary;
    /**
     * Constructor method for OffersGroupType
     * @uses OffersGroupType::setCarrierOffers()
     * @uses OffersGroupType::setAllOffersSummary()
     * @param \StructType\CarrierOffersType[] $carrierOffers
     * @param \StructType\OffersSummaryType $allOffersSummary
     */
    public function __construct(array $carrierOffers = array(), \StructType\OffersSummaryType $allOffersSummary = null)
    {
        $this
            ->setCarrierOffers($carrierOffers)
            ->setAllOffersSummary($allOffersSummary);
    }
    /**
     * Get CarrierOffers value
     * @return \StructType\CarrierOffersType[]
     */
    public function getCarrierOffers()
    {
        return $this->CarrierOffers;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierOffers method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierOffers method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierOffersForArrayConstraintsFromSetCarrierOffers(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offersGroupTypeCarrierOffersItem) {
            // validation for constraint: itemType
            if (!$offersGroupTypeCarrierOffersItem instanceof \StructType\CarrierOffersType) {
                $invalidValues[] = is_object($offersGroupTypeCarrierOffersItem) ? get_class($offersGroupTypeCarrierOffersItem) : sprintf('%s(%s)', gettype($offersGroupTypeCarrierOffersItem), var_export($offersGroupTypeCarrierOffersItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierOffers property can only contain items of type \StructType\CarrierOffersType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierOffersType[] $carrierOffers
     * @return \StructType\OffersGroupType
     */
    public function setCarrierOffers(array $carrierOffers = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierOffersArrayErrorMessage = self::validateCarrierOffersForArrayConstraintsFromSetCarrierOffers($carrierOffers))) {
            throw new \InvalidArgumentException($carrierOffersArrayErrorMessage, __LINE__);
        }
        $this->CarrierOffers = $carrierOffers;
        return $this;
    }
    /**
     * Add item to CarrierOffers value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierOffersType $item
     * @return \StructType\OffersGroupType
     */
    public function addToCarrierOffers(\StructType\CarrierOffersType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarrierOffersType) {
            throw new \InvalidArgumentException(sprintf('The CarrierOffers property can only contain items of type \StructType\CarrierOffersType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierOffers[] = $item;
        return $this;
    }
    /**
     * Get AllOffersSummary value
     * @return \StructType\OffersSummaryType|null
     */
    public function getAllOffersSummary()
    {
        return $this->AllOffersSummary;
    }
    /**
     * Set AllOffersSummary value
     * @param \StructType\OffersSummaryType $allOffersSummary
     * @return \StructType\OffersGroupType
     */
    public function setAllOffersSummary(\StructType\OffersSummaryType $allOffersSummary = null)
    {
        $this->AllOffersSummary = $allOffersSummary;
        return $this;
    }
}
