<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferServiceDefinitionRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: Airline specific definition of a product or service (excluding flights) that can be separately sold and delivered. e.g. bag, seat, meal on a flight
 * @subpackage Structs
 */
class OfferServiceDefinitionRefType extends AbstractStructBase
{
    /**
     * The ServiceDefinitionRefID
     * Meta information extracted from the WSDL
     * - documentation: References a Service Definition ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDefinitionRefID;
    /**
     * The OfferFlightAssociations
     * Meta information extracted from the WSDL
     * - documentation: Offer Flight Associations
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferFlightAssociationsType
     */
    public $OfferFlightAssociations;
    /**
     * Constructor method for OfferServiceDefinitionRefType
     * @uses OfferServiceDefinitionRefType::setServiceDefinitionRefID()
     * @uses OfferServiceDefinitionRefType::setOfferFlightAssociations()
     * @param string $serviceDefinitionRefID
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     */
    public function __construct($serviceDefinitionRefID = null, \StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this
            ->setServiceDefinitionRefID($serviceDefinitionRefID)
            ->setOfferFlightAssociations($offerFlightAssociations);
    }
    /**
     * Get ServiceDefinitionRefID value
     * @return string
     */
    public function getServiceDefinitionRefID()
    {
        return $this->ServiceDefinitionRefID;
    }
    /**
     * Set ServiceDefinitionRefID value
     * @param string $serviceDefinitionRefID
     * @return \StructType\OfferServiceDefinitionRefType
     */
    public function setServiceDefinitionRefID($serviceDefinitionRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDefinitionRefID) && !is_string($serviceDefinitionRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDefinitionRefID, true), gettype($serviceDefinitionRefID)), __LINE__);
        }
        $this->ServiceDefinitionRefID = $serviceDefinitionRefID;
        return $this;
    }
    /**
     * Get OfferFlightAssociations value
     * @return \StructType\OfferFlightAssociationsType|null
     */
    public function getOfferFlightAssociations()
    {
        return $this->OfferFlightAssociations;
    }
    /**
     * Set OfferFlightAssociations value
     * @param \StructType\OfferFlightAssociationsType $offerFlightAssociations
     * @return \StructType\OfferServiceDefinitionRefType
     */
    public function setOfferFlightAssociations(\StructType\OfferFlightAssociationsType $offerFlightAssociations = null)
    {
        $this->OfferFlightAssociations = $offerFlightAssociations;
        return $this;
    }
}
