<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferPriceRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Offer Price Request content for message
 * @subpackage Structs
 */
class OfferPriceRequestType extends AbstractStructBase
{
    /**
     * The PricedOffer
     * Meta information extracted from the WSDL
     * - documentation: Priced Offer
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PricedOfferType
     */
    public $PricedOffer;
    /**
     * The DataLists
     * Meta information extracted from the WSDL
     * - documentation: Data List definition for this message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ShoppingRequestDataListsType
     */
    public $DataLists;
    /**
     * The InExchForTicket
     * Meta information extracted from the WSDL
     * - documentation: Penalty reference information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PenaltyRefType
     */
    public $InExchForTicket;
    /**
     * The Metadata
     * Meta information extracted from the WSDL
     * - documentation: Message wide metadata information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\MetadataType
     */
    public $Metadata;
    /**
     * The OfferCriteria
     * Meta information extracted from the WSDL
     * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\OfferCriteriaType
     */
    public $OfferCriteria;
    /**
     * The OriginDestRefID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies an Origin Destination within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $OriginDestRefID;
    /**
     * The PaymentFunctions
     * Meta information extracted from the WSDL
     * - documentation: Offer Specialization of Payment Functions: Is the container of all payment relevant functions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PaymentAssociatedOfferFunctionsCriteriaType[]
     */
    public $PaymentFunctions;
    /**
     * The Policy
     * Meta information extracted from the WSDL
     * - documentation: Message policy information, including PCI, PII information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PolicyType[]
     */
    public $Policy;
    /**
     * The ResponseParameters
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ResponseParametersRequestType
     */
    public $ResponseParameters;
    /**
     * Constructor method for OfferPriceRequestType
     * @uses OfferPriceRequestType::setPricedOffer()
     * @uses OfferPriceRequestType::setDataLists()
     * @uses OfferPriceRequestType::setInExchForTicket()
     * @uses OfferPriceRequestType::setMetadata()
     * @uses OfferPriceRequestType::setOfferCriteria()
     * @uses OfferPriceRequestType::setOriginDestRefID()
     * @uses OfferPriceRequestType::setPaymentFunctions()
     * @uses OfferPriceRequestType::setPolicy()
     * @uses OfferPriceRequestType::setResponseParameters()
     * @param \StructType\PricedOfferType $pricedOffer
     * @param \StructType\ShoppingRequestDataListsType $dataLists
     * @param \StructType\PenaltyRefType $inExchForTicket
     * @param \StructType\MetadataType $metadata
     * @param \StructType\OfferCriteriaType $offerCriteria
     * @param string[] $originDestRefID
     * @param \StructType\PaymentAssociatedOfferFunctionsCriteriaType[] $paymentFunctions
     * @param \StructType\PolicyType[] $policy
     * @param \StructType\ResponseParametersRequestType $responseParameters
     */
    public function __construct(\StructType\PricedOfferType $pricedOffer = null, \StructType\ShoppingRequestDataListsType $dataLists = null, \StructType\PenaltyRefType $inExchForTicket = null, \StructType\MetadataType $metadata = null, \StructType\OfferCriteriaType $offerCriteria = null, array $originDestRefID = array(), array $paymentFunctions = array(), array $policy = array(), \StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this
            ->setPricedOffer($pricedOffer)
            ->setDataLists($dataLists)
            ->setInExchForTicket($inExchForTicket)
            ->setMetadata($metadata)
            ->setOfferCriteria($offerCriteria)
            ->setOriginDestRefID($originDestRefID)
            ->setPaymentFunctions($paymentFunctions)
            ->setPolicy($policy)
            ->setResponseParameters($responseParameters);
    }
    /**
     * Get PricedOffer value
     * @return \StructType\PricedOfferType
     */
    public function getPricedOffer()
    {
        return $this->PricedOffer;
    }
    /**
     * Set PricedOffer value
     * @param \StructType\PricedOfferType $pricedOffer
     * @return \StructType\OfferPriceRequestType
     */
    public function setPricedOffer(\StructType\PricedOfferType $pricedOffer = null)
    {
        $this->PricedOffer = $pricedOffer;
        return $this;
    }
    /**
     * Get DataLists value
     * @return \StructType\ShoppingRequestDataListsType|null
     */
    public function getDataLists()
    {
        return $this->DataLists;
    }
    /**
     * Set DataLists value
     * @param \StructType\ShoppingRequestDataListsType $dataLists
     * @return \StructType\OfferPriceRequestType
     */
    public function setDataLists(\StructType\ShoppingRequestDataListsType $dataLists = null)
    {
        $this->DataLists = $dataLists;
        return $this;
    }
    /**
     * Get InExchForTicket value
     * @return \StructType\PenaltyRefType|null
     */
    public function getInExchForTicket()
    {
        return $this->InExchForTicket;
    }
    /**
     * Set InExchForTicket value
     * @param \StructType\PenaltyRefType $inExchForTicket
     * @return \StructType\OfferPriceRequestType
     */
    public function setInExchForTicket(\StructType\PenaltyRefType $inExchForTicket = null)
    {
        $this->InExchForTicket = $inExchForTicket;
        return $this;
    }
    /**
     * Get Metadata value
     * @return \StructType\MetadataType|null
     */
    public function getMetadata()
    {
        return $this->Metadata;
    }
    /**
     * Set Metadata value
     * @param \StructType\MetadataType $metadata
     * @return \StructType\OfferPriceRequestType
     */
    public function setMetadata(\StructType\MetadataType $metadata = null)
    {
        $this->Metadata = $metadata;
        return $this;
    }
    /**
     * Get OfferCriteria value
     * @return \StructType\OfferCriteriaType|null
     */
    public function getOfferCriteria()
    {
        return $this->OfferCriteria;
    }
    /**
     * Set OfferCriteria value
     * @param \StructType\OfferCriteriaType $offerCriteria
     * @return \StructType\OfferPriceRequestType
     */
    public function setOfferCriteria(\StructType\OfferCriteriaType $offerCriteria = null)
    {
        $this->OfferCriteria = $offerCriteria;
        return $this;
    }
    /**
     * Get OriginDestRefID value
     * @return string[]|null
     */
    public function getOriginDestRefID()
    {
        return $this->OriginDestRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDestRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestRefIDForArrayConstraintsFromSetOriginDestRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerPriceRequestTypeOriginDestRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($offerPriceRequestTypeOriginDestRefIDItem)) {
                $invalidValues[] = is_object($offerPriceRequestTypeOriginDestRefIDItem) ? get_class($offerPriceRequestTypeOriginDestRefIDItem) : sprintf('%s(%s)', gettype($offerPriceRequestTypeOriginDestRefIDItem), var_export($offerPriceRequestTypeOriginDestRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDestRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginDestRefID value
     * @throws \InvalidArgumentException
     * @param string[] $originDestRefID
     * @return \StructType\OfferPriceRequestType
     */
    public function setOriginDestRefID(array $originDestRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestRefIDArrayErrorMessage = self::validateOriginDestRefIDForArrayConstraintsFromSetOriginDestRefID($originDestRefID))) {
            throw new \InvalidArgumentException($originDestRefIDArrayErrorMessage, __LINE__);
        }
        $this->OriginDestRefID = $originDestRefID;
        return $this;
    }
    /**
     * Add item to OriginDestRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\OfferPriceRequestType
     */
    public function addToOriginDestRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OriginDestRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginDestRefID[] = $item;
        return $this;
    }
    /**
     * Get PaymentFunctions value
     * @return \StructType\PaymentAssociatedOfferFunctionsCriteriaType[]|null
     */
    public function getPaymentFunctions()
    {
        return $this->PaymentFunctions;
    }
    /**
     * This method is responsible for validating the values passed to the setPaymentFunctions method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaymentFunctions method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerPriceRequestTypePaymentFunctionsItem) {
            // validation for constraint: itemType
            if (!$offerPriceRequestTypePaymentFunctionsItem instanceof \StructType\PaymentAssociatedOfferFunctionsCriteriaType) {
                $invalidValues[] = is_object($offerPriceRequestTypePaymentFunctionsItem) ? get_class($offerPriceRequestTypePaymentFunctionsItem) : sprintf('%s(%s)', gettype($offerPriceRequestTypePaymentFunctionsItem), var_export($offerPriceRequestTypePaymentFunctionsItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentAssociatedOfferFunctionsCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAssociatedOfferFunctionsCriteriaType[] $paymentFunctions
     * @return \StructType\OfferPriceRequestType
     */
    public function setPaymentFunctions(array $paymentFunctions = array())
    {
        // validation for constraint: array
        if ('' !== ($paymentFunctionsArrayErrorMessage = self::validatePaymentFunctionsForArrayConstraintsFromSetPaymentFunctions($paymentFunctions))) {
            throw new \InvalidArgumentException($paymentFunctionsArrayErrorMessage, __LINE__);
        }
        $this->PaymentFunctions = $paymentFunctions;
        return $this;
    }
    /**
     * Add item to PaymentFunctions value
     * @throws \InvalidArgumentException
     * @param \StructType\PaymentAssociatedOfferFunctionsCriteriaType $item
     * @return \StructType\OfferPriceRequestType
     */
    public function addToPaymentFunctions(\StructType\PaymentAssociatedOfferFunctionsCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaymentAssociatedOfferFunctionsCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PaymentFunctions property can only contain items of type \StructType\PaymentAssociatedOfferFunctionsCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaymentFunctions[] = $item;
        return $this;
    }
    /**
     * Get Policy value
     * @return \StructType\PolicyType[]|null
     */
    public function getPolicy()
    {
        return $this->Policy;
    }
    /**
     * This method is responsible for validating the values passed to the setPolicy method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPolicy method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePolicyForArrayConstraintsFromSetPolicy(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerPriceRequestTypePolicyItem) {
            // validation for constraint: itemType
            if (!$offerPriceRequestTypePolicyItem instanceof \StructType\PolicyType) {
                $invalidValues[] = is_object($offerPriceRequestTypePolicyItem) ? get_class($offerPriceRequestTypePolicyItem) : sprintf('%s(%s)', gettype($offerPriceRequestTypePolicyItem), var_export($offerPriceRequestTypePolicyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType[] $policy
     * @return \StructType\OfferPriceRequestType
     */
    public function setPolicy(array $policy = array())
    {
        // validation for constraint: array
        if ('' !== ($policyArrayErrorMessage = self::validatePolicyForArrayConstraintsFromSetPolicy($policy))) {
            throw new \InvalidArgumentException($policyArrayErrorMessage, __LINE__);
        }
        $this->Policy = $policy;
        return $this;
    }
    /**
     * Add item to Policy value
     * @throws \InvalidArgumentException
     * @param \StructType\PolicyType $item
     * @return \StructType\OfferPriceRequestType
     */
    public function addToPolicy(\StructType\PolicyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PolicyType) {
            throw new \InvalidArgumentException(sprintf('The Policy property can only contain items of type \StructType\PolicyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Policy[] = $item;
        return $this;
    }
    /**
     * Get ResponseParameters value
     * @return \StructType\ResponseParametersRequestType|null
     */
    public function getResponseParameters()
    {
        return $this->ResponseParameters;
    }
    /**
     * Set ResponseParameters value
     * @param \StructType\ResponseParametersRequestType $responseParameters
     * @return \StructType\OfferPriceRequestType
     */
    public function setResponseParameters(\StructType\ResponseParametersRequestType $responseParameters = null)
    {
        $this->ResponseParameters = $responseParameters;
        return $this;
    }
}
