<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferPenaltyInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to a penalty applied to an OfferItem for the requested servicing operations.
 * @subpackage Structs
 */
class OfferPenaltyInfoType extends AbstractStructBase
{
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Offer Item ID to which the penalty may be applied. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemRefID;
    /**
     * The PenaltyDetails
     * Meta information extracted from the WSDL
     * - documentation: Information related to a penalty applied to the requested servicing operations.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PenaltyDetailsType
     */
    public $PenaltyDetails;
    /**
     * The PenaltyInfoID
     * Meta information extracted from the WSDL
     * - documentation: Identifier for Penalty Info. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PenaltyInfoID;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID to which the penalty may be applied. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * Constructor method for OfferPenaltyInfoType
     * @uses OfferPenaltyInfoType::setOfferItemRefID()
     * @uses OfferPenaltyInfoType::setPenaltyDetails()
     * @uses OfferPenaltyInfoType::setPenaltyInfoID()
     * @uses OfferPenaltyInfoType::setPaxRefID()
     * @param string $offerItemRefID
     * @param \StructType\PenaltyDetailsType $penaltyDetails
     * @param string $penaltyInfoID
     * @param string $paxRefID
     */
    public function __construct($offerItemRefID = null, \StructType\PenaltyDetailsType $penaltyDetails = null, $penaltyInfoID = null, $paxRefID = null)
    {
        $this
            ->setOfferItemRefID($offerItemRefID)
            ->setPenaltyDetails($penaltyDetails)
            ->setPenaltyInfoID($penaltyInfoID)
            ->setPaxRefID($paxRefID);
    }
    /**
     * Get OfferItemRefID value
     * @return string
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * Set OfferItemRefID value
     * @param string $offerItemRefID
     * @return \StructType\OfferPenaltyInfoType
     */
    public function setOfferItemRefID($offerItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemRefID) && !is_string($offerItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemRefID, true), gettype($offerItemRefID)), __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Get PenaltyDetails value
     * @return \StructType\PenaltyDetailsType
     */
    public function getPenaltyDetails()
    {
        return $this->PenaltyDetails;
    }
    /**
     * Set PenaltyDetails value
     * @param \StructType\PenaltyDetailsType $penaltyDetails
     * @return \StructType\OfferPenaltyInfoType
     */
    public function setPenaltyDetails(\StructType\PenaltyDetailsType $penaltyDetails = null)
    {
        $this->PenaltyDetails = $penaltyDetails;
        return $this;
    }
    /**
     * Get PenaltyInfoID value
     * @return string
     */
    public function getPenaltyInfoID()
    {
        return $this->PenaltyInfoID;
    }
    /**
     * Set PenaltyInfoID value
     * @param string $penaltyInfoID
     * @return \StructType\OfferPenaltyInfoType
     */
    public function setPenaltyInfoID($penaltyInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($penaltyInfoID) && !is_string($penaltyInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($penaltyInfoID, true), gettype($penaltyInfoID)), __LINE__);
        }
        $this->PenaltyInfoID = $penaltyInfoID;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\OfferPenaltyInfoType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
}
