<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferForfeitedInfoType StructType
 * Meta information extracted from the WSDL
 * - documentation: Information related to an amount which could not be recovered as a consequence of a servicing operation.
 * @subpackage Structs
 */
class OfferForfeitedInfoType extends AbstractStructBase
{
    /**
     * The ForfeitedInfoID
     * Meta information extracted from the WSDL
     * - documentation: Identifier of the Forfeited Info | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ForfeitedInfoID;
    /**
     * The OfferItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to the Offer Item ID for which an amount may be forfeited. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OfferItemRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID related to a forfeited amount. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PaxRefID;
    /**
     * Constructor method for OfferForfeitedInfoType
     * @uses OfferForfeitedInfoType::setForfeitedInfoID()
     * @uses OfferForfeitedInfoType::setOfferItemRefID()
     * @uses OfferForfeitedInfoType::setPrice()
     * @uses OfferForfeitedInfoType::setPaxRefID()
     * @param string $forfeitedInfoID
     * @param string $offerItemRefID
     * @param \StructType\PriceType $price
     * @param string $paxRefID
     */
    public function __construct($forfeitedInfoID = null, $offerItemRefID = null, \StructType\PriceType $price = null, $paxRefID = null)
    {
        $this
            ->setForfeitedInfoID($forfeitedInfoID)
            ->setOfferItemRefID($offerItemRefID)
            ->setPrice($price)
            ->setPaxRefID($paxRefID);
    }
    /**
     * Get ForfeitedInfoID value
     * @return string
     */
    public function getForfeitedInfoID()
    {
        return $this->ForfeitedInfoID;
    }
    /**
     * Set ForfeitedInfoID value
     * @param string $forfeitedInfoID
     * @return \StructType\OfferForfeitedInfoType
     */
    public function setForfeitedInfoID($forfeitedInfoID = null)
    {
        // validation for constraint: string
        if (!is_null($forfeitedInfoID) && !is_string($forfeitedInfoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($forfeitedInfoID, true), gettype($forfeitedInfoID)), __LINE__);
        }
        $this->ForfeitedInfoID = $forfeitedInfoID;
        return $this;
    }
    /**
     * Get OfferItemRefID value
     * @return string
     */
    public function getOfferItemRefID()
    {
        return $this->OfferItemRefID;
    }
    /**
     * Set OfferItemRefID value
     * @param string $offerItemRefID
     * @return \StructType\OfferForfeitedInfoType
     */
    public function setOfferItemRefID($offerItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($offerItemRefID) && !is_string($offerItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($offerItemRefID, true), gettype($offerItemRefID)), __LINE__);
        }
        $this->OfferItemRefID = $offerItemRefID;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\OfferForfeitedInfoType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\OfferForfeitedInfoType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
}
