<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferFilterCriteriaChoiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Filters results based on offer preferences/criteria.
 * @subpackage Structs
 */
class OfferFilterCriteriaChoiceType extends AbstractStructBase
{
    /**
     * The OfferFilterCriteriawithOriginandDest
     * Meta information extracted from the WSDL
     * - documentation: A set of filter criteria based on offer preferences/criteria. Technical specialized to use just origin and destination points.
     * - choice: OfferFilterCriteriawithOriginandDest | TravelWithin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OfferFilterCriteriawithOriginandDestType
     */
    public $OfferFilterCriteriawithOriginandDest;
    /**
     * The TravelWithin
     * Meta information extracted from the WSDL
     * - documentation: Criteria used to filter results based on geographic preferences, including Area, State, City, Airport, or Geospatial information.
     * - choice: OfferFilterCriteriawithOriginandDest | TravelWithin
     * - choiceMaxOccurs: 1
     * - choiceMinOccurs: 1
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\GeographicFilterCriteriaType
     */
    public $TravelWithin;
    /**
     * Constructor method for OfferFilterCriteriaChoiceType
     * @uses OfferFilterCriteriaChoiceType::setOfferFilterCriteriawithOriginandDest()
     * @uses OfferFilterCriteriaChoiceType::setTravelWithin()
     * @param \StructType\OfferFilterCriteriawithOriginandDestType $offerFilterCriteriawithOriginandDest
     * @param \StructType\GeographicFilterCriteriaType $travelWithin
     */
    public function __construct(\StructType\OfferFilterCriteriawithOriginandDestType $offerFilterCriteriawithOriginandDest = null, \StructType\GeographicFilterCriteriaType $travelWithin = null)
    {
        $this
            ->setOfferFilterCriteriawithOriginandDest($offerFilterCriteriawithOriginandDest)
            ->setTravelWithin($travelWithin);
    }
    /**
     * Get OfferFilterCriteriawithOriginandDest value
     * @return \StructType\OfferFilterCriteriawithOriginandDestType
     */
    public function getOfferFilterCriteriawithOriginandDest()
    {
        return isset($this->OfferFilterCriteriawithOriginandDest) ? $this->OfferFilterCriteriawithOriginandDest : null;
    }
    /**
     * This method is responsible for validating the value passed to the setOfferFilterCriteriawithOriginandDest method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferFilterCriteriawithOriginandDest method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateOfferFilterCriteriawithOriginandDestForChoiceConstraintsFromSetOfferFilterCriteriawithOriginandDest($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'TravelWithin',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property OfferFilterCriteriawithOriginandDest can\'t be set as the property %s is already set. Only one property must be set among these properties: OfferFilterCriteriawithOriginandDest, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set OfferFilterCriteriawithOriginandDest value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\OfferFilterCriteriawithOriginandDestType $offerFilterCriteriawithOriginandDest
     * @return \StructType\OfferFilterCriteriaChoiceType
     */
    public function setOfferFilterCriteriawithOriginandDest(\StructType\OfferFilterCriteriawithOriginandDestType $offerFilterCriteriawithOriginandDest = null)
    {
        // validation for constraint: choice(OfferFilterCriteriawithOriginandDest, TravelWithin)
        if ('' !== ($offerFilterCriteriawithOriginandDestChoiceErrorMessage = self::validateOfferFilterCriteriawithOriginandDestForChoiceConstraintsFromSetOfferFilterCriteriawithOriginandDest($offerFilterCriteriawithOriginandDest))) {
            throw new \InvalidArgumentException($offerFilterCriteriawithOriginandDestChoiceErrorMessage, __LINE__);
        }
        if (is_null($offerFilterCriteriawithOriginandDest) || (is_array($offerFilterCriteriawithOriginandDest) && empty($offerFilterCriteriawithOriginandDest))) {
            unset($this->OfferFilterCriteriawithOriginandDest);
        } else {
            $this->OfferFilterCriteriawithOriginandDest = $offerFilterCriteriawithOriginandDest;
        }
        return $this;
    }
    /**
     * Get TravelWithin value
     * @return \StructType\GeographicFilterCriteriaType
     */
    public function getTravelWithin()
    {
        return isset($this->TravelWithin) ? $this->TravelWithin : null;
    }
    /**
     * This method is responsible for validating the value passed to the setTravelWithin method
     * This method is willingly generated in order to preserve the one-line inline validation within the setTravelWithin method
     * This has to validate that the property which is being set is the only one among the given choices
     * @param mixed $value
     * @return string A non-empty message if the values does not match the validation rules
     */
    public function validateTravelWithinForChoiceConstraintsFromSetTravelWithin($value)
    {
        $message = '';
        if (is_null($value)) {
            return $message;
        }
        $properties = [
            'OfferFilterCriteriawithOriginandDest',
        ];
        try {
            foreach ($properties as $property) {
                if (isset($this->{$property})) {
                    throw new \InvalidArgumentException(sprintf('The property TravelWithin can\'t be set as the property %s is already set. Only one property must be set among these properties: TravelWithin, %s.', $property, implode(', ', $properties)), __LINE__);
                }
            }
        } catch (\InvalidArgumentException $e) {
            $message = $e->getMessage();
        }
        return $message;
    }
    /**
     * Set TravelWithin value
     * This property belongs to a choice that allows only one property to exist. It is
     * therefore removable from the request, consequently if the value assigned to this
     * property is null, the property is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\GeographicFilterCriteriaType $travelWithin
     * @return \StructType\OfferFilterCriteriaChoiceType
     */
    public function setTravelWithin(\StructType\GeographicFilterCriteriaType $travelWithin = null)
    {
        // validation for constraint: choice(OfferFilterCriteriawithOriginandDest, TravelWithin)
        if ('' !== ($travelWithinChoiceErrorMessage = self::validateTravelWithinForChoiceConstraintsFromSetTravelWithin($travelWithin))) {
            throw new \InvalidArgumentException($travelWithinChoiceErrorMessage, __LINE__);
        }
        if (is_null($travelWithin) || (is_array($travelWithin) && empty($travelWithin))) {
            unset($this->TravelWithin);
        } else {
            $this->TravelWithin = $travelWithin;
        }
        return $this;
    }
}
