<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for OfferCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
 * @subpackage Structs
 */
class OfferCriteriaType extends AbstractStructBase
{
    /**
     * The BaggagePricingCriteria
     * Meta information extracted from the WSDL
     * - documentation: Baggage pricing specific filter criteria for shopping requests, including baggage type, charges, and settlement information.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggagePricingCriteriaType
     */
    public $BaggagePricingCriteria;
    /**
     * The FareCriteria
     * Meta information extracted from the WSDL
     * - documentation: Fare criteria used to filter shopping results.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareCriteriaType[]
     */
    public $FareCriteria;
    /**
     * The PricingMethodCriteria
     * Meta information extracted from the WSDL
     * - documentation: Contains information to identify how reservation was re-priced to obtain best published fare (Eg. best fare in same cabin, best fare in all cabins, other parameters to select best fare).
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PricingMethodCriteriaType[]
     */
    public $PricingMethodCriteria;
    /**
     * The ProgramCriteria
     * Meta information extracted from the WSDL
     * - documentation: A negotiated program identifier ( e.g. CLID, Corporate codes ) to be passed between seller and retailer.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ProgramCriteriaType[]
     */
    public $ProgramCriteria;
    /**
     * The PromotionCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Promotion and discount code criteria to be passed to the retailer airline that could influence returned offers.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\PromotionType[]
     */
    public $PromotionCriteria;
    /**
     * The SeatCriteria
     * Meta information extracted from the WSDL
     * - documentation: A sitting place for a passenger or crew in a cabin compartment on a transport vehicle.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SeatCriteriaType[]
     */
    public $SeatCriteria;
    /**
     * The ServiceCriteria
     * Meta information extracted from the WSDL
     * - documentation: Reason for Issuance Group and Subgroup code(s) that specify the requested categories of Optional Services to be returned in the results.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ServiceCriteriaType[]
     */
    public $ServiceCriteria;
    /**
     * The SpecialNeedsCriteria
     * Meta information extracted from the WSDL
     * - documentation: Special service information
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SpecialServiceType[]
     */
    public $SpecialNeedsCriteria;
    /**
     * The TripPurposeCode
     * Meta information extracted from the WSDL
     * - documentation: Trip purpose information (e.g. Business, Leisure, etc.). | Trip purpose code Type BDT.
     * - base: TripPurposeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripPurposeCode;
    /**
     * The WaitListCriteria
     * Meta information extracted from the WSDL
     * - documentation: A Waitlist criteria to be passed to the Retailer airline.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $WaitListCriteria;
    /**
     * Constructor method for OfferCriteriaType
     * @uses OfferCriteriaType::setBaggagePricingCriteria()
     * @uses OfferCriteriaType::setFareCriteria()
     * @uses OfferCriteriaType::setPricingMethodCriteria()
     * @uses OfferCriteriaType::setProgramCriteria()
     * @uses OfferCriteriaType::setPromotionCriteria()
     * @uses OfferCriteriaType::setSeatCriteria()
     * @uses OfferCriteriaType::setServiceCriteria()
     * @uses OfferCriteriaType::setSpecialNeedsCriteria()
     * @uses OfferCriteriaType::setTripPurposeCode()
     * @uses OfferCriteriaType::setWaitListCriteria()
     * @param \StructType\BaggagePricingCriteriaType $baggagePricingCriteria
     * @param \StructType\FareCriteriaType[] $fareCriteria
     * @param \StructType\PricingMethodCriteriaType[] $pricingMethodCriteria
     * @param \StructType\ProgramCriteriaType[] $programCriteria
     * @param \StructType\PromotionType[] $promotionCriteria
     * @param \StructType\SeatCriteriaType[] $seatCriteria
     * @param \StructType\ServiceCriteriaType[] $serviceCriteria
     * @param \StructType\SpecialServiceType[] $specialNeedsCriteria
     * @param string $tripPurposeCode
     * @param \StructType\PrefLevelType $waitListCriteria
     */
    public function __construct(\StructType\BaggagePricingCriteriaType $baggagePricingCriteria = null, array $fareCriteria = array(), array $pricingMethodCriteria = array(), array $programCriteria = array(), array $promotionCriteria = array(), array $seatCriteria = array(), array $serviceCriteria = array(), array $specialNeedsCriteria = array(), $tripPurposeCode = null, \StructType\PrefLevelType $waitListCriteria = null)
    {
        $this
            ->setBaggagePricingCriteria($baggagePricingCriteria)
            ->setFareCriteria($fareCriteria)
            ->setPricingMethodCriteria($pricingMethodCriteria)
            ->setProgramCriteria($programCriteria)
            ->setPromotionCriteria($promotionCriteria)
            ->setSeatCriteria($seatCriteria)
            ->setServiceCriteria($serviceCriteria)
            ->setSpecialNeedsCriteria($specialNeedsCriteria)
            ->setTripPurposeCode($tripPurposeCode)
            ->setWaitListCriteria($waitListCriteria);
    }
    /**
     * Get BaggagePricingCriteria value
     * @return \StructType\BaggagePricingCriteriaType|null
     */
    public function getBaggagePricingCriteria()
    {
        return $this->BaggagePricingCriteria;
    }
    /**
     * Set BaggagePricingCriteria value
     * @param \StructType\BaggagePricingCriteriaType $baggagePricingCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setBaggagePricingCriteria(\StructType\BaggagePricingCriteriaType $baggagePricingCriteria = null)
    {
        $this->BaggagePricingCriteria = $baggagePricingCriteria;
        return $this;
    }
    /**
     * Get FareCriteria value
     * @return \StructType\FareCriteriaType[]|null
     */
    public function getFareCriteria()
    {
        return $this->FareCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setFareCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareCriteriaForArrayConstraintsFromSetFareCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypeFareCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypeFareCriteriaItem instanceof \StructType\FareCriteriaType) {
                $invalidValues[] = is_object($offerCriteriaTypeFareCriteriaItem) ? get_class($offerCriteriaTypeFareCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypeFareCriteriaItem), var_export($offerCriteriaTypeFareCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareCriteria property can only contain items of type \StructType\FareCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FareCriteriaType[] $fareCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setFareCriteria(array $fareCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($fareCriteriaArrayErrorMessage = self::validateFareCriteriaForArrayConstraintsFromSetFareCriteria($fareCriteria))) {
            throw new \InvalidArgumentException($fareCriteriaArrayErrorMessage, __LINE__);
        }
        $this->FareCriteria = $fareCriteria;
        return $this;
    }
    /**
     * Add item to FareCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FareCriteriaType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToFareCriteria(\StructType\FareCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FareCriteria property can only contain items of type \StructType\FareCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareCriteria[] = $item;
        return $this;
    }
    /**
     * Get PricingMethodCriteria value
     * @return \StructType\PricingMethodCriteriaType[]|null
     */
    public function getPricingMethodCriteria()
    {
        return $this->PricingMethodCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPricingMethodCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPricingMethodCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePricingMethodCriteriaForArrayConstraintsFromSetPricingMethodCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypePricingMethodCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypePricingMethodCriteriaItem instanceof \StructType\PricingMethodCriteriaType) {
                $invalidValues[] = is_object($offerCriteriaTypePricingMethodCriteriaItem) ? get_class($offerCriteriaTypePricingMethodCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypePricingMethodCriteriaItem), var_export($offerCriteriaTypePricingMethodCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PricingMethodCriteria property can only contain items of type \StructType\PricingMethodCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PricingMethodCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingMethodCriteriaType[] $pricingMethodCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setPricingMethodCriteria(array $pricingMethodCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($pricingMethodCriteriaArrayErrorMessage = self::validatePricingMethodCriteriaForArrayConstraintsFromSetPricingMethodCriteria($pricingMethodCriteria))) {
            throw new \InvalidArgumentException($pricingMethodCriteriaArrayErrorMessage, __LINE__);
        }
        $this->PricingMethodCriteria = $pricingMethodCriteria;
        return $this;
    }
    /**
     * Add item to PricingMethodCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PricingMethodCriteriaType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToPricingMethodCriteria(\StructType\PricingMethodCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PricingMethodCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The PricingMethodCriteria property can only contain items of type \StructType\PricingMethodCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PricingMethodCriteria[] = $item;
        return $this;
    }
    /**
     * Get ProgramCriteria value
     * @return \StructType\ProgramCriteriaType[]|null
     */
    public function getProgramCriteria()
    {
        return $this->ProgramCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setProgramCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setProgramCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateProgramCriteriaForArrayConstraintsFromSetProgramCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypeProgramCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypeProgramCriteriaItem instanceof \StructType\ProgramCriteriaType) {
                $invalidValues[] = is_object($offerCriteriaTypeProgramCriteriaItem) ? get_class($offerCriteriaTypeProgramCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypeProgramCriteriaItem), var_export($offerCriteriaTypeProgramCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ProgramCriteria property can only contain items of type \StructType\ProgramCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ProgramCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramCriteriaType[] $programCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setProgramCriteria(array $programCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($programCriteriaArrayErrorMessage = self::validateProgramCriteriaForArrayConstraintsFromSetProgramCriteria($programCriteria))) {
            throw new \InvalidArgumentException($programCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ProgramCriteria = $programCriteria;
        return $this;
    }
    /**
     * Add item to ProgramCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ProgramCriteriaType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToProgramCriteria(\StructType\ProgramCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ProgramCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ProgramCriteria property can only contain items of type \StructType\ProgramCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ProgramCriteria[] = $item;
        return $this;
    }
    /**
     * Get PromotionCriteria value
     * @return \StructType\PromotionType[]|null
     */
    public function getPromotionCriteria()
    {
        return $this->PromotionCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setPromotionCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPromotionCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePromotionCriteriaForArrayConstraintsFromSetPromotionCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypePromotionCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypePromotionCriteriaItem instanceof \StructType\PromotionType) {
                $invalidValues[] = is_object($offerCriteriaTypePromotionCriteriaItem) ? get_class($offerCriteriaTypePromotionCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypePromotionCriteriaItem), var_export($offerCriteriaTypePromotionCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PromotionCriteria property can only contain items of type \StructType\PromotionType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PromotionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType[] $promotionCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setPromotionCriteria(array $promotionCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($promotionCriteriaArrayErrorMessage = self::validatePromotionCriteriaForArrayConstraintsFromSetPromotionCriteria($promotionCriteria))) {
            throw new \InvalidArgumentException($promotionCriteriaArrayErrorMessage, __LINE__);
        }
        $this->PromotionCriteria = $promotionCriteria;
        return $this;
    }
    /**
     * Add item to PromotionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\PromotionType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToPromotionCriteria(\StructType\PromotionType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PromotionType) {
            throw new \InvalidArgumentException(sprintf('The PromotionCriteria property can only contain items of type \StructType\PromotionType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PromotionCriteria[] = $item;
        return $this;
    }
    /**
     * Get SeatCriteria value
     * @return \StructType\SeatCriteriaType[]|null
     */
    public function getSeatCriteria()
    {
        return $this->SeatCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSeatCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSeatCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSeatCriteriaForArrayConstraintsFromSetSeatCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypeSeatCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypeSeatCriteriaItem instanceof \StructType\SeatCriteriaType) {
                $invalidValues[] = is_object($offerCriteriaTypeSeatCriteriaItem) ? get_class($offerCriteriaTypeSeatCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypeSeatCriteriaItem), var_export($offerCriteriaTypeSeatCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SeatCriteria property can only contain items of type \StructType\SeatCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SeatCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatCriteriaType[] $seatCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setSeatCriteria(array $seatCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($seatCriteriaArrayErrorMessage = self::validateSeatCriteriaForArrayConstraintsFromSetSeatCriteria($seatCriteria))) {
            throw new \InvalidArgumentException($seatCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SeatCriteria = $seatCriteria;
        return $this;
    }
    /**
     * Add item to SeatCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SeatCriteriaType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToSeatCriteria(\StructType\SeatCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SeatCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The SeatCriteria property can only contain items of type \StructType\SeatCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SeatCriteria[] = $item;
        return $this;
    }
    /**
     * Get ServiceCriteria value
     * @return \StructType\ServiceCriteriaType[]|null
     */
    public function getServiceCriteria()
    {
        return $this->ServiceCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setServiceCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setServiceCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateServiceCriteriaForArrayConstraintsFromSetServiceCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypeServiceCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypeServiceCriteriaItem instanceof \StructType\ServiceCriteriaType) {
                $invalidValues[] = is_object($offerCriteriaTypeServiceCriteriaItem) ? get_class($offerCriteriaTypeServiceCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypeServiceCriteriaItem), var_export($offerCriteriaTypeServiceCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ServiceCriteria property can only contain items of type \StructType\ServiceCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ServiceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCriteriaType[] $serviceCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setServiceCriteria(array $serviceCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($serviceCriteriaArrayErrorMessage = self::validateServiceCriteriaForArrayConstraintsFromSetServiceCriteria($serviceCriteria))) {
            throw new \InvalidArgumentException($serviceCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ServiceCriteria = $serviceCriteria;
        return $this;
    }
    /**
     * Add item to ServiceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ServiceCriteriaType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToServiceCriteria(\StructType\ServiceCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ServiceCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ServiceCriteria property can only contain items of type \StructType\ServiceCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ServiceCriteria[] = $item;
        return $this;
    }
    /**
     * Get SpecialNeedsCriteria value
     * @return \StructType\SpecialServiceType[]|null
     */
    public function getSpecialNeedsCriteria()
    {
        return $this->SpecialNeedsCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecialNeedsCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecialNeedsCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecialNeedsCriteriaForArrayConstraintsFromSetSpecialNeedsCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $offerCriteriaTypeSpecialNeedsCriteriaItem) {
            // validation for constraint: itemType
            if (!$offerCriteriaTypeSpecialNeedsCriteriaItem instanceof \StructType\SpecialServiceType) {
                $invalidValues[] = is_object($offerCriteriaTypeSpecialNeedsCriteriaItem) ? get_class($offerCriteriaTypeSpecialNeedsCriteriaItem) : sprintf('%s(%s)', gettype($offerCriteriaTypeSpecialNeedsCriteriaItem), var_export($offerCriteriaTypeSpecialNeedsCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecialNeedsCriteria property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecialNeedsCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType[] $specialNeedsCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setSpecialNeedsCriteria(array $specialNeedsCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($specialNeedsCriteriaArrayErrorMessage = self::validateSpecialNeedsCriteriaForArrayConstraintsFromSetSpecialNeedsCriteria($specialNeedsCriteria))) {
            throw new \InvalidArgumentException($specialNeedsCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SpecialNeedsCriteria = $specialNeedsCriteria;
        return $this;
    }
    /**
     * Add item to SpecialNeedsCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SpecialServiceType $item
     * @return \StructType\OfferCriteriaType
     */
    public function addToSpecialNeedsCriteria(\StructType\SpecialServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SpecialServiceType) {
            throw new \InvalidArgumentException(sprintf('The SpecialNeedsCriteria property can only contain items of type \StructType\SpecialServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecialNeedsCriteria[] = $item;
        return $this;
    }
    /**
     * Get TripPurposeCode value
     * @return string|null
     */
    public function getTripPurposeCode()
    {
        return $this->TripPurposeCode;
    }
    /**
     * Set TripPurposeCode value
     * @param string $tripPurposeCode
     * @return \StructType\OfferCriteriaType
     */
    public function setTripPurposeCode($tripPurposeCode = null)
    {
        // validation for constraint: string
        if (!is_null($tripPurposeCode) && !is_string($tripPurposeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripPurposeCode, true), gettype($tripPurposeCode)), __LINE__);
        }
        $this->TripPurposeCode = $tripPurposeCode;
        return $this;
    }
    /**
     * Get WaitListCriteria value
     * @return \StructType\PrefLevelType|null
     */
    public function getWaitListCriteria()
    {
        return $this->WaitListCriteria;
    }
    /**
     * Set WaitListCriteria value
     * @param \StructType\PrefLevelType $waitListCriteria
     * @return \StructType\OfferCriteriaType
     */
    public function setWaitListCriteria(\StructType\PrefLevelType $waitListCriteria = null)
    {
        $this->WaitListCriteria = $waitListCriteria;
        return $this;
    }
}
