<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for NameChangeServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: The instance of a specific flight or Service Definition as it has been offered (and eventually ordered and consumed) in the context of a specific Offer and/or Order.
 * @subpackage Structs
 */
class NameChangeServiceType extends AbstractStructBase
{
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID within this message | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PaxRefID;
    /**
     * The ServiceDefinitionRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Service Definition ID within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceDefinitionRefID;
    /**
     * The ServiceID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies a Service within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceID;
    /**
     * Constructor method for NameChangeServiceType
     * @uses NameChangeServiceType::setPaxRefID()
     * @uses NameChangeServiceType::setServiceDefinitionRefID()
     * @uses NameChangeServiceType::setServiceID()
     * @param string $paxRefID
     * @param string $serviceDefinitionRefID
     * @param string $serviceID
     */
    public function __construct($paxRefID = null, $serviceDefinitionRefID = null, $serviceID = null)
    {
        $this
            ->setPaxRefID($paxRefID)
            ->setServiceDefinitionRefID($serviceDefinitionRefID)
            ->setServiceID($serviceID);
    }
    /**
     * Get PaxRefID value
     * @return string
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * Set PaxRefID value
     * @param string $paxRefID
     * @return \StructType\NameChangeServiceType
     */
    public function setPaxRefID($paxRefID = null)
    {
        // validation for constraint: string
        if (!is_null($paxRefID) && !is_string($paxRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paxRefID, true), gettype($paxRefID)), __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Get ServiceDefinitionRefID value
     * @return string
     */
    public function getServiceDefinitionRefID()
    {
        return $this->ServiceDefinitionRefID;
    }
    /**
     * Set ServiceDefinitionRefID value
     * @param string $serviceDefinitionRefID
     * @return \StructType\NameChangeServiceType
     */
    public function setServiceDefinitionRefID($serviceDefinitionRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceDefinitionRefID) && !is_string($serviceDefinitionRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceDefinitionRefID, true), gettype($serviceDefinitionRefID)), __LINE__);
        }
        $this->ServiceDefinitionRefID = $serviceDefinitionRefID;
        return $this;
    }
    /**
     * Get ServiceID value
     * @return string
     */
    public function getServiceID()
    {
        return $this->ServiceID;
    }
    /**
     * Set ServiceID value
     * @param string $serviceID
     * @return \StructType\NameChangeServiceType
     */
    public function setServiceID($serviceID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceID) && !is_string($serviceID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceID, true), gettype($serviceID)), __LINE__);
        }
        $this->ServiceID = $serviceID;
        return $this;
    }
}
