<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MetadataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Message wide metadata information.
 * @subpackage Structs
 */
class MetadataType extends AbstractStructBase
{
    /**
     * The CodesetMetadata
     * Meta information extracted from the WSDL
     * - documentation: Pre-defined code set metadata.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CodesetMetadataType[]
     */
    public $CodesetMetadata;
    /**
     * The FieldMetadata
     * Meta information extracted from the WSDL
     * - documentation: Defines implementation specific fields which should be populated.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FieldMetadataType[]
     */
    public $FieldMetadata;
    /**
     * Constructor method for MetadataType
     * @uses MetadataType::setCodesetMetadata()
     * @uses MetadataType::setFieldMetadata()
     * @param \StructType\CodesetMetadataType[] $codesetMetadata
     * @param \StructType\FieldMetadataType[] $fieldMetadata
     */
    public function __construct(array $codesetMetadata = array(), array $fieldMetadata = array())
    {
        $this
            ->setCodesetMetadata($codesetMetadata)
            ->setFieldMetadata($fieldMetadata);
    }
    /**
     * Get CodesetMetadata value
     * @return \StructType\CodesetMetadataType[]|null
     */
    public function getCodesetMetadata()
    {
        return $this->CodesetMetadata;
    }
    /**
     * This method is responsible for validating the values passed to the setCodesetMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCodesetMetadata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCodesetMetadataForArrayConstraintsFromSetCodesetMetadata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $metadataTypeCodesetMetadataItem) {
            // validation for constraint: itemType
            if (!$metadataTypeCodesetMetadataItem instanceof \StructType\CodesetMetadataType) {
                $invalidValues[] = is_object($metadataTypeCodesetMetadataItem) ? get_class($metadataTypeCodesetMetadataItem) : sprintf('%s(%s)', gettype($metadataTypeCodesetMetadataItem), var_export($metadataTypeCodesetMetadataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CodesetMetadata property can only contain items of type \StructType\CodesetMetadataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CodesetMetadata value
     * @throws \InvalidArgumentException
     * @param \StructType\CodesetMetadataType[] $codesetMetadata
     * @return \StructType\MetadataType
     */
    public function setCodesetMetadata(array $codesetMetadata = array())
    {
        // validation for constraint: array
        if ('' !== ($codesetMetadataArrayErrorMessage = self::validateCodesetMetadataForArrayConstraintsFromSetCodesetMetadata($codesetMetadata))) {
            throw new \InvalidArgumentException($codesetMetadataArrayErrorMessage, __LINE__);
        }
        $this->CodesetMetadata = $codesetMetadata;
        return $this;
    }
    /**
     * Add item to CodesetMetadata value
     * @throws \InvalidArgumentException
     * @param \StructType\CodesetMetadataType $item
     * @return \StructType\MetadataType
     */
    public function addToCodesetMetadata(\StructType\CodesetMetadataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CodesetMetadataType) {
            throw new \InvalidArgumentException(sprintf('The CodesetMetadata property can only contain items of type \StructType\CodesetMetadataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CodesetMetadata[] = $item;
        return $this;
    }
    /**
     * Get FieldMetadata value
     * @return \StructType\FieldMetadataType[]|null
     */
    public function getFieldMetadata()
    {
        return $this->FieldMetadata;
    }
    /**
     * This method is responsible for validating the values passed to the setFieldMetadata method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFieldMetadata method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFieldMetadataForArrayConstraintsFromSetFieldMetadata(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $metadataTypeFieldMetadataItem) {
            // validation for constraint: itemType
            if (!$metadataTypeFieldMetadataItem instanceof \StructType\FieldMetadataType) {
                $invalidValues[] = is_object($metadataTypeFieldMetadataItem) ? get_class($metadataTypeFieldMetadataItem) : sprintf('%s(%s)', gettype($metadataTypeFieldMetadataItem), var_export($metadataTypeFieldMetadataItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FieldMetadata property can only contain items of type \StructType\FieldMetadataType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FieldMetadata value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldMetadataType[] $fieldMetadata
     * @return \StructType\MetadataType
     */
    public function setFieldMetadata(array $fieldMetadata = array())
    {
        // validation for constraint: array
        if ('' !== ($fieldMetadataArrayErrorMessage = self::validateFieldMetadataForArrayConstraintsFromSetFieldMetadata($fieldMetadata))) {
            throw new \InvalidArgumentException($fieldMetadataArrayErrorMessage, __LINE__);
        }
        $this->FieldMetadata = $fieldMetadata;
        return $this;
    }
    /**
     * Add item to FieldMetadata value
     * @throws \InvalidArgumentException
     * @param \StructType\FieldMetadataType $item
     * @return \StructType\MetadataType
     */
    public function addToFieldMetadata(\StructType\FieldMetadataType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FieldMetadataType) {
            throw new \InvalidArgumentException(sprintf('The FieldMetadata property can only contain items of type \StructType\FieldMetadataType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FieldMetadata[] = $item;
        return $this;
    }
}
