<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MediaResourceRefType StructType
 * Meta information extracted from the WSDL
 * - documentation: An external resource such as an Image, Video, PDF or other which is available for display
 * @subpackage Structs
 */
class MediaResourceRefType extends AbstractStructBase
{
    /**
     * The ResourceURI
     * Meta information extracted from the WSDL
     * - documentation: URL of the Seller where the Payer is expected to be redirected following the payment process on the delegated checkout page. | A string of characters used to identify a resource. Such identification enables interaction with
     * representations of the resource over a network, typically the World Wide Web, using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ResourceURI;
    /**
     * The ContentType
     * Meta information extracted from the WSDL
     * - documentation: An identifier for a file format or content type of the rendered output. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContentType;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description of the referenced media. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * Constructor method for MediaResourceRefType
     * @uses MediaResourceRefType::setResourceURI()
     * @uses MediaResourceRefType::setContentType()
     * @uses MediaResourceRefType::setDescText()
     * @param string $resourceURI
     * @param string $contentType
     * @param string $descText
     */
    public function __construct($resourceURI = null, $contentType = null, $descText = null)
    {
        $this
            ->setResourceURI($resourceURI)
            ->setContentType($contentType)
            ->setDescText($descText);
    }
    /**
     * Get ResourceURI value
     * @return string
     */
    public function getResourceURI()
    {
        return $this->ResourceURI;
    }
    /**
     * Set ResourceURI value
     * @param string $resourceURI
     * @return \StructType\MediaResourceRefType
     */
    public function setResourceURI($resourceURI = null)
    {
        // validation for constraint: string
        if (!is_null($resourceURI) && !is_string($resourceURI)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($resourceURI, true), gettype($resourceURI)), __LINE__);
        }
        $this->ResourceURI = $resourceURI;
        return $this;
    }
    /**
     * Get ContentType value
     * @return string|null
     */
    public function getContentType()
    {
        return $this->ContentType;
    }
    /**
     * Set ContentType value
     * @param string $contentType
     * @return \StructType\MediaResourceRefType
     */
    public function setContentType($contentType = null)
    {
        // validation for constraint: string
        if (!is_null($contentType) && !is_string($contentType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contentType, true), gettype($contentType)), __LINE__);
        }
        $this->ContentType = $contentType;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\MediaResourceRefType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
}
