<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MatchedOrderType StructType
 * Meta information extracted from the WSDL
 * - documentation: List of Order IDs and order information which match the Filter Criteria specified in OrderListRQ.
 * @subpackage Structs
 */
class MatchedOrderType extends AbstractStructBase
{
    /**
     * The OrderRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Order's Order ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderRefID;
    /**
     * The Arrival
     * Meta information extracted from the WSDL
     * - documentation: Journey Arrival information related to the specified Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ArrivalType
     */
    public $Arrival;
    /**
     * The CreationDateTime
     * Meta information extracted from the WSDL
     * - documentation: Date at which the Order was created. | A date time identifies a date and time of day to various common resolutions: year, month, week, day, hour, minute, second, and fraction of second.
     * - base: xs:dateTime
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $CreationDateTime;
    /**
     * The Dep
     * Meta information extracted from the WSDL
     * - documentation: Journey departure information related to the specified Order.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DepType
     */
    public $Dep;
    /**
     * The OrderStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Status instance. See ATSB Codeset OrderStatus for possible values. | The possible statuses of an Order {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Status, coded{/codeListName}
     * {codeListIdentifier}ORDERSTATUS{/codeListIdentifier} | represents the statuses of an Order
     * - base: OrderStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $OrderStatusCode;
    /**
     * The PaxGroup
     * Meta information extracted from the WSDL
     * - documentation: A number of individual passengers traveling under one commercial name that associates them. E.g. a Tour group or a group for sales allotment from airline to agency. Group bookings are subject to special booking rules and may be
     * eligible for special fare rules. Usage and nature of groups is left to bilateral agreements.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxGroupType
     */
    public $PaxGroup;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The TicketingStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Ticketing Status. Examples: Requested, Ticketed, Other | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketingStatusCode;
    /**
     * The TravelAgency
     * Meta information extracted from the WSDL
     * - documentation: A private retailer or public service that provides travel and tourism related services to the public on behalf of suppliers such as activities, airlines, car rentals, cruise lines, hotels, railways, travel insurance, and package
     * tours.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\TravelAgencyType
     */
    public $TravelAgency;
    /**
     * Constructor method for MatchedOrderType
     * @uses MatchedOrderType::setOrderRefID()
     * @uses MatchedOrderType::setArrival()
     * @uses MatchedOrderType::setCreationDateTime()
     * @uses MatchedOrderType::setDep()
     * @uses MatchedOrderType::setOrderStatusCode()
     * @uses MatchedOrderType::setPaxGroup()
     * @uses MatchedOrderType::setPaxList()
     * @uses MatchedOrderType::setTicketingStatusCode()
     * @uses MatchedOrderType::setTravelAgency()
     * @param string $orderRefID
     * @param \StructType\ArrivalType $arrival
     * @param string $creationDateTime
     * @param \StructType\DepType $dep
     * @param string $orderStatusCode
     * @param \StructType\PaxGroupType $paxGroup
     * @param \StructType\PaxListType $paxList
     * @param string $ticketingStatusCode
     * @param \StructType\TravelAgencyType $travelAgency
     */
    public function __construct($orderRefID = null, \StructType\ArrivalType $arrival = null, $creationDateTime = null, \StructType\DepType $dep = null, $orderStatusCode = null, \StructType\PaxGroupType $paxGroup = null, \StructType\PaxListType $paxList = null, $ticketingStatusCode = null, \StructType\TravelAgencyType $travelAgency = null)
    {
        $this
            ->setOrderRefID($orderRefID)
            ->setArrival($arrival)
            ->setCreationDateTime($creationDateTime)
            ->setDep($dep)
            ->setOrderStatusCode($orderStatusCode)
            ->setPaxGroup($paxGroup)
            ->setPaxList($paxList)
            ->setTicketingStatusCode($ticketingStatusCode)
            ->setTravelAgency($travelAgency);
    }
    /**
     * Get OrderRefID value
     * @return string
     */
    public function getOrderRefID()
    {
        return $this->OrderRefID;
    }
    /**
     * Set OrderRefID value
     * @param string $orderRefID
     * @return \StructType\MatchedOrderType
     */
    public function setOrderRefID($orderRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderRefID) && !is_string($orderRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderRefID, true), gettype($orderRefID)), __LINE__);
        }
        $this->OrderRefID = $orderRefID;
        return $this;
    }
    /**
     * Get Arrival value
     * @return \StructType\ArrivalType|null
     */
    public function getArrival()
    {
        return $this->Arrival;
    }
    /**
     * Set Arrival value
     * @param \StructType\ArrivalType $arrival
     * @return \StructType\MatchedOrderType
     */
    public function setArrival(\StructType\ArrivalType $arrival = null)
    {
        $this->Arrival = $arrival;
        return $this;
    }
    /**
     * Get CreationDateTime value
     * @return string|null
     */
    public function getCreationDateTime()
    {
        return $this->CreationDateTime;
    }
    /**
     * Set CreationDateTime value
     * @param string $creationDateTime
     * @return \StructType\MatchedOrderType
     */
    public function setCreationDateTime($creationDateTime = null)
    {
        // validation for constraint: string
        if (!is_null($creationDateTime) && !is_string($creationDateTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDateTime, true), gettype($creationDateTime)), __LINE__);
        }
        $this->CreationDateTime = $creationDateTime;
        return $this;
    }
    /**
     * Get Dep value
     * @return \StructType\DepType|null
     */
    public function getDep()
    {
        return $this->Dep;
    }
    /**
     * Set Dep value
     * @param \StructType\DepType $dep
     * @return \StructType\MatchedOrderType
     */
    public function setDep(\StructType\DepType $dep = null)
    {
        $this->Dep = $dep;
        return $this;
    }
    /**
     * Get OrderStatusCode value
     * @return string|null
     */
    public function getOrderStatusCode()
    {
        return $this->OrderStatusCode;
    }
    /**
     * Set OrderStatusCode value
     * @param string $orderStatusCode
     * @return \StructType\MatchedOrderType
     */
    public function setOrderStatusCode($orderStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($orderStatusCode) && !is_string($orderStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderStatusCode, true), gettype($orderStatusCode)), __LINE__);
        }
        $this->OrderStatusCode = $orderStatusCode;
        return $this;
    }
    /**
     * Get PaxGroup value
     * @return \StructType\PaxGroupType|null
     */
    public function getPaxGroup()
    {
        return $this->PaxGroup;
    }
    /**
     * Set PaxGroup value
     * @param \StructType\PaxGroupType $paxGroup
     * @return \StructType\MatchedOrderType
     */
    public function setPaxGroup(\StructType\PaxGroupType $paxGroup = null)
    {
        $this->PaxGroup = $paxGroup;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\MatchedOrderType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get TicketingStatusCode value
     * @return string|null
     */
    public function getTicketingStatusCode()
    {
        return $this->TicketingStatusCode;
    }
    /**
     * Set TicketingStatusCode value
     * @param string $ticketingStatusCode
     * @return \StructType\MatchedOrderType
     */
    public function setTicketingStatusCode($ticketingStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketingStatusCode) && !is_string($ticketingStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketingStatusCode, true), gettype($ticketingStatusCode)), __LINE__);
        }
        $this->TicketingStatusCode = $ticketingStatusCode;
        return $this;
    }
    /**
     * Get TravelAgency value
     * @return \StructType\TravelAgencyType|null
     */
    public function getTravelAgency()
    {
        return $this->TravelAgency;
    }
    /**
     * Set TravelAgency value
     * @param \StructType\TravelAgencyType $travelAgency
     * @return \StructType\MatchedOrderType
     */
    public function setTravelAgency(\StructType\TravelAgencyType $travelAgency = null)
    {
        $this->TravelAgency = $travelAgency;
        return $this;
    }
}
