<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LoyaltyRedemptionType StructType
 * Meta information extracted from the WSDL
 * - documentation: A form of payment by which the customer uses a virtual currency of a Loyalty Program Account (such as air miles) in exchange for goods or services.
 * @subpackage Structs
 */
class LoyaltyRedemptionType extends AbstractStructBase
{
    /**
     * The CertificateNumber
     * Meta information extracted from the WSDL
     * - documentation: The loyalty redemption certificate number. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var float[]
     */
    public $CertificateNumber;
    /**
     * The LoyaltyCurAmount
     * Meta information extracted from the WSDL
     * - documentation: The quantity of loyalty units redeemed. Example: 15000
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyAmountType
     */
    public $LoyaltyCurAmount;
    /**
     * The LoyaltyProgramAccount
     * Meta information extracted from the WSDL
     * - documentation: An account set up for a customer within a rewards program which holds funds on behalf of that customer.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\LoyaltyProgramAccountType
     */
    public $LoyaltyProgramAccount;
    /**
     * Constructor method for LoyaltyRedemptionType
     * @uses LoyaltyRedemptionType::setCertificateNumber()
     * @uses LoyaltyRedemptionType::setLoyaltyCurAmount()
     * @uses LoyaltyRedemptionType::setLoyaltyProgramAccount()
     * @param float[] $certificateNumber
     * @param \StructType\LoyaltyAmountType $loyaltyCurAmount
     * @param \StructType\LoyaltyProgramAccountType $loyaltyProgramAccount
     */
    public function __construct(array $certificateNumber = array(), \StructType\LoyaltyAmountType $loyaltyCurAmount = null, \StructType\LoyaltyProgramAccountType $loyaltyProgramAccount = null)
    {
        $this
            ->setCertificateNumber($certificateNumber)
            ->setLoyaltyCurAmount($loyaltyCurAmount)
            ->setLoyaltyProgramAccount($loyaltyProgramAccount);
    }
    /**
     * Get CertificateNumber value
     * @return float[]|null
     */
    public function getCertificateNumber()
    {
        return $this->CertificateNumber;
    }
    /**
     * This method is responsible for validating the values passed to the setCertificateNumber method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCertificateNumber method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCertificateNumberForArrayConstraintsFromSetCertificateNumber(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $loyaltyRedemptionTypeCertificateNumberItem) {
            // validation for constraint: itemType
            if (!(is_float($loyaltyRedemptionTypeCertificateNumberItem) || is_numeric($loyaltyRedemptionTypeCertificateNumberItem))) {
                $invalidValues[] = is_object($loyaltyRedemptionTypeCertificateNumberItem) ? get_class($loyaltyRedemptionTypeCertificateNumberItem) : sprintf('%s(%s)', gettype($loyaltyRedemptionTypeCertificateNumberItem), var_export($loyaltyRedemptionTypeCertificateNumberItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CertificateNumber property can only contain items of type decimal, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CertificateNumber value
     * @throws \InvalidArgumentException
     * @param float[] $certificateNumber
     * @return \StructType\LoyaltyRedemptionType
     */
    public function setCertificateNumber(array $certificateNumber = array())
    {
        // validation for constraint: array
        if ('' !== ($certificateNumberArrayErrorMessage = self::validateCertificateNumberForArrayConstraintsFromSetCertificateNumber($certificateNumber))) {
            throw new \InvalidArgumentException($certificateNumberArrayErrorMessage, __LINE__);
        }
        $this->CertificateNumber = $certificateNumber;
        return $this;
    }
    /**
     * Add item to CertificateNumber value
     * @throws \InvalidArgumentException
     * @param float $item
     * @return \StructType\LoyaltyRedemptionType
     */
    public function addToCertificateNumber($item)
    {
        // validation for constraint: itemType
        if (!(is_float($item) || is_numeric($item))) {
            throw new \InvalidArgumentException(sprintf('The CertificateNumber property can only contain items of type decimal, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CertificateNumber[] = $item;
        return $this;
    }
    /**
     * Get LoyaltyCurAmount value
     * @return \StructType\LoyaltyAmountType|null
     */
    public function getLoyaltyCurAmount()
    {
        return $this->LoyaltyCurAmount;
    }
    /**
     * Set LoyaltyCurAmount value
     * @param \StructType\LoyaltyAmountType $loyaltyCurAmount
     * @return \StructType\LoyaltyRedemptionType
     */
    public function setLoyaltyCurAmount(\StructType\LoyaltyAmountType $loyaltyCurAmount = null)
    {
        $this->LoyaltyCurAmount = $loyaltyCurAmount;
        return $this;
    }
    /**
     * Get LoyaltyProgramAccount value
     * @return \StructType\LoyaltyProgramAccountType|null
     */
    public function getLoyaltyProgramAccount()
    {
        return $this->LoyaltyProgramAccount;
    }
    /**
     * Set LoyaltyProgramAccount value
     * @param \StructType\LoyaltyProgramAccountType $loyaltyProgramAccount
     * @return \StructType\LoyaltyRedemptionType
     */
    public function setLoyaltyProgramAccount(\StructType\LoyaltyProgramAccountType $loyaltyProgramAccount = null)
    {
        $this->LoyaltyProgramAccount = $loyaltyProgramAccount;
        return $this;
    }
}
