<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for KeyValuePropertyType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contextual information to further describe something using a key-value pair.
 * @subpackage Structs
 */
class KeyValuePropertyType extends AbstractStructBase
{
    /**
     * The KeyText
     * Meta information extracted from the WSDL
     * - documentation: Name or ID of the Keyword. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KeyText;
    /**
     * The ValueText
     * Meta information extracted from the WSDL
     * - documentation: Value corresponding to the associated Keyword. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ValueText;
    /**
     * The PrefLevel
     * Meta information extracted from the WSDL
     * - documentation: Information supporting a preference including preference level code (Examples: Preferred, Required or Exclude.).
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PrefLevelType
     */
    public $PrefLevel;
    /**
     * Constructor method for KeyValuePropertyType
     * @uses KeyValuePropertyType::setKeyText()
     * @uses KeyValuePropertyType::setValueText()
     * @uses KeyValuePropertyType::setPrefLevel()
     * @param string $keyText
     * @param string $valueText
     * @param \StructType\PrefLevelType $prefLevel
     */
    public function __construct($keyText = null, $valueText = null, \StructType\PrefLevelType $prefLevel = null)
    {
        $this
            ->setKeyText($keyText)
            ->setValueText($valueText)
            ->setPrefLevel($prefLevel);
    }
    /**
     * Get KeyText value
     * @return string
     */
    public function getKeyText()
    {
        return $this->KeyText;
    }
    /**
     * Set KeyText value
     * @param string $keyText
     * @return \StructType\KeyValuePropertyType
     */
    public function setKeyText($keyText = null)
    {
        // validation for constraint: string
        if (!is_null($keyText) && !is_string($keyText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyText, true), gettype($keyText)), __LINE__);
        }
        $this->KeyText = $keyText;
        return $this;
    }
    /**
     * Get ValueText value
     * @return string
     */
    public function getValueText()
    {
        return $this->ValueText;
    }
    /**
     * Set ValueText value
     * @param string $valueText
     * @return \StructType\KeyValuePropertyType
     */
    public function setValueText($valueText = null)
    {
        // validation for constraint: string
        if (!is_null($valueText) && !is_string($valueText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($valueText, true), gettype($valueText)), __LINE__);
        }
        $this->ValueText = $valueText;
        return $this;
    }
    /**
     * Get PrefLevel value
     * @return \StructType\PrefLevelType|null
     */
    public function getPrefLevel()
    {
        return $this->PrefLevel;
    }
    /**
     * Set PrefLevel value
     * @param \StructType\PrefLevelType $prefLevel
     * @return \StructType\KeyValuePropertyType
     */
    public function setPrefLevel(\StructType\PrefLevelType $prefLevel = null)
    {
        $this->PrefLevel = $prefLevel;
        return $this;
    }
}
