<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JourneyOverviewType StructType
 * Meta information extracted from the WSDL
 * - documentation: Summary of proposed Journey information in the context of this specific Offer.
 * @subpackage Structs
 */
class JourneyOverviewType extends AbstractStructBase
{
    /**
     * The JourneyPriceClass
     * Meta information extracted from the WSDL
     * - documentation: Price class information per Journey.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\JourneyPriceClassType[]
     */
    public $JourneyPriceClass;
    /**
     * The PriceClassRefID
     * Meta information extracted from the WSDL
     * - documentation: Itinerary level Price Class ref | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PriceClassRefID;
    /**
     * Constructor method for JourneyOverviewType
     * @uses JourneyOverviewType::setJourneyPriceClass()
     * @uses JourneyOverviewType::setPriceClassRefID()
     * @param \StructType\JourneyPriceClassType[] $journeyPriceClass
     * @param string $priceClassRefID
     */
    public function __construct(array $journeyPriceClass = array(), $priceClassRefID = null)
    {
        $this
            ->setJourneyPriceClass($journeyPriceClass)
            ->setPriceClassRefID($priceClassRefID);
    }
    /**
     * Get JourneyPriceClass value
     * @return \StructType\JourneyPriceClassType[]
     */
    public function getJourneyPriceClass()
    {
        return $this->JourneyPriceClass;
    }
    /**
     * This method is responsible for validating the values passed to the setJourneyPriceClass method
     * This method is willingly generated in order to preserve the one-line inline validation within the setJourneyPriceClass method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateJourneyPriceClassForArrayConstraintsFromSetJourneyPriceClass(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $journeyOverviewTypeJourneyPriceClassItem) {
            // validation for constraint: itemType
            if (!$journeyOverviewTypeJourneyPriceClassItem instanceof \StructType\JourneyPriceClassType) {
                $invalidValues[] = is_object($journeyOverviewTypeJourneyPriceClassItem) ? get_class($journeyOverviewTypeJourneyPriceClassItem) : sprintf('%s(%s)', gettype($journeyOverviewTypeJourneyPriceClassItem), var_export($journeyOverviewTypeJourneyPriceClassItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The JourneyPriceClass property can only contain items of type \StructType\JourneyPriceClassType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set JourneyPriceClass value
     * @throws \InvalidArgumentException
     * @param \StructType\JourneyPriceClassType[] $journeyPriceClass
     * @return \StructType\JourneyOverviewType
     */
    public function setJourneyPriceClass(array $journeyPriceClass = array())
    {
        // validation for constraint: array
        if ('' !== ($journeyPriceClassArrayErrorMessage = self::validateJourneyPriceClassForArrayConstraintsFromSetJourneyPriceClass($journeyPriceClass))) {
            throw new \InvalidArgumentException($journeyPriceClassArrayErrorMessage, __LINE__);
        }
        $this->JourneyPriceClass = $journeyPriceClass;
        return $this;
    }
    /**
     * Add item to JourneyPriceClass value
     * @throws \InvalidArgumentException
     * @param \StructType\JourneyPriceClassType $item
     * @return \StructType\JourneyOverviewType
     */
    public function addToJourneyPriceClass(\StructType\JourneyPriceClassType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\JourneyPriceClassType) {
            throw new \InvalidArgumentException(sprintf('The JourneyPriceClass property can only contain items of type \StructType\JourneyPriceClassType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->JourneyPriceClass[] = $item;
        return $this;
    }
    /**
     * Get PriceClassRefID value
     * @return string|null
     */
    public function getPriceClassRefID()
    {
        return $this->PriceClassRefID;
    }
    /**
     * Set PriceClassRefID value
     * @param string $priceClassRefID
     * @return \StructType\JourneyOverviewType
     */
    public function setPriceClassRefID($priceClassRefID = null)
    {
        // validation for constraint: string
        if (!is_null($priceClassRefID) && !is_string($priceClassRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceClassRefID, true), gettype($priceClassRefID)), __LINE__);
        }
        $this->PriceClassRefID = $priceClassRefID;
        return $this;
    }
}
