<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for JourneyDurationCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Total journey travel time per bound preferences. This includes the sum of all flight durations as well as connection times.
 * @subpackage Structs
 */
class JourneyDurationCriteriaType extends AbstractStructBase
{
    /**
     * The MaximumTimeDuration
     * Meta information extracted from the WSDL
     * - documentation: Preferred maximum time for this Journey. | A duration is the specification of a length of time without a fixed start or end time, expressed in Gregorian calendar time units (Year, Month, Week, or Day) and Hours, Minutes or Seconds
     * - base: xs:duration
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $MaximumTimeDuration;
    /**
     * The PrefCode
     * Meta information extracted from the WSDL
     * - documentation: Level of preference requested. Examples: Preferred, Required or Exclude.
     * - base: PrefLevelCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $PrefCode;
    /**
     * Constructor method for JourneyDurationCriteriaType
     * @uses JourneyDurationCriteriaType::setMaximumTimeDuration()
     * @uses JourneyDurationCriteriaType::setPrefCode()
     * @param string $maximumTimeDuration
     * @param string $prefCode
     */
    public function __construct($maximumTimeDuration = null, $prefCode = null)
    {
        $this
            ->setMaximumTimeDuration($maximumTimeDuration)
            ->setPrefCode($prefCode);
    }
    /**
     * Get MaximumTimeDuration value
     * @return string
     */
    public function getMaximumTimeDuration()
    {
        return $this->MaximumTimeDuration;
    }
    /**
     * Set MaximumTimeDuration value
     * @param string $maximumTimeDuration
     * @return \StructType\JourneyDurationCriteriaType
     */
    public function setMaximumTimeDuration($maximumTimeDuration = null)
    {
        // validation for constraint: string
        if (!is_null($maximumTimeDuration) && !is_string($maximumTimeDuration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($maximumTimeDuration, true), gettype($maximumTimeDuration)), __LINE__);
        }
        $this->MaximumTimeDuration = $maximumTimeDuration;
        return $this;
    }
    /**
     * Get PrefCode value
     * @return string
     */
    public function getPrefCode()
    {
        return $this->PrefCode;
    }
    /**
     * Set PrefCode value
     * @param string $prefCode
     * @return \StructType\JourneyDurationCriteriaType
     */
    public function setPrefCode($prefCode = null)
    {
        // validation for constraint: string
        if (!is_null($prefCode) && !is_string($prefCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($prefCode, true), gettype($prefCode)), __LINE__);
        }
        $this->PrefCode = $prefCode;
        return $this;
    }
}
