<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOrderResponsePayloadType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payload for Interline Order response message
 * @subpackage Structs
 */
class InterlineOrderResponsePayloadType extends AbstractStructBase
{
    /**
     * The RetailerOrder
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderKeyType
     */
    public $RetailerOrder;
    /**
     * The BaggageAllowanceList
     * Meta information extracted from the WSDL
     * - documentation: Baggage allowance data list definition
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageAllowanceListType
     */
    public $BaggageAllowanceList;
    /**
     * The BaggageDisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Baggage disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\BaggageDisclosureListType
     */
    public $BaggageDisclosureList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType[]
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType[]
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType[]
     */
    public $DatedOperatingSegmentList;
    /**
     * The DisclosureList
     * Meta information extracted from the WSDL
     * - documentation: Disclosure data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DisclosureListType
     */
    public $DisclosureList;
    /**
     * The MarketingMessage
     * Meta information extracted from the WSDL
     * - documentation: Marketing message: Additional, supplementary information about the document or service.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\MarketingMessageType[]
     */
    public $MarketingMessage;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The PaxSegmentList
     * Meta information extracted from the WSDL
     * - documentation: Segment data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxSegmentListType
     */
    public $PaxSegmentList;
    /**
     * The SeatProfileList
     * Meta information extracted from the WSDL
     * - documentation: Seat Profile data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\SeatProfileListType
     */
    public $SeatProfileList;
    /**
     * The ServiceDefinitionList
     * Meta information extracted from the WSDL
     * - documentation: Service Definition data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\ServiceDefinitionListType
     */
    public $ServiceDefinitionList;
    /**
     * The SupplierOrder
     * Meta information extracted from the WSDL
     * - documentation: A Supplier order specialization of an order defined as a uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a
     * flexible range of airline products and services that are not necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may
     * support non-homogeneity, i.e. each passenger in an Order may hold different sets of order items at different prices.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SupplierOrderType[]
     */
    public $SupplierOrder;
    /**
     * The Warning
     * Meta information extracted from the WSDL
     * - documentation: Contains information related to potential business errors detected during processing of the preceding request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\WarningType
     */
    public $Warning;
    /**
     * Constructor method for InterlineOrderResponsePayloadType
     * @uses InterlineOrderResponsePayloadType::setRetailerOrder()
     * @uses InterlineOrderResponsePayloadType::setBaggageAllowanceList()
     * @uses InterlineOrderResponsePayloadType::setBaggageDisclosureList()
     * @uses InterlineOrderResponsePayloadType::setDatedMarketingSegmentList()
     * @uses InterlineOrderResponsePayloadType::setDatedOperatingLegList()
     * @uses InterlineOrderResponsePayloadType::setDatedOperatingSegmentList()
     * @uses InterlineOrderResponsePayloadType::setDisclosureList()
     * @uses InterlineOrderResponsePayloadType::setMarketingMessage()
     * @uses InterlineOrderResponsePayloadType::setPaxList()
     * @uses InterlineOrderResponsePayloadType::setPaxSegmentList()
     * @uses InterlineOrderResponsePayloadType::setSeatProfileList()
     * @uses InterlineOrderResponsePayloadType::setServiceDefinitionList()
     * @uses InterlineOrderResponsePayloadType::setSupplierOrder()
     * @uses InterlineOrderResponsePayloadType::setWarning()
     * @param \StructType\OrderKeyType $retailerOrder
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @param \StructType\DatedMarketingSegmentListType[] $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType[] $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType[] $datedOperatingSegmentList
     * @param \StructType\DisclosureListType $disclosureList
     * @param \StructType\MarketingMessageType[] $marketingMessage
     * @param \StructType\PaxListType $paxList
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @param \StructType\SeatProfileListType $seatProfileList
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @param \StructType\SupplierOrderType[] $supplierOrder
     * @param \StructType\WarningType $warning
     */
    public function __construct(\StructType\OrderKeyType $retailerOrder = null, \StructType\BaggageAllowanceListType $baggageAllowanceList = null, \StructType\BaggageDisclosureListType $baggageDisclosureList = null, array $datedMarketingSegmentList = array(), array $datedOperatingLegList = array(), array $datedOperatingSegmentList = array(), \StructType\DisclosureListType $disclosureList = null, array $marketingMessage = array(), \StructType\PaxListType $paxList = null, \StructType\PaxSegmentListType $paxSegmentList = null, \StructType\SeatProfileListType $seatProfileList = null, \StructType\ServiceDefinitionListType $serviceDefinitionList = null, array $supplierOrder = array(), \StructType\WarningType $warning = null)
    {
        $this
            ->setRetailerOrder($retailerOrder)
            ->setBaggageAllowanceList($baggageAllowanceList)
            ->setBaggageDisclosureList($baggageDisclosureList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setDisclosureList($disclosureList)
            ->setMarketingMessage($marketingMessage)
            ->setPaxList($paxList)
            ->setPaxSegmentList($paxSegmentList)
            ->setSeatProfileList($seatProfileList)
            ->setServiceDefinitionList($serviceDefinitionList)
            ->setSupplierOrder($supplierOrder)
            ->setWarning($warning);
    }
    /**
     * Get RetailerOrder value
     * @return \StructType\OrderKeyType
     */
    public function getRetailerOrder()
    {
        return $this->RetailerOrder;
    }
    /**
     * Set RetailerOrder value
     * @param \StructType\OrderKeyType $retailerOrder
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setRetailerOrder(\StructType\OrderKeyType $retailerOrder = null)
    {
        $this->RetailerOrder = $retailerOrder;
        return $this;
    }
    /**
     * Get BaggageAllowanceList value
     * @return \StructType\BaggageAllowanceListType|null
     */
    public function getBaggageAllowanceList()
    {
        return $this->BaggageAllowanceList;
    }
    /**
     * Set BaggageAllowanceList value
     * @param \StructType\BaggageAllowanceListType $baggageAllowanceList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setBaggageAllowanceList(\StructType\BaggageAllowanceListType $baggageAllowanceList = null)
    {
        $this->BaggageAllowanceList = $baggageAllowanceList;
        return $this;
    }
    /**
     * Get BaggageDisclosureList value
     * @return \StructType\BaggageDisclosureListType|null
     */
    public function getBaggageDisclosureList()
    {
        return $this->BaggageDisclosureList;
    }
    /**
     * Set BaggageDisclosureList value
     * @param \StructType\BaggageDisclosureListType $baggageDisclosureList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setBaggageDisclosureList(\StructType\BaggageDisclosureListType $baggageDisclosureList = null)
    {
        $this->BaggageDisclosureList = $baggageDisclosureList;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType[]|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegmentList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentListForArrayConstraintsFromSetDatedMarketingSegmentList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderResponsePayloadTypeDatedMarketingSegmentListItem) {
            // validation for constraint: itemType
            if (!$interlineOrderResponsePayloadTypeDatedMarketingSegmentListItem instanceof \StructType\DatedMarketingSegmentListType) {
                $invalidValues[] = is_object($interlineOrderResponsePayloadTypeDatedMarketingSegmentListItem) ? get_class($interlineOrderResponsePayloadTypeDatedMarketingSegmentListItem) : sprintf('%s(%s)', gettype($interlineOrderResponsePayloadTypeDatedMarketingSegmentListItem), var_export($interlineOrderResponsePayloadTypeDatedMarketingSegmentListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegmentList property can only contain items of type \StructType\DatedMarketingSegmentListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentListType[] $datedMarketingSegmentList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setDatedMarketingSegmentList(array $datedMarketingSegmentList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentListArrayErrorMessage = self::validateDatedMarketingSegmentListForArrayConstraintsFromSetDatedMarketingSegmentList($datedMarketingSegmentList))) {
            throw new \InvalidArgumentException($datedMarketingSegmentListArrayErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Add item to DatedMarketingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentListType $item
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function addToDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedMarketingSegmentListType) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegmentList property can only contain items of type \StructType\DatedMarketingSegmentListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedMarketingSegmentList[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType[]|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegListForArrayConstraintsFromSetDatedOperatingLegList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderResponsePayloadTypeDatedOperatingLegListItem) {
            // validation for constraint: itemType
            if (!$interlineOrderResponsePayloadTypeDatedOperatingLegListItem instanceof \StructType\DatedOperatingLegListType) {
                $invalidValues[] = is_object($interlineOrderResponsePayloadTypeDatedOperatingLegListItem) ? get_class($interlineOrderResponsePayloadTypeDatedOperatingLegListItem) : sprintf('%s(%s)', gettype($interlineOrderResponsePayloadTypeDatedOperatingLegListItem), var_export($interlineOrderResponsePayloadTypeDatedOperatingLegListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegList property can only contain items of type \StructType\DatedOperatingLegListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegListType[] $datedOperatingLegList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setDatedOperatingLegList(array $datedOperatingLegList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegListArrayErrorMessage = self::validateDatedOperatingLegListForArrayConstraintsFromSetDatedOperatingLegList($datedOperatingLegList))) {
            throw new \InvalidArgumentException($datedOperatingLegListArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegListType $item
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function addToDatedOperatingLegList(\StructType\DatedOperatingLegListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingLegListType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegList property can only contain items of type \StructType\DatedOperatingLegListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegList[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType[]|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingSegmentList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingSegmentList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingSegmentListForArrayConstraintsFromSetDatedOperatingSegmentList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderResponsePayloadTypeDatedOperatingSegmentListItem) {
            // validation for constraint: itemType
            if (!$interlineOrderResponsePayloadTypeDatedOperatingSegmentListItem instanceof \StructType\DatedOperatingSegmentListType) {
                $invalidValues[] = is_object($interlineOrderResponsePayloadTypeDatedOperatingSegmentListItem) ? get_class($interlineOrderResponsePayloadTypeDatedOperatingSegmentListItem) : sprintf('%s(%s)', gettype($interlineOrderResponsePayloadTypeDatedOperatingSegmentListItem), var_export($interlineOrderResponsePayloadTypeDatedOperatingSegmentListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingSegmentList property can only contain items of type \StructType\DatedOperatingSegmentListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentListType[] $datedOperatingSegmentList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setDatedOperatingSegmentList(array $datedOperatingSegmentList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingSegmentListArrayErrorMessage = self::validateDatedOperatingSegmentListForArrayConstraintsFromSetDatedOperatingSegmentList($datedOperatingSegmentList))) {
            throw new \InvalidArgumentException($datedOperatingSegmentListArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Add item to DatedOperatingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentListType $item
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function addToDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingSegmentListType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingSegmentList property can only contain items of type \StructType\DatedOperatingSegmentListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingSegmentList[] = $item;
        return $this;
    }
    /**
     * Get DisclosureList value
     * @return \StructType\DisclosureListType|null
     */
    public function getDisclosureList()
    {
        return $this->DisclosureList;
    }
    /**
     * Set DisclosureList value
     * @param \StructType\DisclosureListType $disclosureList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setDisclosureList(\StructType\DisclosureListType $disclosureList = null)
    {
        $this->DisclosureList = $disclosureList;
        return $this;
    }
    /**
     * Get MarketingMessage value
     * @return \StructType\MarketingMessageType[]|null
     */
    public function getMarketingMessage()
    {
        return $this->MarketingMessage;
    }
    /**
     * This method is responsible for validating the values passed to the setMarketingMessage method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMarketingMessage method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMarketingMessageForArrayConstraintsFromSetMarketingMessage(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderResponsePayloadTypeMarketingMessageItem) {
            // validation for constraint: itemType
            if (!$interlineOrderResponsePayloadTypeMarketingMessageItem instanceof \StructType\MarketingMessageType) {
                $invalidValues[] = is_object($interlineOrderResponsePayloadTypeMarketingMessageItem) ? get_class($interlineOrderResponsePayloadTypeMarketingMessageItem) : sprintf('%s(%s)', gettype($interlineOrderResponsePayloadTypeMarketingMessageItem), var_export($interlineOrderResponsePayloadTypeMarketingMessageItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MarketingMessage property can only contain items of type \StructType\MarketingMessageType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MarketingMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingMessageType[] $marketingMessage
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setMarketingMessage(array $marketingMessage = array())
    {
        // validation for constraint: array
        if ('' !== ($marketingMessageArrayErrorMessage = self::validateMarketingMessageForArrayConstraintsFromSetMarketingMessage($marketingMessage))) {
            throw new \InvalidArgumentException($marketingMessageArrayErrorMessage, __LINE__);
        }
        $this->MarketingMessage = $marketingMessage;
        return $this;
    }
    /**
     * Add item to MarketingMessage value
     * @throws \InvalidArgumentException
     * @param \StructType\MarketingMessageType $item
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function addToMarketingMessage(\StructType\MarketingMessageType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarketingMessageType) {
            throw new \InvalidArgumentException(sprintf('The MarketingMessage property can only contain items of type \StructType\MarketingMessageType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->MarketingMessage[] = $item;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get PaxSegmentList value
     * @return \StructType\PaxSegmentListType|null
     */
    public function getPaxSegmentList()
    {
        return $this->PaxSegmentList;
    }
    /**
     * Set PaxSegmentList value
     * @param \StructType\PaxSegmentListType $paxSegmentList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setPaxSegmentList(\StructType\PaxSegmentListType $paxSegmentList = null)
    {
        $this->PaxSegmentList = $paxSegmentList;
        return $this;
    }
    /**
     * Get SeatProfileList value
     * @return \StructType\SeatProfileListType|null
     */
    public function getSeatProfileList()
    {
        return $this->SeatProfileList;
    }
    /**
     * Set SeatProfileList value
     * @param \StructType\SeatProfileListType $seatProfileList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setSeatProfileList(\StructType\SeatProfileListType $seatProfileList = null)
    {
        $this->SeatProfileList = $seatProfileList;
        return $this;
    }
    /**
     * Get ServiceDefinitionList value
     * @return \StructType\ServiceDefinitionListType|null
     */
    public function getServiceDefinitionList()
    {
        return $this->ServiceDefinitionList;
    }
    /**
     * Set ServiceDefinitionList value
     * @param \StructType\ServiceDefinitionListType $serviceDefinitionList
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setServiceDefinitionList(\StructType\ServiceDefinitionListType $serviceDefinitionList = null)
    {
        $this->ServiceDefinitionList = $serviceDefinitionList;
        return $this;
    }
    /**
     * Get SupplierOrder value
     * @return \StructType\SupplierOrderType[]|null
     */
    public function getSupplierOrder()
    {
        return $this->SupplierOrder;
    }
    /**
     * This method is responsible for validating the values passed to the setSupplierOrder method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSupplierOrder method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSupplierOrderForArrayConstraintsFromSetSupplierOrder(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderResponsePayloadTypeSupplierOrderItem) {
            // validation for constraint: itemType
            if (!$interlineOrderResponsePayloadTypeSupplierOrderItem instanceof \StructType\SupplierOrderType) {
                $invalidValues[] = is_object($interlineOrderResponsePayloadTypeSupplierOrderItem) ? get_class($interlineOrderResponsePayloadTypeSupplierOrderItem) : sprintf('%s(%s)', gettype($interlineOrderResponsePayloadTypeSupplierOrderItem), var_export($interlineOrderResponsePayloadTypeSupplierOrderItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SupplierOrder property can only contain items of type \StructType\SupplierOrderType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SupplierOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOrderType[] $supplierOrder
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setSupplierOrder(array $supplierOrder = array())
    {
        // validation for constraint: array
        if ('' !== ($supplierOrderArrayErrorMessage = self::validateSupplierOrderForArrayConstraintsFromSetSupplierOrder($supplierOrder))) {
            throw new \InvalidArgumentException($supplierOrderArrayErrorMessage, __LINE__);
        }
        $this->SupplierOrder = $supplierOrder;
        return $this;
    }
    /**
     * Add item to SupplierOrder value
     * @throws \InvalidArgumentException
     * @param \StructType\SupplierOrderType $item
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function addToSupplierOrder(\StructType\SupplierOrderType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SupplierOrderType) {
            throw new \InvalidArgumentException(sprintf('The SupplierOrder property can only contain items of type \StructType\SupplierOrderType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SupplierOrder[] = $item;
        return $this;
    }
    /**
     * Get Warning value
     * @return \StructType\WarningType|null
     */
    public function getWarning()
    {
        return $this->Warning;
    }
    /**
     * Set Warning value
     * @param \StructType\WarningType $warning
     * @return \StructType\InterlineOrderResponsePayloadType
     */
    public function setWarning(\StructType\WarningType $warning = null)
    {
        $this->Warning = $warning;
        return $this;
    }
}
