<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOrderRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Interline Order request message
 * @subpackage Structs
 */
class InterlineOrderRequestType extends AbstractStructBase
{
    /**
     * The BDC
     * Meta information extracted from the WSDL
     * - documentation: Interline variant of the carrier abie. The organization which carries the passenger, baggage, or goods, and/or commits to delivering the carriage as well as any related services such as issuance of ticket, creation of Order, etc.
     * Business Identifier Fields: - Airline Designator Code - Duplicate Designator Indicator - Name
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\InterlineCarrierType
     */
    public $BDC;
    /**
     * The RetailerOrderInfo
     * Meta information extracted from the WSDL
     * - documentation: A retailer order info type
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RetailerOrderInfoType
     */
    public $RetailerOrderInfo;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType[]
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType[]
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType[]
     */
    public $DatedOperatingSegmentList;
    /**
     * The SelectedOffer
     * Meta information extracted from the WSDL
     * - documentation: Offer selected by the Passenger for requesting an Order to be created. Multiple Offers can be requested at the same time, each of which could originate from different shopping responses (each with their own ResponseIDs). Each Offer
     * selected could reference (via the OfferID) either standard Offers from an AirShoppingRS message (potentially with Flight-related services) or A-La-Carte Offers (containing optional ancillary services). These standard Offers and 'a-la-carte' Offers
     * would need to be consistent with the applicability rules defined by their relations (passengers or segments eligible for the enclosed OfferItems) and would be combined to produce a single Order, returned by the OrderViewRS message.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SelectedOfferType[]
     */
    public $SelectedOffer;
    /**
     * The SettlementInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the value of a product or service as it pertains to interline transactions.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SettlementInfoType[]
     */
    public $SettlementInfo;
    /**
     * Constructor method for InterlineOrderRequestType
     * @uses InterlineOrderRequestType::setBDC()
     * @uses InterlineOrderRequestType::setRetailerOrderInfo()
     * @uses InterlineOrderRequestType::setDatedMarketingSegmentList()
     * @uses InterlineOrderRequestType::setDatedOperatingLegList()
     * @uses InterlineOrderRequestType::setDatedOperatingSegmentList()
     * @uses InterlineOrderRequestType::setSelectedOffer()
     * @uses InterlineOrderRequestType::setSettlementInfo()
     * @param \StructType\InterlineCarrierType $bDC
     * @param \StructType\RetailerOrderInfoType $retailerOrderInfo
     * @param \StructType\DatedMarketingSegmentListType[] $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType[] $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType[] $datedOperatingSegmentList
     * @param \StructType\SelectedOfferType[] $selectedOffer
     * @param \StructType\SettlementInfoType[] $settlementInfo
     */
    public function __construct(\StructType\InterlineCarrierType $bDC = null, \StructType\RetailerOrderInfoType $retailerOrderInfo = null, array $datedMarketingSegmentList = array(), array $datedOperatingLegList = array(), array $datedOperatingSegmentList = array(), array $selectedOffer = array(), array $settlementInfo = array())
    {
        $this
            ->setBDC($bDC)
            ->setRetailerOrderInfo($retailerOrderInfo)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setSelectedOffer($selectedOffer)
            ->setSettlementInfo($settlementInfo);
    }
    /**
     * Get BDC value
     * @return \StructType\InterlineCarrierType
     */
    public function getBDC()
    {
        return $this->BDC;
    }
    /**
     * Set BDC value
     * @param \StructType\InterlineCarrierType $bDC
     * @return \StructType\InterlineOrderRequestType
     */
    public function setBDC(\StructType\InterlineCarrierType $bDC = null)
    {
        $this->BDC = $bDC;
        return $this;
    }
    /**
     * Get RetailerOrderInfo value
     * @return \StructType\RetailerOrderInfoType
     */
    public function getRetailerOrderInfo()
    {
        return $this->RetailerOrderInfo;
    }
    /**
     * Set RetailerOrderInfo value
     * @param \StructType\RetailerOrderInfoType $retailerOrderInfo
     * @return \StructType\InterlineOrderRequestType
     */
    public function setRetailerOrderInfo(\StructType\RetailerOrderInfoType $retailerOrderInfo = null)
    {
        $this->RetailerOrderInfo = $retailerOrderInfo;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType[]|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedMarketingSegmentList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedMarketingSegmentList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedMarketingSegmentListForArrayConstraintsFromSetDatedMarketingSegmentList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderRequestTypeDatedMarketingSegmentListItem) {
            // validation for constraint: itemType
            if (!$interlineOrderRequestTypeDatedMarketingSegmentListItem instanceof \StructType\DatedMarketingSegmentListType) {
                $invalidValues[] = is_object($interlineOrderRequestTypeDatedMarketingSegmentListItem) ? get_class($interlineOrderRequestTypeDatedMarketingSegmentListItem) : sprintf('%s(%s)', gettype($interlineOrderRequestTypeDatedMarketingSegmentListItem), var_export($interlineOrderRequestTypeDatedMarketingSegmentListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedMarketingSegmentList property can only contain items of type \StructType\DatedMarketingSegmentListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentListType[] $datedMarketingSegmentList
     * @return \StructType\InterlineOrderRequestType
     */
    public function setDatedMarketingSegmentList(array $datedMarketingSegmentList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedMarketingSegmentListArrayErrorMessage = self::validateDatedMarketingSegmentListForArrayConstraintsFromSetDatedMarketingSegmentList($datedMarketingSegmentList))) {
            throw new \InvalidArgumentException($datedMarketingSegmentListArrayErrorMessage, __LINE__);
        }
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Add item to DatedMarketingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedMarketingSegmentListType $item
     * @return \StructType\InterlineOrderRequestType
     */
    public function addToDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedMarketingSegmentListType) {
            throw new \InvalidArgumentException(sprintf('The DatedMarketingSegmentList property can only contain items of type \StructType\DatedMarketingSegmentListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedMarketingSegmentList[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType[]|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingLegList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingLegList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingLegListForArrayConstraintsFromSetDatedOperatingLegList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderRequestTypeDatedOperatingLegListItem) {
            // validation for constraint: itemType
            if (!$interlineOrderRequestTypeDatedOperatingLegListItem instanceof \StructType\DatedOperatingLegListType) {
                $invalidValues[] = is_object($interlineOrderRequestTypeDatedOperatingLegListItem) ? get_class($interlineOrderRequestTypeDatedOperatingLegListItem) : sprintf('%s(%s)', gettype($interlineOrderRequestTypeDatedOperatingLegListItem), var_export($interlineOrderRequestTypeDatedOperatingLegListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingLegList property can only contain items of type \StructType\DatedOperatingLegListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingLegList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegListType[] $datedOperatingLegList
     * @return \StructType\InterlineOrderRequestType
     */
    public function setDatedOperatingLegList(array $datedOperatingLegList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingLegListArrayErrorMessage = self::validateDatedOperatingLegListForArrayConstraintsFromSetDatedOperatingLegList($datedOperatingLegList))) {
            throw new \InvalidArgumentException($datedOperatingLegListArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Add item to DatedOperatingLegList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingLegListType $item
     * @return \StructType\InterlineOrderRequestType
     */
    public function addToDatedOperatingLegList(\StructType\DatedOperatingLegListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingLegListType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingLegList property can only contain items of type \StructType\DatedOperatingLegListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingLegList[] = $item;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType[]|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * This method is responsible for validating the values passed to the setDatedOperatingSegmentList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDatedOperatingSegmentList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDatedOperatingSegmentListForArrayConstraintsFromSetDatedOperatingSegmentList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderRequestTypeDatedOperatingSegmentListItem) {
            // validation for constraint: itemType
            if (!$interlineOrderRequestTypeDatedOperatingSegmentListItem instanceof \StructType\DatedOperatingSegmentListType) {
                $invalidValues[] = is_object($interlineOrderRequestTypeDatedOperatingSegmentListItem) ? get_class($interlineOrderRequestTypeDatedOperatingSegmentListItem) : sprintf('%s(%s)', gettype($interlineOrderRequestTypeDatedOperatingSegmentListItem), var_export($interlineOrderRequestTypeDatedOperatingSegmentListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DatedOperatingSegmentList property can only contain items of type \StructType\DatedOperatingSegmentListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentListType[] $datedOperatingSegmentList
     * @return \StructType\InterlineOrderRequestType
     */
    public function setDatedOperatingSegmentList(array $datedOperatingSegmentList = array())
    {
        // validation for constraint: array
        if ('' !== ($datedOperatingSegmentListArrayErrorMessage = self::validateDatedOperatingSegmentListForArrayConstraintsFromSetDatedOperatingSegmentList($datedOperatingSegmentList))) {
            throw new \InvalidArgumentException($datedOperatingSegmentListArrayErrorMessage, __LINE__);
        }
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Add item to DatedOperatingSegmentList value
     * @throws \InvalidArgumentException
     * @param \StructType\DatedOperatingSegmentListType $item
     * @return \StructType\InterlineOrderRequestType
     */
    public function addToDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DatedOperatingSegmentListType) {
            throw new \InvalidArgumentException(sprintf('The DatedOperatingSegmentList property can only contain items of type \StructType\DatedOperatingSegmentListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DatedOperatingSegmentList[] = $item;
        return $this;
    }
    /**
     * Get SelectedOffer value
     * @return \StructType\SelectedOfferType[]|null
     */
    public function getSelectedOffer()
    {
        return $this->SelectedOffer;
    }
    /**
     * This method is responsible for validating the values passed to the setSelectedOffer method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSelectedOffer method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSelectedOfferForArrayConstraintsFromSetSelectedOffer(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderRequestTypeSelectedOfferItem) {
            // validation for constraint: itemType
            if (!$interlineOrderRequestTypeSelectedOfferItem instanceof \StructType\SelectedOfferType) {
                $invalidValues[] = is_object($interlineOrderRequestTypeSelectedOfferItem) ? get_class($interlineOrderRequestTypeSelectedOfferItem) : sprintf('%s(%s)', gettype($interlineOrderRequestTypeSelectedOfferItem), var_export($interlineOrderRequestTypeSelectedOfferItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SelectedOffer property can only contain items of type \StructType\SelectedOfferType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SelectedOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferType[] $selectedOffer
     * @return \StructType\InterlineOrderRequestType
     */
    public function setSelectedOffer(array $selectedOffer = array())
    {
        // validation for constraint: array
        if ('' !== ($selectedOfferArrayErrorMessage = self::validateSelectedOfferForArrayConstraintsFromSetSelectedOffer($selectedOffer))) {
            throw new \InvalidArgumentException($selectedOfferArrayErrorMessage, __LINE__);
        }
        $this->SelectedOffer = $selectedOffer;
        return $this;
    }
    /**
     * Add item to SelectedOffer value
     * @throws \InvalidArgumentException
     * @param \StructType\SelectedOfferType $item
     * @return \StructType\InterlineOrderRequestType
     */
    public function addToSelectedOffer(\StructType\SelectedOfferType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SelectedOfferType) {
            throw new \InvalidArgumentException(sprintf('The SelectedOffer property can only contain items of type \StructType\SelectedOfferType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SelectedOffer[] = $item;
        return $this;
    }
    /**
     * Get SettlementInfo value
     * @return \StructType\SettlementInfoType[]|null
     */
    public function getSettlementInfo()
    {
        return $this->SettlementInfo;
    }
    /**
     * This method is responsible for validating the values passed to the setSettlementInfo method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSettlementInfo method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSettlementInfoForArrayConstraintsFromSetSettlementInfo(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOrderRequestTypeSettlementInfoItem) {
            // validation for constraint: itemType
            if (!$interlineOrderRequestTypeSettlementInfoItem instanceof \StructType\SettlementInfoType) {
                $invalidValues[] = is_object($interlineOrderRequestTypeSettlementInfoItem) ? get_class($interlineOrderRequestTypeSettlementInfoItem) : sprintf('%s(%s)', gettype($interlineOrderRequestTypeSettlementInfoItem), var_export($interlineOrderRequestTypeSettlementInfoItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SettlementInfo property can only contain items of type \StructType\SettlementInfoType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SettlementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SettlementInfoType[] $settlementInfo
     * @return \StructType\InterlineOrderRequestType
     */
    public function setSettlementInfo(array $settlementInfo = array())
    {
        // validation for constraint: array
        if ('' !== ($settlementInfoArrayErrorMessage = self::validateSettlementInfoForArrayConstraintsFromSetSettlementInfo($settlementInfo))) {
            throw new \InvalidArgumentException($settlementInfoArrayErrorMessage, __LINE__);
        }
        $this->SettlementInfo = $settlementInfo;
        return $this;
    }
    /**
     * Add item to SettlementInfo value
     * @throws \InvalidArgumentException
     * @param \StructType\SettlementInfoType $item
     * @return \StructType\InterlineOrderRequestType
     */
    public function addToSettlementInfo(\StructType\SettlementInfoType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SettlementInfoType) {
            throw new \InvalidArgumentException(sprintf('The SettlementInfo property can only contain items of type \StructType\SettlementInfoType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SettlementInfo[] = $item;
        return $this;
    }
}
