<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for InterlineOfferRequestType StructType
 * Meta information extracted from the WSDL
 * - documentation: Request content for Interline Offer request message
 * @subpackage Structs
 */
class InterlineOfferRequestType extends AbstractStructBase
{
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The Context
     * Meta information extracted from the WSDL
     * - documentation: This is a container for a flight request type which allow multiple Origin and Destination flight criteria to be input in this type of request.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterlineFlightRequestOriginDestinationsCriteriaType
     */
    public $Context;
    /**
     * The InterlineOfferQuery
     * Meta information extracted from the WSDL
     * - documentation: A node used to allow selection of itinerary or/and a selection of offers.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterlineOfferQueryType
     */
    public $InterlineOfferQuery;
    /**
     * The InterlinePreferences
     * Meta information extracted from the WSDL
     * - documentation: A set of Information related to how response results should be returned.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\InterlineResponseParametersRequestType
     */
    public $InterlinePreferences;
    /**
     * The PaxList
     * Meta information extracted from the WSDL
     * - documentation: Passenger data list definition.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PaxListType
     */
    public $PaxList;
    /**
     * The SearchCriteria
     * Meta information extracted from the WSDL
     * - documentation: A search criteria type for interline requests.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\InterlineSearchCriteriaRequestType[]
     */
    public $SearchCriteria;
    /**
     * Constructor method for InterlineOfferRequestType
     * @uses InterlineOfferRequestType::setContactInfoList()
     * @uses InterlineOfferRequestType::setContext()
     * @uses InterlineOfferRequestType::setInterlineOfferQuery()
     * @uses InterlineOfferRequestType::setInterlinePreferences()
     * @uses InterlineOfferRequestType::setPaxList()
     * @uses InterlineOfferRequestType::setSearchCriteria()
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\InterlineFlightRequestOriginDestinationsCriteriaType $context
     * @param \StructType\InterlineOfferQueryType $interlineOfferQuery
     * @param \StructType\InterlineResponseParametersRequestType $interlinePreferences
     * @param \StructType\PaxListType $paxList
     * @param \StructType\InterlineSearchCriteriaRequestType[] $searchCriteria
     */
    public function __construct(array $contactInfoList = array(), \StructType\InterlineFlightRequestOriginDestinationsCriteriaType $context = null, \StructType\InterlineOfferQueryType $interlineOfferQuery = null, \StructType\InterlineResponseParametersRequestType $interlinePreferences = null, \StructType\PaxListType $paxList = null, array $searchCriteria = array())
    {
        $this
            ->setContactInfoList($contactInfoList)
            ->setContext($context)
            ->setInterlineOfferQuery($interlineOfferQuery)
            ->setInterlinePreferences($interlinePreferences)
            ->setPaxList($paxList)
            ->setSearchCriteria($searchCriteria);
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferRequestTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$interlineOfferRequestTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($interlineOfferRequestTypeContactInfoListItem) ? get_class($interlineOfferRequestTypeContactInfoListItem) : sprintf('%s(%s)', gettype($interlineOfferRequestTypeContactInfoListItem), var_export($interlineOfferRequestTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\InterlineOfferRequestType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\InterlineOfferRequestType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get Context value
     * @return \StructType\InterlineFlightRequestOriginDestinationsCriteriaType|null
     */
    public function getContext()
    {
        return $this->Context;
    }
    /**
     * Set Context value
     * @param \StructType\InterlineFlightRequestOriginDestinationsCriteriaType $context
     * @return \StructType\InterlineOfferRequestType
     */
    public function setContext(\StructType\InterlineFlightRequestOriginDestinationsCriteriaType $context = null)
    {
        $this->Context = $context;
        return $this;
    }
    /**
     * Get InterlineOfferQuery value
     * @return \StructType\InterlineOfferQueryType|null
     */
    public function getInterlineOfferQuery()
    {
        return $this->InterlineOfferQuery;
    }
    /**
     * Set InterlineOfferQuery value
     * @param \StructType\InterlineOfferQueryType $interlineOfferQuery
     * @return \StructType\InterlineOfferRequestType
     */
    public function setInterlineOfferQuery(\StructType\InterlineOfferQueryType $interlineOfferQuery = null)
    {
        $this->InterlineOfferQuery = $interlineOfferQuery;
        return $this;
    }
    /**
     * Get InterlinePreferences value
     * @return \StructType\InterlineResponseParametersRequestType|null
     */
    public function getInterlinePreferences()
    {
        return $this->InterlinePreferences;
    }
    /**
     * Set InterlinePreferences value
     * @param \StructType\InterlineResponseParametersRequestType $interlinePreferences
     * @return \StructType\InterlineOfferRequestType
     */
    public function setInterlinePreferences(\StructType\InterlineResponseParametersRequestType $interlinePreferences = null)
    {
        $this->InterlinePreferences = $interlinePreferences;
        return $this;
    }
    /**
     * Get PaxList value
     * @return \StructType\PaxListType|null
     */
    public function getPaxList()
    {
        return $this->PaxList;
    }
    /**
     * Set PaxList value
     * @param \StructType\PaxListType $paxList
     * @return \StructType\InterlineOfferRequestType
     */
    public function setPaxList(\StructType\PaxListType $paxList = null)
    {
        $this->PaxList = $paxList;
        return $this;
    }
    /**
     * Get SearchCriteria value
     * @return \StructType\InterlineSearchCriteriaRequestType[]|null
     */
    public function getSearchCriteria()
    {
        return $this->SearchCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSearchCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSearchCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSearchCriteriaForArrayConstraintsFromSetSearchCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $interlineOfferRequestTypeSearchCriteriaItem) {
            // validation for constraint: itemType
            if (!$interlineOfferRequestTypeSearchCriteriaItem instanceof \StructType\InterlineSearchCriteriaRequestType) {
                $invalidValues[] = is_object($interlineOfferRequestTypeSearchCriteriaItem) ? get_class($interlineOfferRequestTypeSearchCriteriaItem) : sprintf('%s(%s)', gettype($interlineOfferRequestTypeSearchCriteriaItem), var_export($interlineOfferRequestTypeSearchCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SearchCriteria property can only contain items of type \StructType\InterlineSearchCriteriaRequestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SearchCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineSearchCriteriaRequestType[] $searchCriteria
     * @return \StructType\InterlineOfferRequestType
     */
    public function setSearchCriteria(array $searchCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($searchCriteriaArrayErrorMessage = self::validateSearchCriteriaForArrayConstraintsFromSetSearchCriteria($searchCriteria))) {
            throw new \InvalidArgumentException($searchCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SearchCriteria = $searchCriteria;
        return $this;
    }
    /**
     * Add item to SearchCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\InterlineSearchCriteriaRequestType $item
     * @return \StructType\InterlineOfferRequestType
     */
    public function addToSearchCriteria(\StructType\InterlineSearchCriteriaRequestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\InterlineSearchCriteriaRequestType) {
            throw new \InvalidArgumentException(sprintf('The SearchCriteria property can only contain items of type \StructType\InterlineSearchCriteriaRequestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SearchCriteria[] = $item;
        return $this;
    }
}
