<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IndividualType StructType
 * Meta information extracted from the WSDL
 * - documentation: A single human being as distinct from a group, class, or family.
 * @subpackage Structs
 */
class IndividualType extends AbstractStructBase
{
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Individual's hereditary name(s) common to all members of a family. Also known as family name or last name. E.g. SMITH. Excludes any potential suffix. | BDT with value constraints for proper, regular names (e.g. Individual Surname,
     * Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Surname;
    /**
     * The AddlName
     * Meta information extracted from the WSDL
     * - documentation: An additional name type. The structure consists of a generic proper name with associated type. Examples: Name - 'Smith'. Name Type Code - 'Fathers Surname'. Name - 'Park'. Name Type Code - 'Mothers Surname'.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddlNameType[]
     */
    public $AddlName;
    /**
     * The Birthdate
     * Meta information extracted from the WSDL
     * - documentation: The date on which an individual was born. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Birthdate;
    /**
     * The BirthplaceText
     * Meta information extracted from the WSDL
     * - documentation: Country Code where the Passenger was born (ISO 3166). For example: DE | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthplaceText;
    /**
     * The GenderCode
     * Meta information extracted from the WSDL
     * - documentation: Gender of the individual. Refer to PADIS Codeset 6353. | Additional BDT to specify Gender code.
     * - base: GenderCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GenderCode;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: A personal name given to the individual at birth and used before a family name. Also called first name. E.g. JOHN. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name,
     * etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The IndividualID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely Identifies an Individual within the context of one message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IndividualID;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Individual's middle name or initial. E.g. G, GEORGE. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The SuffixName
     * Meta information extracted from the WSDL
     * - documentation: Individual's name suffixes and letters. Examples: Jr., Sr., III, Ret., Esq. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuffixName;
    /**
     * The TitleName
     * Meta information extracted from the WSDL
     * - documentation: A word such as Mr., Mrs., Miss or Dr that is used before an individual's name to indicate the gender, profession or marital status. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TitleName;
    /**
     * Constructor method for IndividualType
     * @uses IndividualType::setSurname()
     * @uses IndividualType::setAddlName()
     * @uses IndividualType::setBirthdate()
     * @uses IndividualType::setBirthplaceText()
     * @uses IndividualType::setGenderCode()
     * @uses IndividualType::setGivenName()
     * @uses IndividualType::setIndividualID()
     * @uses IndividualType::setMiddleName()
     * @uses IndividualType::setSuffixName()
     * @uses IndividualType::setTitleName()
     * @param string $surname
     * @param \StructType\AddlNameType[] $addlName
     * @param string $birthdate
     * @param string $birthplaceText
     * @param string $genderCode
     * @param string[] $givenName
     * @param string $individualID
     * @param string[] $middleName
     * @param string $suffixName
     * @param string $titleName
     */
    public function __construct($surname = null, array $addlName = array(), $birthdate = null, $birthplaceText = null, $genderCode = null, array $givenName = array(), $individualID = null, array $middleName = array(), $suffixName = null, $titleName = null)
    {
        $this
            ->setSurname($surname)
            ->setAddlName($addlName)
            ->setBirthdate($birthdate)
            ->setBirthplaceText($birthplaceText)
            ->setGenderCode($genderCode)
            ->setGivenName($givenName)
            ->setIndividualID($individualID)
            ->setMiddleName($middleName)
            ->setSuffixName($suffixName)
            ->setTitleName($titleName);
    }
    /**
     * Get Surname value
     * @return string
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\IndividualType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($surname) && mb_strlen($surname) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($surname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surname) && mb_strlen($surname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get AddlName value
     * @return \StructType\AddlNameType[]|null
     */
    public function getAddlName()
    {
        return $this->AddlName;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlNameForArrayConstraintsFromSetAddlName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeAddlNameItem) {
            // validation for constraint: itemType
            if (!$individualTypeAddlNameItem instanceof \StructType\AddlNameType) {
                $invalidValues[] = is_object($individualTypeAddlNameItem) ? get_class($individualTypeAddlNameItem) : sprintf('%s(%s)', gettype($individualTypeAddlNameItem), var_export($individualTypeAddlNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlName property can only contain items of type \StructType\AddlNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlName value
     * @throws \InvalidArgumentException
     * @param \StructType\AddlNameType[] $addlName
     * @return \StructType\IndividualType
     */
    public function setAddlName(array $addlName = array())
    {
        // validation for constraint: array
        if ('' !== ($addlNameArrayErrorMessage = self::validateAddlNameForArrayConstraintsFromSetAddlName($addlName))) {
            throw new \InvalidArgumentException($addlNameArrayErrorMessage, __LINE__);
        }
        $this->AddlName = $addlName;
        return $this;
    }
    /**
     * Add item to AddlName value
     * @throws \InvalidArgumentException
     * @param \StructType\AddlNameType $item
     * @return \StructType\IndividualType
     */
    public function addToAddlName(\StructType\AddlNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddlNameType) {
            throw new \InvalidArgumentException(sprintf('The AddlName property can only contain items of type \StructType\AddlNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddlName[] = $item;
        return $this;
    }
    /**
     * Get Birthdate value
     * @return string|null
     */
    public function getBirthdate()
    {
        return $this->Birthdate;
    }
    /**
     * Set Birthdate value
     * @param string $birthdate
     * @return \StructType\IndividualType
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        $this->Birthdate = $birthdate;
        return $this;
    }
    /**
     * Get BirthplaceText value
     * @return string|null
     */
    public function getBirthplaceText()
    {
        return $this->BirthplaceText;
    }
    /**
     * Set BirthplaceText value
     * @param string $birthplaceText
     * @return \StructType\IndividualType
     */
    public function setBirthplaceText($birthplaceText = null)
    {
        // validation for constraint: string
        if (!is_null($birthplaceText) && !is_string($birthplaceText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthplaceText, true), gettype($birthplaceText)), __LINE__);
        }
        $this->BirthplaceText = $birthplaceText;
        return $this;
    }
    /**
     * Get GenderCode value
     * @return string|null
     */
    public function getGenderCode()
    {
        return $this->GenderCode;
    }
    /**
     * Set GenderCode value
     * @param string $genderCode
     * @return \StructType\IndividualType
     */
    public function setGenderCode($genderCode = null)
    {
        // validation for constraint: string
        if (!is_null($genderCode) && !is_string($genderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genderCode, true), gettype($genderCode)), __LINE__);
        }
        $this->GenderCode = $genderCode;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($individualTypeGivenNameItem)) {
                $invalidValues[] = is_object($individualTypeGivenNameItem) ? get_class($individualTypeGivenNameItem) : sprintf('%s(%s)', gettype($individualTypeGivenNameItem), var_export($individualTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMaxLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeGivenNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($individualTypeGivenNameItem) > 64) {
                $invalidValues[] = var_export($individualTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMinLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeGivenNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($individualTypeGivenNameItem) < 1) {
                $invalidValues[] = var_export($individualTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \StructType\IndividualType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($givenNameMaxLengthErrorMessage = self::validateGivenNameForMaxLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($givenName) && count($givenName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($givenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($givenNameMinLengthErrorMessage = self::validateGivenNameForMinLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMinLengthErrorMessage, __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IndividualType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GivenName) && count($this->GivenName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GivenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get IndividualID value
     * @return string|null
     */
    public function getIndividualID()
    {
        return $this->IndividualID;
    }
    /**
     * Set IndividualID value
     * @param string $individualID
     * @return \StructType\IndividualType
     */
    public function setIndividualID($individualID = null)
    {
        // validation for constraint: string
        if (!is_null($individualID) && !is_string($individualID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($individualID, true), gettype($individualID)), __LINE__);
        }
        $this->IndividualID = $individualID;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($individualTypeMiddleNameItem)) {
                $invalidValues[] = is_object($individualTypeMiddleNameItem) ? get_class($individualTypeMiddleNameItem) : sprintf('%s(%s)', gettype($individualTypeMiddleNameItem), var_export($individualTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMaxLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeMiddleNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($individualTypeMiddleNameItem) > 64) {
                $invalidValues[] = var_export($individualTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMinLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $individualTypeMiddleNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($individualTypeMiddleNameItem) < 1) {
                $invalidValues[] = var_export($individualTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \StructType\IndividualType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($middleNameMaxLengthErrorMessage = self::validateMiddleNameForMaxLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($middleName) && count($middleName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($middleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($middleNameMinLengthErrorMessage = self::validateMiddleNameForMinLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMinLengthErrorMessage, __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IndividualType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MiddleName) && count($this->MiddleName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MiddleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get SuffixName value
     * @return string|null
     */
    public function getSuffixName()
    {
        return $this->SuffixName;
    }
    /**
     * Set SuffixName value
     * @param string $suffixName
     * @return \StructType\IndividualType
     */
    public function setSuffixName($suffixName = null)
    {
        // validation for constraint: string
        if (!is_null($suffixName) && !is_string($suffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixName, true), gettype($suffixName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($suffixName) && mb_strlen($suffixName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($suffixName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($suffixName) && mb_strlen($suffixName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($suffixName)), __LINE__);
        }
        $this->SuffixName = $suffixName;
        return $this;
    }
    /**
     * Get TitleName value
     * @return string|null
     */
    public function getTitleName()
    {
        return $this->TitleName;
    }
    /**
     * Set TitleName value
     * @param string $titleName
     * @return \StructType\IndividualType
     */
    public function setTitleName($titleName = null)
    {
        // validation for constraint: string
        if (!is_null($titleName) && !is_string($titleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleName, true), gettype($titleName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($titleName) && mb_strlen($titleName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($titleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titleName) && mb_strlen($titleName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titleName)), __LINE__);
        }
        $this->TitleName = $titleName;
        return $this;
    }
}
