<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IdentityDocType StructType
 * Meta information extracted from the WSDL
 * - documentation: Any document which may be used to identify a person or verify aspects of a person's personal identity. If issued in a small, standard credit card size form, it is usually called an identity card. Some countries issue formal identity
 * documents, while others may require identity verification using informal documents. When the identity document incorporates a person's photograph, it may be called photo ID. In the absence of a formal identity document, a driver's license may be
 * accepted in many countries for identity verification. Most countries accept passports as a form of identification.
 * @subpackage Structs
 */
class IdentityDocType extends AbstractStructBase
{
    /**
     * The IdentityDocID
     * Meta information extracted from the WSDL
     * - documentation: Uniquely identifies the document from all other identity documents issued by the state or organization. e.g. passport number, drivers license number. | An identifier is a character string used to uniquely identify one instance of an
     * object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentityDocID;
    /**
     * The IdentityDocTypeCode
     * Meta information extracted from the WSDL
     * - documentation: The type of passenger document. Examples: PT (Passport) | Enumeration set for the Identity Document Type BDT. {codeListAgencyIdentifier}PADIS 7365{/codeListAgencyIdentifier} {codeListAgencyName}PADIS{/codeListAgencyName}
     * {codeListIdentifier}7365{/codeListIdentifier} | Additional BDT to specify the type of passenger document.
     * - base: IdentityDocTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $IdentityDocTypeCode;
    /**
     * The Surname
     * Meta information extracted from the WSDL
     * - documentation: Holder's family name or last name, as written on the document. E.g. SMITH. Excludes any potential suffix. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 1
     * @var string
     */
    public $Surname;
    /**
     * The AddlName
     * Meta information extracted from the WSDL
     * - documentation: An additional name type. The structure consists of a generic proper name with associated type. Examples: Name - 'Smith'. Name Type Code - 'Fathers Surname'. Name - 'Park'. Name Type Code - 'Mothers Surname'.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AddlNameType[]
     */
    public $AddlName;
    /**
     * The Birthdate
     * Meta information extracted from the WSDL
     * - documentation: Holder's date of birth as written on the document. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Birthdate;
    /**
     * The BirthplaceText
     * Meta information extracted from the WSDL
     * - documentation: Holder's birth location (e.g. city and/or country) as written on the document. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $BirthplaceText;
    /**
     * The CitizenshipCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $CitizenshipCountryCode;
    /**
     * The ExpiryDate
     * Meta information extracted from the WSDL
     * - documentation: The date the identity document expires. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ExpiryDate;
    /**
     * The GenderCode
     * Meta information extracted from the WSDL
     * - documentation: Gender of the individual. Refer to PADIS Codeset 6353. | Additional BDT to specify Gender code.
     * - base: GenderCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $GenderCode;
    /**
     * The GivenName
     * Meta information extracted from the WSDL
     * - documentation: Holder's first or given name, as written on the document. E.g. JOHN. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 5
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $GivenName;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - documentation: The date the identity document was issued. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The IssuingCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $IssuingCountryCode;
    /**
     * The MiddleName
     * Meta information extracted from the WSDL
     * - documentation: Holder's middle name or initial, as written on the document. E.g. G, GEORGE. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 3
     * - minLength: 1
     * - minOccurs: 0
     * @var string[]
     */
    public $MiddleName;
    /**
     * The ResidenceCountryCode
     * Meta information extracted from the WSDL
     * - documentation: ISO Country Code (can be extended by bilateral agreement in case of exceptions, e.g. Kosovo). Examples: US, FR. | The code list of ISO 3166 two-alpha Country Codes {codeListAgencyName}ISO{/codeListAgencyName} {codeListName}3166
     * two-alpha Country Codes{/codeListName} | The code list of ISO 3166 two-alpha Country Codes | ISO Country Code.
     * - base: CountryCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [A-Z]{2}
     * @var string
     */
    public $ResidenceCountryCode;
    /**
     * The SuffixName
     * Meta information extracted from the WSDL
     * - documentation: Holder's name suffixes and letters, as written on the document. E.g. Jr., Sr., III, Ret., Esq. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $SuffixName;
    /**
     * The TitleName
     * Meta information extracted from the WSDL
     * - documentation: Holder's title as written on the document. E.g. Mr., Mrs., Miss, Dr. | BDT with value constraints for short supplements to proper names, such as Title, Suffix, etc.
     * - base: xs:token
     * - maxLength: 16
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $TitleName;
    /**
     * The Visa
     * Meta information extracted from the WSDL
     * - documentation: An official entry in a Passport or other Travel Document made by an official of a government to indicate that the bearer has been granted authority to enter or re-enter the country or region concerned.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\VisaType[]
     */
    public $Visa;
    /**
     * Constructor method for IdentityDocType
     * @uses IdentityDocType::setIdentityDocID()
     * @uses IdentityDocType::setIdentityDocTypeCode()
     * @uses IdentityDocType::setSurname()
     * @uses IdentityDocType::setAddlName()
     * @uses IdentityDocType::setBirthdate()
     * @uses IdentityDocType::setBirthplaceText()
     * @uses IdentityDocType::setCitizenshipCountryCode()
     * @uses IdentityDocType::setExpiryDate()
     * @uses IdentityDocType::setGenderCode()
     * @uses IdentityDocType::setGivenName()
     * @uses IdentityDocType::setIssueDate()
     * @uses IdentityDocType::setIssuingCountryCode()
     * @uses IdentityDocType::setMiddleName()
     * @uses IdentityDocType::setResidenceCountryCode()
     * @uses IdentityDocType::setSuffixName()
     * @uses IdentityDocType::setTitleName()
     * @uses IdentityDocType::setVisa()
     * @param string $identityDocID
     * @param string $identityDocTypeCode
     * @param string $surname
     * @param \StructType\AddlNameType[] $addlName
     * @param string $birthdate
     * @param string $birthplaceText
     * @param string $citizenshipCountryCode
     * @param string $expiryDate
     * @param string $genderCode
     * @param string[] $givenName
     * @param string $issueDate
     * @param string $issuingCountryCode
     * @param string[] $middleName
     * @param string $residenceCountryCode
     * @param string $suffixName
     * @param string $titleName
     * @param \StructType\VisaType[] $visa
     */
    public function __construct($identityDocID = null, $identityDocTypeCode = null, $surname = null, array $addlName = array(), $birthdate = null, $birthplaceText = null, $citizenshipCountryCode = null, $expiryDate = null, $genderCode = null, array $givenName = array(), $issueDate = null, $issuingCountryCode = null, array $middleName = array(), $residenceCountryCode = null, $suffixName = null, $titleName = null, array $visa = array())
    {
        $this
            ->setIdentityDocID($identityDocID)
            ->setIdentityDocTypeCode($identityDocTypeCode)
            ->setSurname($surname)
            ->setAddlName($addlName)
            ->setBirthdate($birthdate)
            ->setBirthplaceText($birthplaceText)
            ->setCitizenshipCountryCode($citizenshipCountryCode)
            ->setExpiryDate($expiryDate)
            ->setGenderCode($genderCode)
            ->setGivenName($givenName)
            ->setIssueDate($issueDate)
            ->setIssuingCountryCode($issuingCountryCode)
            ->setMiddleName($middleName)
            ->setResidenceCountryCode($residenceCountryCode)
            ->setSuffixName($suffixName)
            ->setTitleName($titleName)
            ->setVisa($visa);
    }
    /**
     * Get IdentityDocID value
     * @return string
     */
    public function getIdentityDocID()
    {
        return $this->IdentityDocID;
    }
    /**
     * Set IdentityDocID value
     * @param string $identityDocID
     * @return \StructType\IdentityDocType
     */
    public function setIdentityDocID($identityDocID = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocID) && !is_string($identityDocID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocID, true), gettype($identityDocID)), __LINE__);
        }
        $this->IdentityDocID = $identityDocID;
        return $this;
    }
    /**
     * Get IdentityDocTypeCode value
     * @return string
     */
    public function getIdentityDocTypeCode()
    {
        return $this->IdentityDocTypeCode;
    }
    /**
     * Set IdentityDocTypeCode value
     * @param string $identityDocTypeCode
     * @return \StructType\IdentityDocType
     */
    public function setIdentityDocTypeCode($identityDocTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($identityDocTypeCode) && !is_string($identityDocTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identityDocTypeCode, true), gettype($identityDocTypeCode)), __LINE__);
        }
        $this->IdentityDocTypeCode = $identityDocTypeCode;
        return $this;
    }
    /**
     * Get Surname value
     * @return string
     */
    public function getSurname()
    {
        return $this->Surname;
    }
    /**
     * Set Surname value
     * @param string $surname
     * @return \StructType\IdentityDocType
     */
    public function setSurname($surname = null)
    {
        // validation for constraint: string
        if (!is_null($surname) && !is_string($surname)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($surname, true), gettype($surname)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($surname) && mb_strlen($surname) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($surname)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($surname) && mb_strlen($surname) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($surname)), __LINE__);
        }
        $this->Surname = $surname;
        return $this;
    }
    /**
     * Get AddlName value
     * @return \StructType\AddlNameType[]|null
     */
    public function getAddlName()
    {
        return $this->AddlName;
    }
    /**
     * This method is responsible for validating the values passed to the setAddlName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAddlName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAddlNameForArrayConstraintsFromSetAddlName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeAddlNameItem) {
            // validation for constraint: itemType
            if (!$identityDocTypeAddlNameItem instanceof \StructType\AddlNameType) {
                $invalidValues[] = is_object($identityDocTypeAddlNameItem) ? get_class($identityDocTypeAddlNameItem) : sprintf('%s(%s)', gettype($identityDocTypeAddlNameItem), var_export($identityDocTypeAddlNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AddlName property can only contain items of type \StructType\AddlNameType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AddlName value
     * @throws \InvalidArgumentException
     * @param \StructType\AddlNameType[] $addlName
     * @return \StructType\IdentityDocType
     */
    public function setAddlName(array $addlName = array())
    {
        // validation for constraint: array
        if ('' !== ($addlNameArrayErrorMessage = self::validateAddlNameForArrayConstraintsFromSetAddlName($addlName))) {
            throw new \InvalidArgumentException($addlNameArrayErrorMessage, __LINE__);
        }
        $this->AddlName = $addlName;
        return $this;
    }
    /**
     * Add item to AddlName value
     * @throws \InvalidArgumentException
     * @param \StructType\AddlNameType $item
     * @return \StructType\IdentityDocType
     */
    public function addToAddlName(\StructType\AddlNameType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AddlNameType) {
            throw new \InvalidArgumentException(sprintf('The AddlName property can only contain items of type \StructType\AddlNameType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AddlName[] = $item;
        return $this;
    }
    /**
     * Get Birthdate value
     * @return string|null
     */
    public function getBirthdate()
    {
        return $this->Birthdate;
    }
    /**
     * Set Birthdate value
     * @param string $birthdate
     * @return \StructType\IdentityDocType
     */
    public function setBirthdate($birthdate = null)
    {
        // validation for constraint: string
        if (!is_null($birthdate) && !is_string($birthdate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthdate, true), gettype($birthdate)), __LINE__);
        }
        $this->Birthdate = $birthdate;
        return $this;
    }
    /**
     * Get BirthplaceText value
     * @return string|null
     */
    public function getBirthplaceText()
    {
        return $this->BirthplaceText;
    }
    /**
     * Set BirthplaceText value
     * @param string $birthplaceText
     * @return \StructType\IdentityDocType
     */
    public function setBirthplaceText($birthplaceText = null)
    {
        // validation for constraint: string
        if (!is_null($birthplaceText) && !is_string($birthplaceText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($birthplaceText, true), gettype($birthplaceText)), __LINE__);
        }
        $this->BirthplaceText = $birthplaceText;
        return $this;
    }
    /**
     * Get CitizenshipCountryCode value
     * @return string|null
     */
    public function getCitizenshipCountryCode()
    {
        return $this->CitizenshipCountryCode;
    }
    /**
     * Set CitizenshipCountryCode value
     * @param string $citizenshipCountryCode
     * @return \StructType\IdentityDocType
     */
    public function setCitizenshipCountryCode($citizenshipCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($citizenshipCountryCode) && !is_string($citizenshipCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($citizenshipCountryCode, true), gettype($citizenshipCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($citizenshipCountryCode) && !preg_match('/[A-Z]{2}/', $citizenshipCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($citizenshipCountryCode, true)), __LINE__);
        }
        $this->CitizenshipCountryCode = $citizenshipCountryCode;
        return $this;
    }
    /**
     * Get ExpiryDate value
     * @return string|null
     */
    public function getExpiryDate()
    {
        return $this->ExpiryDate;
    }
    /**
     * Set ExpiryDate value
     * @param string $expiryDate
     * @return \StructType\IdentityDocType
     */
    public function setExpiryDate($expiryDate = null)
    {
        // validation for constraint: string
        if (!is_null($expiryDate) && !is_string($expiryDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiryDate, true), gettype($expiryDate)), __LINE__);
        }
        $this->ExpiryDate = $expiryDate;
        return $this;
    }
    /**
     * Get GenderCode value
     * @return string|null
     */
    public function getGenderCode()
    {
        return $this->GenderCode;
    }
    /**
     * Set GenderCode value
     * @param string $genderCode
     * @return \StructType\IdentityDocType
     */
    public function setGenderCode($genderCode = null)
    {
        // validation for constraint: string
        if (!is_null($genderCode) && !is_string($genderCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($genderCode, true), gettype($genderCode)), __LINE__);
        }
        $this->GenderCode = $genderCode;
        return $this;
    }
    /**
     * Get GivenName value
     * @return string[]|null
     */
    public function getGivenName()
    {
        return $this->GivenName;
    }
    /**
     * This method is responsible for validating the values passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForArrayConstraintsFromSetGivenName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeGivenNameItem) {
            // validation for constraint: itemType
            if (!is_string($identityDocTypeGivenNameItem)) {
                $invalidValues[] = is_object($identityDocTypeGivenNameItem) ? get_class($identityDocTypeGivenNameItem) : sprintf('%s(%s)', gettype($identityDocTypeGivenNameItem), var_export($identityDocTypeGivenNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The GivenName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMaxLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeGivenNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($identityDocTypeGivenNameItem) > 64) {
                $invalidValues[] = var_export($identityDocTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setGivenName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setGivenName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateGivenNameForMinLengthConstraintFromSetGivenName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeGivenNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($identityDocTypeGivenNameItem) < 1) {
                $invalidValues[] = var_export($identityDocTypeGivenNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set GivenName value
     * @throws \InvalidArgumentException
     * @param string[] $givenName
     * @return \StructType\IdentityDocType
     */
    public function setGivenName(array $givenName = array())
    {
        // validation for constraint: array
        if ('' !== ($givenNameArrayErrorMessage = self::validateGivenNameForArrayConstraintsFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($givenNameMaxLengthErrorMessage = self::validateGivenNameForMaxLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($givenName) && count($givenName) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($givenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($givenNameMinLengthErrorMessage = self::validateGivenNameForMinLengthConstraintFromSetGivenName($givenName))) {
            throw new \InvalidArgumentException($givenNameMinLengthErrorMessage, __LINE__);
        }
        $this->GivenName = $givenName;
        return $this;
    }
    /**
     * Add item to GivenName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IdentityDocType
     */
    public function addToGivenName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The GivenName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->GivenName) && count($this->GivenName) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->GivenName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->GivenName[] = $item;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\IdentityDocType
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get IssuingCountryCode value
     * @return string|null
     */
    public function getIssuingCountryCode()
    {
        return $this->IssuingCountryCode;
    }
    /**
     * Set IssuingCountryCode value
     * @param string $issuingCountryCode
     * @return \StructType\IdentityDocType
     */
    public function setIssuingCountryCode($issuingCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($issuingCountryCode) && !is_string($issuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issuingCountryCode, true), gettype($issuingCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($issuingCountryCode) && !preg_match('/[A-Z]{2}/', $issuingCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($issuingCountryCode, true)), __LINE__);
        }
        $this->IssuingCountryCode = $issuingCountryCode;
        return $this;
    }
    /**
     * Get MiddleName value
     * @return string[]|null
     */
    public function getMiddleName()
    {
        return $this->MiddleName;
    }
    /**
     * This method is responsible for validating the values passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForArrayConstraintsFromSetMiddleName(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeMiddleNameItem) {
            // validation for constraint: itemType
            if (!is_string($identityDocTypeMiddleNameItem)) {
                $invalidValues[] = is_object($identityDocTypeMiddleNameItem) ? get_class($identityDocTypeMiddleNameItem) : sprintf('%s(%s)', gettype($identityDocTypeMiddleNameItem), var_export($identityDocTypeMiddleNameItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The MiddleName property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMaxLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeMiddleNameItem) {
            // validation for constraint: maxLength(64)
            if (mb_strlen($identityDocTypeMiddleNameItem) > 64) {
                $invalidValues[] = var_export($identityDocTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be less than or equal to 64', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * This method is responsible for validating the value passed to the setMiddleName method
     * This method is willingly generated in order to preserve the one-line inline validation within the setMiddleName method
     * This has to validate that the items contained by the array match the length constraint
     * @param mixed $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateMiddleNameForMinLengthConstraintFromSetMiddleName($values)
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeMiddleNameItem) {
            // validation for constraint: minLength(1)
            if (mb_strlen($identityDocTypeMiddleNameItem) < 1) {
                $invalidValues[] = var_export($identityDocTypeMiddleNameItem, true);
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid length for value(s) %s, the number of characters/octets contained by the literal must be greater than or equal to 1', implode(', ', $invalidValues));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set MiddleName value
     * @throws \InvalidArgumentException
     * @param string[] $middleName
     * @return \StructType\IdentityDocType
     */
    public function setMiddleName(array $middleName = array())
    {
        // validation for constraint: array
        if ('' !== ($middleNameArrayErrorMessage = self::validateMiddleNameForArrayConstraintsFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxLength(64)
        if ('' !== ($middleNameMaxLengthErrorMessage = self::validateMiddleNameForMaxLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMaxLengthErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($middleName) && count($middleName) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($middleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if ('' !== ($middleNameMinLengthErrorMessage = self::validateMiddleNameForMinLengthConstraintFromSetMiddleName($middleName))) {
            throw new \InvalidArgumentException($middleNameMinLengthErrorMessage, __LINE__);
        }
        $this->MiddleName = $middleName;
        return $this;
    }
    /**
     * Add item to MiddleName value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\IdentityDocType
     */
    public function addToMiddleName($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The MiddleName property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (mb_strlen($item) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($item)), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->MiddleName) && count($this->MiddleName) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->MiddleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (mb_strlen($item) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($item)), __LINE__);
        }
        $this->MiddleName[] = $item;
        return $this;
    }
    /**
     * Get ResidenceCountryCode value
     * @return string|null
     */
    public function getResidenceCountryCode()
    {
        return $this->ResidenceCountryCode;
    }
    /**
     * Set ResidenceCountryCode value
     * @param string $residenceCountryCode
     * @return \StructType\IdentityDocType
     */
    public function setResidenceCountryCode($residenceCountryCode = null)
    {
        // validation for constraint: string
        if (!is_null($residenceCountryCode) && !is_string($residenceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($residenceCountryCode, true), gettype($residenceCountryCode)), __LINE__);
        }
        // validation for constraint: pattern([A-Z]{2})
        if (!is_null($residenceCountryCode) && !preg_match('/[A-Z]{2}/', $residenceCountryCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [A-Z]{2}', var_export($residenceCountryCode, true)), __LINE__);
        }
        $this->ResidenceCountryCode = $residenceCountryCode;
        return $this;
    }
    /**
     * Get SuffixName value
     * @return string|null
     */
    public function getSuffixName()
    {
        return $this->SuffixName;
    }
    /**
     * Set SuffixName value
     * @param string $suffixName
     * @return \StructType\IdentityDocType
     */
    public function setSuffixName($suffixName = null)
    {
        // validation for constraint: string
        if (!is_null($suffixName) && !is_string($suffixName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffixName, true), gettype($suffixName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($suffixName) && mb_strlen($suffixName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($suffixName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($suffixName) && mb_strlen($suffixName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($suffixName)), __LINE__);
        }
        $this->SuffixName = $suffixName;
        return $this;
    }
    /**
     * Get TitleName value
     * @return string|null
     */
    public function getTitleName()
    {
        return $this->TitleName;
    }
    /**
     * Set TitleName value
     * @param string $titleName
     * @return \StructType\IdentityDocType
     */
    public function setTitleName($titleName = null)
    {
        // validation for constraint: string
        if (!is_null($titleName) && !is_string($titleName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($titleName, true), gettype($titleName)), __LINE__);
        }
        // validation for constraint: maxLength(16)
        if (!is_null($titleName) && mb_strlen($titleName) > 16) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 16', mb_strlen($titleName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($titleName) && mb_strlen($titleName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($titleName)), __LINE__);
        }
        $this->TitleName = $titleName;
        return $this;
    }
    /**
     * Get Visa value
     * @return \StructType\VisaType[]|null
     */
    public function getVisa()
    {
        return $this->Visa;
    }
    /**
     * This method is responsible for validating the values passed to the setVisa method
     * This method is willingly generated in order to preserve the one-line inline validation within the setVisa method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateVisaForArrayConstraintsFromSetVisa(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $identityDocTypeVisaItem) {
            // validation for constraint: itemType
            if (!$identityDocTypeVisaItem instanceof \StructType\VisaType) {
                $invalidValues[] = is_object($identityDocTypeVisaItem) ? get_class($identityDocTypeVisaItem) : sprintf('%s(%s)', gettype($identityDocTypeVisaItem), var_export($identityDocTypeVisaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Visa property can only contain items of type \StructType\VisaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Visa value
     * @throws \InvalidArgumentException
     * @param \StructType\VisaType[] $visa
     * @return \StructType\IdentityDocType
     */
    public function setVisa(array $visa = array())
    {
        // validation for constraint: array
        if ('' !== ($visaArrayErrorMessage = self::validateVisaForArrayConstraintsFromSetVisa($visa))) {
            throw new \InvalidArgumentException($visaArrayErrorMessage, __LINE__);
        }
        $this->Visa = $visa;
        return $this;
    }
    /**
     * Add item to Visa value
     * @throws \InvalidArgumentException
     * @param \StructType\VisaType $item
     * @return \StructType\IdentityDocType
     */
    public function addToVisa(\StructType\VisaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\VisaType) {
            throw new \InvalidArgumentException(sprintf('The Visa property can only contain items of type \StructType\VisaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Visa[] = $item;
        return $this;
    }
}
