<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for IATA_AircraftTypeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Grouping of aircrafts with the same form, function and specification, currently flown, or soon to be flown. Possible types are defined in the IATA SSIM. The same type may include aircrafts with different technical specifications such
 * as engines, range, cockpit configuration. Business Identifier Fields: - IATA Aircraft Type Code
 * @subpackage Structs
 */
class IATA_AircraftTypeType extends AbstractStructBase
{
    /**
     * The IATA_AircraftTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned to an aircraft type in IATA SSIM. | Enumeration set for the IATA Aircraft Type Code BDT. {codeListAgencyName}IATA{/codeListAgencyName} {codeListName}SSIM Appendix A Aircraft Type Code{/codeListName} | Specifies the IATA
     * defined code of an aircraft type.
     * - base: IATA_AircraftTypeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * - pattern: [0-9A-Z]{3}
     * @var string
     */
    public $IATA_AircraftTypeCode;
    /**
     * Constructor method for IATA_AircraftTypeType
     * @uses IATA_AircraftTypeType::setIATA_AircraftTypeCode()
     * @param string $iATA_AircraftTypeCode
     */
    public function __construct($iATA_AircraftTypeCode = null)
    {
        $this
            ->setIATA_AircraftTypeCode($iATA_AircraftTypeCode);
    }
    /**
     * Get IATA_AircraftTypeCode value
     * @return string|null
     */
    public function getIATA_AircraftTypeCode()
    {
        return $this->IATA_AircraftTypeCode;
    }
    /**
     * Set IATA_AircraftTypeCode value
     * @param string $iATA_AircraftTypeCode
     * @return \StructType\IATA_AircraftTypeType
     */
    public function setIATA_AircraftTypeCode($iATA_AircraftTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($iATA_AircraftTypeCode) && !is_string($iATA_AircraftTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($iATA_AircraftTypeCode, true), gettype($iATA_AircraftTypeCode)), __LINE__);
        }
        // validation for constraint: pattern([0-9A-Z]{3})
        if (!is_null($iATA_AircraftTypeCode) && !preg_match('/[0-9A-Z]{3}/', $iATA_AircraftTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9A-Z]{3}', var_export($iATA_AircraftTypeCode, true)), __LINE__);
        }
        $this->IATA_AircraftTypeCode = $iATA_AircraftTypeCode;
        return $this;
    }
}
