<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for GeospatialLocationType StructType
 * Meta information extracted from the WSDL
 * - documentation: A location with a spatial attribute, probably on the surface of the earth. For example: Longitude and Latitude
 * @subpackage Structs
 */
class GeospatialLocationType extends AbstractStructBase
{
    /**
     * The NaturalAreaGeocode
     * Meta information extracted from the WSDL
     * - documentation: Natural Area Geocode as defined by NAC Geographic Products Inc. Ex: 8KDB PGFD | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NaturalAreaGeocode;
    /**
     * The PointElevationNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the spatial location point elevation. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PointElevationNumber;
    /**
     * The PointLatitudeNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the spatial location point latitude. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PointLatitudeNumber;
    /**
     * The PointLongitudeNumber
     * Meta information extracted from the WSDL
     * - documentation: The number of the spatial location point longitude. | A mathematical number that is assigned or is determined by calculation.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $PointLongitudeNumber;
    /**
     * Constructor method for GeospatialLocationType
     * @uses GeospatialLocationType::setNaturalAreaGeocode()
     * @uses GeospatialLocationType::setPointElevationNumber()
     * @uses GeospatialLocationType::setPointLatitudeNumber()
     * @uses GeospatialLocationType::setPointLongitudeNumber()
     * @param string $naturalAreaGeocode
     * @param float $pointElevationNumber
     * @param float $pointLatitudeNumber
     * @param float $pointLongitudeNumber
     */
    public function __construct($naturalAreaGeocode = null, $pointElevationNumber = null, $pointLatitudeNumber = null, $pointLongitudeNumber = null)
    {
        $this
            ->setNaturalAreaGeocode($naturalAreaGeocode)
            ->setPointElevationNumber($pointElevationNumber)
            ->setPointLatitudeNumber($pointLatitudeNumber)
            ->setPointLongitudeNumber($pointLongitudeNumber);
    }
    /**
     * Get NaturalAreaGeocode value
     * @return string|null
     */
    public function getNaturalAreaGeocode()
    {
        return $this->NaturalAreaGeocode;
    }
    /**
     * Set NaturalAreaGeocode value
     * @param string $naturalAreaGeocode
     * @return \StructType\GeospatialLocationType
     */
    public function setNaturalAreaGeocode($naturalAreaGeocode = null)
    {
        // validation for constraint: string
        if (!is_null($naturalAreaGeocode) && !is_string($naturalAreaGeocode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($naturalAreaGeocode, true), gettype($naturalAreaGeocode)), __LINE__);
        }
        $this->NaturalAreaGeocode = $naturalAreaGeocode;
        return $this;
    }
    /**
     * Get PointElevationNumber value
     * @return float|null
     */
    public function getPointElevationNumber()
    {
        return $this->PointElevationNumber;
    }
    /**
     * Set PointElevationNumber value
     * @param float $pointElevationNumber
     * @return \StructType\GeospatialLocationType
     */
    public function setPointElevationNumber($pointElevationNumber = null)
    {
        // validation for constraint: float
        if (!is_null($pointElevationNumber) && !(is_float($pointElevationNumber) || is_numeric($pointElevationNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointElevationNumber, true), gettype($pointElevationNumber)), __LINE__);
        }
        $this->PointElevationNumber = $pointElevationNumber;
        return $this;
    }
    /**
     * Get PointLatitudeNumber value
     * @return float|null
     */
    public function getPointLatitudeNumber()
    {
        return $this->PointLatitudeNumber;
    }
    /**
     * Set PointLatitudeNumber value
     * @param float $pointLatitudeNumber
     * @return \StructType\GeospatialLocationType
     */
    public function setPointLatitudeNumber($pointLatitudeNumber = null)
    {
        // validation for constraint: float
        if (!is_null($pointLatitudeNumber) && !(is_float($pointLatitudeNumber) || is_numeric($pointLatitudeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointLatitudeNumber, true), gettype($pointLatitudeNumber)), __LINE__);
        }
        $this->PointLatitudeNumber = $pointLatitudeNumber;
        return $this;
    }
    /**
     * Get PointLongitudeNumber value
     * @return float|null
     */
    public function getPointLongitudeNumber()
    {
        return $this->PointLongitudeNumber;
    }
    /**
     * Set PointLongitudeNumber value
     * @param float $pointLongitudeNumber
     * @return \StructType\GeospatialLocationType
     */
    public function setPointLongitudeNumber($pointLongitudeNumber = null)
    {
        // validation for constraint: float
        if (!is_null($pointLongitudeNumber) && !(is_float($pointLongitudeNumber) || is_numeric($pointLongitudeNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($pointLongitudeNumber, true), gettype($pointLongitudeNumber)), __LINE__);
        }
        $this->PointLongitudeNumber = $pointLongitudeNumber;
        return $this;
    }
}
