<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightRequestSpecificOriginDestinationsType StructType
 * Meta information extracted from the WSDL
 * - documentation: This is a container for a flight request type which allow multiple specified origin and destinations to be input in this type of request.
 * @subpackage Structs
 */
class FlightRequestSpecificOriginDestinationsType extends AbstractStructBase
{
    /**
     * The SpecificOriginDestCriteria
     * Meta information extracted from the WSDL
     * - documentation: The Origin and Destination airport/city pair which confines a passenger journey or an aircraft flight. Business Identifier Fields: - [Station] (Origin Station) IATA Location Code - [Station] (Destination Station) IATA Location Code
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\OriginDestType[]
     */
    public $SpecificOriginDestCriteria;
    /**
     * Constructor method for FlightRequestSpecificOriginDestinationsType
     * @uses FlightRequestSpecificOriginDestinationsType::setSpecificOriginDestCriteria()
     * @param \StructType\OriginDestType[] $specificOriginDestCriteria
     */
    public function __construct(array $specificOriginDestCriteria = array())
    {
        $this
            ->setSpecificOriginDestCriteria($specificOriginDestCriteria);
    }
    /**
     * Get SpecificOriginDestCriteria value
     * @return \StructType\OriginDestType[]
     */
    public function getSpecificOriginDestCriteria()
    {
        return $this->SpecificOriginDestCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSpecificOriginDestCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSpecificOriginDestCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSpecificOriginDestCriteriaForArrayConstraintsFromSetSpecificOriginDestCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRequestSpecificOriginDestinationsTypeSpecificOriginDestCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRequestSpecificOriginDestinationsTypeSpecificOriginDestCriteriaItem instanceof \StructType\OriginDestType) {
                $invalidValues[] = is_object($flightRequestSpecificOriginDestinationsTypeSpecificOriginDestCriteriaItem) ? get_class($flightRequestSpecificOriginDestinationsTypeSpecificOriginDestCriteriaItem) : sprintf('%s(%s)', gettype($flightRequestSpecificOriginDestinationsTypeSpecificOriginDestCriteriaItem), var_export($flightRequestSpecificOriginDestinationsTypeSpecificOriginDestCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SpecificOriginDestCriteria property can only contain items of type \StructType\OriginDestType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SpecificOriginDestCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestType[] $specificOriginDestCriteria
     * @return \StructType\FlightRequestSpecificOriginDestinationsType
     */
    public function setSpecificOriginDestCriteria(array $specificOriginDestCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($specificOriginDestCriteriaArrayErrorMessage = self::validateSpecificOriginDestCriteriaForArrayConstraintsFromSetSpecificOriginDestCriteria($specificOriginDestCriteria))) {
            throw new \InvalidArgumentException($specificOriginDestCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SpecificOriginDestCriteria = $specificOriginDestCriteria;
        return $this;
    }
    /**
     * Add item to SpecificOriginDestCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OriginDestType $item
     * @return \StructType\FlightRequestSpecificOriginDestinationsType
     */
    public function addToSpecificOriginDestCriteria(\StructType\OriginDestType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OriginDestType) {
            throw new \InvalidArgumentException(sprintf('The SpecificOriginDestCriteria property can only contain items of type \StructType\OriginDestType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SpecificOriginDestCriteria[] = $item;
        return $this;
    }
}
