<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightRelatedCriteriaType StructType
 * Meta information extracted from the WSDL
 * - documentation: Further qualifies the flight request by influencing which results are returned in the shopping response, including preferred or required criteria.
 * @subpackage Structs
 */
class FlightRelatedCriteriaType extends AbstractStructBase
{
    /**
     * The AllianceCriteria
     * Meta information extracted from the WSDL
     * - documentation: Filtering criteria based on Alliance.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\AllianceCriteriaType[]
     */
    public $AllianceCriteria;
    /**
     * The CarrierCriteria
     * Meta information extracted from the WSDL
     * - documentation: Airline preferences for a shopping request.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\CarrierCriteriaType[]
     */
    public $CarrierCriteria;
    /**
     * The ConnectionCriteria
     * Meta information extracted from the WSDL
     * - documentation: Customer's requested connection information.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ConnectionCriteriaType[]
     */
    public $ConnectionCriteria;
    /**
     * The FlightCriteria
     * Meta information extracted from the WSDL
     * - documentation: Flight filter criteria including aircraft features, Cabin Type, RBD, and Tail Number.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FlightCriteriaType[]
     */
    public $FlightCriteria;
    /**
     * The OfferItemTypeCriteria
     * Meta information extracted from the WSDL
     * - documentation: A given shopping criteria may have 1 or more offer item types.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\OfferItemTypeCriteriaType[]
     */
    public $OfferItemTypeCriteria;
    /**
     * The SegmentDurationCriteria
     * Meta information extracted from the WSDL
     * - documentation: Total segment travel time preferences.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SegmentDurationCriteriaType[]
     */
    public $SegmentDurationCriteria;
    /**
     * The TripPurposeCode
     * Meta information extracted from the WSDL
     * - documentation: Trip purpose information (e.g. Business, Leisure, etc.). | Trip purpose code Type BDT.
     * - base: TripPurposeCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TripPurposeCode;
    /**
     * Constructor method for FlightRelatedCriteriaType
     * @uses FlightRelatedCriteriaType::setAllianceCriteria()
     * @uses FlightRelatedCriteriaType::setCarrierCriteria()
     * @uses FlightRelatedCriteriaType::setConnectionCriteria()
     * @uses FlightRelatedCriteriaType::setFlightCriteria()
     * @uses FlightRelatedCriteriaType::setOfferItemTypeCriteria()
     * @uses FlightRelatedCriteriaType::setSegmentDurationCriteria()
     * @uses FlightRelatedCriteriaType::setTripPurposeCode()
     * @param \StructType\AllianceCriteriaType[] $allianceCriteria
     * @param \StructType\CarrierCriteriaType[] $carrierCriteria
     * @param \StructType\ConnectionCriteriaType[] $connectionCriteria
     * @param \StructType\FlightCriteriaType[] $flightCriteria
     * @param \StructType\OfferItemTypeCriteriaType[] $offerItemTypeCriteria
     * @param \StructType\SegmentDurationCriteriaType[] $segmentDurationCriteria
     * @param string $tripPurposeCode
     */
    public function __construct(array $allianceCriteria = array(), array $carrierCriteria = array(), array $connectionCriteria = array(), array $flightCriteria = array(), array $offerItemTypeCriteria = array(), array $segmentDurationCriteria = array(), $tripPurposeCode = null)
    {
        $this
            ->setAllianceCriteria($allianceCriteria)
            ->setCarrierCriteria($carrierCriteria)
            ->setConnectionCriteria($connectionCriteria)
            ->setFlightCriteria($flightCriteria)
            ->setOfferItemTypeCriteria($offerItemTypeCriteria)
            ->setSegmentDurationCriteria($segmentDurationCriteria)
            ->setTripPurposeCode($tripPurposeCode);
    }
    /**
     * Get AllianceCriteria value
     * @return \StructType\AllianceCriteriaType[]|null
     */
    public function getAllianceCriteria()
    {
        return $this->AllianceCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setAllianceCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setAllianceCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateAllianceCriteriaForArrayConstraintsFromSetAllianceCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRelatedCriteriaTypeAllianceCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRelatedCriteriaTypeAllianceCriteriaItem instanceof \StructType\AllianceCriteriaType) {
                $invalidValues[] = is_object($flightRelatedCriteriaTypeAllianceCriteriaItem) ? get_class($flightRelatedCriteriaTypeAllianceCriteriaItem) : sprintf('%s(%s)', gettype($flightRelatedCriteriaTypeAllianceCriteriaItem), var_export($flightRelatedCriteriaTypeAllianceCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The AllianceCriteria property can only contain items of type \StructType\AllianceCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set AllianceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceCriteriaType[] $allianceCriteria
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setAllianceCriteria(array $allianceCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($allianceCriteriaArrayErrorMessage = self::validateAllianceCriteriaForArrayConstraintsFromSetAllianceCriteria($allianceCriteria))) {
            throw new \InvalidArgumentException($allianceCriteriaArrayErrorMessage, __LINE__);
        }
        $this->AllianceCriteria = $allianceCriteria;
        return $this;
    }
    /**
     * Add item to AllianceCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\AllianceCriteriaType $item
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function addToAllianceCriteria(\StructType\AllianceCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\AllianceCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The AllianceCriteria property can only contain items of type \StructType\AllianceCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->AllianceCriteria[] = $item;
        return $this;
    }
    /**
     * Get CarrierCriteria value
     * @return \StructType\CarrierCriteriaType[]|null
     */
    public function getCarrierCriteria()
    {
        return $this->CarrierCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setCarrierCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCarrierCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCarrierCriteriaForArrayConstraintsFromSetCarrierCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRelatedCriteriaTypeCarrierCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRelatedCriteriaTypeCarrierCriteriaItem instanceof \StructType\CarrierCriteriaType) {
                $invalidValues[] = is_object($flightRelatedCriteriaTypeCarrierCriteriaItem) ? get_class($flightRelatedCriteriaTypeCarrierCriteriaItem) : sprintf('%s(%s)', gettype($flightRelatedCriteriaTypeCarrierCriteriaItem), var_export($flightRelatedCriteriaTypeCarrierCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The CarrierCriteria property can only contain items of type \StructType\CarrierCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set CarrierCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierCriteriaType[] $carrierCriteria
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setCarrierCriteria(array $carrierCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($carrierCriteriaArrayErrorMessage = self::validateCarrierCriteriaForArrayConstraintsFromSetCarrierCriteria($carrierCriteria))) {
            throw new \InvalidArgumentException($carrierCriteriaArrayErrorMessage, __LINE__);
        }
        $this->CarrierCriteria = $carrierCriteria;
        return $this;
    }
    /**
     * Add item to CarrierCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\CarrierCriteriaType $item
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function addToCarrierCriteria(\StructType\CarrierCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\CarrierCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The CarrierCriteria property can only contain items of type \StructType\CarrierCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->CarrierCriteria[] = $item;
        return $this;
    }
    /**
     * Get ConnectionCriteria value
     * @return \StructType\ConnectionCriteriaType[]|null
     */
    public function getConnectionCriteria()
    {
        return $this->ConnectionCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setConnectionCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setConnectionCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateConnectionCriteriaForArrayConstraintsFromSetConnectionCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRelatedCriteriaTypeConnectionCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRelatedCriteriaTypeConnectionCriteriaItem instanceof \StructType\ConnectionCriteriaType) {
                $invalidValues[] = is_object($flightRelatedCriteriaTypeConnectionCriteriaItem) ? get_class($flightRelatedCriteriaTypeConnectionCriteriaItem) : sprintf('%s(%s)', gettype($flightRelatedCriteriaTypeConnectionCriteriaItem), var_export($flightRelatedCriteriaTypeConnectionCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ConnectionCriteria property can only contain items of type \StructType\ConnectionCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ConnectionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionCriteriaType[] $connectionCriteria
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setConnectionCriteria(array $connectionCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($connectionCriteriaArrayErrorMessage = self::validateConnectionCriteriaForArrayConstraintsFromSetConnectionCriteria($connectionCriteria))) {
            throw new \InvalidArgumentException($connectionCriteriaArrayErrorMessage, __LINE__);
        }
        $this->ConnectionCriteria = $connectionCriteria;
        return $this;
    }
    /**
     * Add item to ConnectionCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\ConnectionCriteriaType $item
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function addToConnectionCriteria(\StructType\ConnectionCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ConnectionCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The ConnectionCriteria property can only contain items of type \StructType\ConnectionCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ConnectionCriteria[] = $item;
        return $this;
    }
    /**
     * Get FlightCriteria value
     * @return \StructType\FlightCriteriaType[]|null
     */
    public function getFlightCriteria()
    {
        return $this->FlightCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setFlightCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFlightCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFlightCriteriaForArrayConstraintsFromSetFlightCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRelatedCriteriaTypeFlightCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRelatedCriteriaTypeFlightCriteriaItem instanceof \StructType\FlightCriteriaType) {
                $invalidValues[] = is_object($flightRelatedCriteriaTypeFlightCriteriaItem) ? get_class($flightRelatedCriteriaTypeFlightCriteriaItem) : sprintf('%s(%s)', gettype($flightRelatedCriteriaTypeFlightCriteriaItem), var_export($flightRelatedCriteriaTypeFlightCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FlightCriteria property can only contain items of type \StructType\FlightCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FlightCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightCriteriaType[] $flightCriteria
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setFlightCriteria(array $flightCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($flightCriteriaArrayErrorMessage = self::validateFlightCriteriaForArrayConstraintsFromSetFlightCriteria($flightCriteria))) {
            throw new \InvalidArgumentException($flightCriteriaArrayErrorMessage, __LINE__);
        }
        $this->FlightCriteria = $flightCriteria;
        return $this;
    }
    /**
     * Add item to FlightCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\FlightCriteriaType $item
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function addToFlightCriteria(\StructType\FlightCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FlightCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The FlightCriteria property can only contain items of type \StructType\FlightCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FlightCriteria[] = $item;
        return $this;
    }
    /**
     * Get OfferItemTypeCriteria value
     * @return \StructType\OfferItemTypeCriteriaType[]|null
     */
    public function getOfferItemTypeCriteria()
    {
        return $this->OfferItemTypeCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setOfferItemTypeCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOfferItemTypeCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOfferItemTypeCriteriaForArrayConstraintsFromSetOfferItemTypeCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRelatedCriteriaTypeOfferItemTypeCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRelatedCriteriaTypeOfferItemTypeCriteriaItem instanceof \StructType\OfferItemTypeCriteriaType) {
                $invalidValues[] = is_object($flightRelatedCriteriaTypeOfferItemTypeCriteriaItem) ? get_class($flightRelatedCriteriaTypeOfferItemTypeCriteriaItem) : sprintf('%s(%s)', gettype($flightRelatedCriteriaTypeOfferItemTypeCriteriaItem), var_export($flightRelatedCriteriaTypeOfferItemTypeCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OfferItemTypeCriteria property can only contain items of type \StructType\OfferItemTypeCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OfferItemTypeCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferItemTypeCriteriaType[] $offerItemTypeCriteria
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setOfferItemTypeCriteria(array $offerItemTypeCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($offerItemTypeCriteriaArrayErrorMessage = self::validateOfferItemTypeCriteriaForArrayConstraintsFromSetOfferItemTypeCriteria($offerItemTypeCriteria))) {
            throw new \InvalidArgumentException($offerItemTypeCriteriaArrayErrorMessage, __LINE__);
        }
        $this->OfferItemTypeCriteria = $offerItemTypeCriteria;
        return $this;
    }
    /**
     * Add item to OfferItemTypeCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\OfferItemTypeCriteriaType $item
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function addToOfferItemTypeCriteria(\StructType\OfferItemTypeCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\OfferItemTypeCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The OfferItemTypeCriteria property can only contain items of type \StructType\OfferItemTypeCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OfferItemTypeCriteria[] = $item;
        return $this;
    }
    /**
     * Get SegmentDurationCriteria value
     * @return \StructType\SegmentDurationCriteriaType[]|null
     */
    public function getSegmentDurationCriteria()
    {
        return $this->SegmentDurationCriteria;
    }
    /**
     * This method is responsible for validating the values passed to the setSegmentDurationCriteria method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegmentDurationCriteria method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentDurationCriteriaForArrayConstraintsFromSetSegmentDurationCriteria(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightRelatedCriteriaTypeSegmentDurationCriteriaItem) {
            // validation for constraint: itemType
            if (!$flightRelatedCriteriaTypeSegmentDurationCriteriaItem instanceof \StructType\SegmentDurationCriteriaType) {
                $invalidValues[] = is_object($flightRelatedCriteriaTypeSegmentDurationCriteriaItem) ? get_class($flightRelatedCriteriaTypeSegmentDurationCriteriaItem) : sprintf('%s(%s)', gettype($flightRelatedCriteriaTypeSegmentDurationCriteriaItem), var_export($flightRelatedCriteriaTypeSegmentDurationCriteriaItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SegmentDurationCriteria property can only contain items of type \StructType\SegmentDurationCriteriaType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SegmentDurationCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentDurationCriteriaType[] $segmentDurationCriteria
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setSegmentDurationCriteria(array $segmentDurationCriteria = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentDurationCriteriaArrayErrorMessage = self::validateSegmentDurationCriteriaForArrayConstraintsFromSetSegmentDurationCriteria($segmentDurationCriteria))) {
            throw new \InvalidArgumentException($segmentDurationCriteriaArrayErrorMessage, __LINE__);
        }
        $this->SegmentDurationCriteria = $segmentDurationCriteria;
        return $this;
    }
    /**
     * Add item to SegmentDurationCriteria value
     * @throws \InvalidArgumentException
     * @param \StructType\SegmentDurationCriteriaType $item
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function addToSegmentDurationCriteria(\StructType\SegmentDurationCriteriaType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SegmentDurationCriteriaType) {
            throw new \InvalidArgumentException(sprintf('The SegmentDurationCriteria property can only contain items of type \StructType\SegmentDurationCriteriaType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SegmentDurationCriteria[] = $item;
        return $this;
    }
    /**
     * Get TripPurposeCode value
     * @return string|null
     */
    public function getTripPurposeCode()
    {
        return $this->TripPurposeCode;
    }
    /**
     * Set TripPurposeCode value
     * @param string $tripPurposeCode
     * @return \StructType\FlightRelatedCriteriaType
     */
    public function setTripPurposeCode($tripPurposeCode = null)
    {
        // validation for constraint: string
        if (!is_null($tripPurposeCode) && !is_string($tripPurposeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tripPurposeCode, true), gettype($tripPurposeCode)), __LINE__);
        }
        $this->TripPurposeCode = $tripPurposeCode;
        return $this;
    }
}
