<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightNumberWithSuffixType StructType
 * Meta information extracted from the WSDL
 * - documentation: A flight number with optional suffix letter. Flight numbers are integer values within the range of [0,9999]. Example: 1234 | A flight number. Flight numbers are integer values within the range of [0-9999]. Example: 1234
 * - base: xs:integer
 * - maxInclusive: 9999
 * - minInclusive: 0
 * @subpackage Structs
 */
class FlightNumberWithSuffixType extends AbstractStructBase
{
    /**
     * The _
     * Meta information extracted from the WSDL
     * - documentation: A flight number. Flight numbers are integer values within the range of [0-9999]. Example: 1234
     * - base: xs:integer
     * - maxInclusive: 9999
     * - minInclusive: 0
     * @var int
     */
    public $_;
    /**
     * The Suffix
     * Meta information extracted from the WSDL
     * - use: optional
     * @var string
     */
    public $Suffix;
    /**
     * Constructor method for FlightNumberWithSuffixType
     * @uses FlightNumberWithSuffixType::set_()
     * @uses FlightNumberWithSuffixType::setSuffix()
     * @param int $_
     * @param string $suffix
     */
    public function __construct($_ = null, $suffix = null)
    {
        $this
            ->set_($_)
            ->setSuffix($suffix);
    }
    /**
     * Get _ value
     * @return int|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param int $_
     * @return \StructType\FlightNumberWithSuffixType
     */
    public function set_($_ = null)
    {
        // validation for constraint: int
        if (!is_null($_) && !(is_int($_) || ctype_digit($_))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($_, true), gettype($_)), __LINE__);
        }
        // validation for constraint: maxInclusive(9999)
        if (!is_null($_) && $_ > 9999) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically less than or equal to 9999', var_export($_, true)), __LINE__);
        }
        // validation for constraint: minInclusive
        if (!is_null($_) && $_ < 0) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be numerically greater than or equal to 0', var_export($_, true)), __LINE__);
        }
        $this->_ = $_;
        return $this;
    }
    /**
     * Get Suffix value
     * @return string|null
     */
    public function getSuffix()
    {
        return $this->Suffix;
    }
    /**
     * Set Suffix value
     * @param string $suffix
     * @return \StructType\FlightNumberWithSuffixType
     */
    public function setSuffix($suffix = null)
    {
        // validation for constraint: string
        if (!is_null($suffix) && !is_string($suffix)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($suffix, true), gettype($suffix)), __LINE__);
        }
        $this->Suffix = $suffix;
        return $this;
    }
}
