<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FlightItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Flight service information used for long sells.
 * @subpackage Structs
 */
class FlightItemType extends AbstractStructBase
{
    /**
     * The OriginDestRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to an Origin Destination within this message. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var string[]
     */
    public $OriginDestRefID;
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FareDetailType
     */
    public $FareDetail;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: The amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\PriceType
     */
    public $Price;
    /**
     * Constructor method for FlightItemType
     * @uses FlightItemType::setOriginDestRefID()
     * @uses FlightItemType::setFareDetail()
     * @uses FlightItemType::setPrice()
     * @param string[] $originDestRefID
     * @param \StructType\FareDetailType $fareDetail
     * @param \StructType\PriceType $price
     */
    public function __construct(array $originDestRefID = array(), \StructType\FareDetailType $fareDetail = null, \StructType\PriceType $price = null)
    {
        $this
            ->setOriginDestRefID($originDestRefID)
            ->setFareDetail($fareDetail)
            ->setPrice($price);
    }
    /**
     * Get OriginDestRefID value
     * @return string[]
     */
    public function getOriginDestRefID()
    {
        return $this->OriginDestRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setOriginDestRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOriginDestRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOriginDestRefIDForArrayConstraintsFromSetOriginDestRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightItemTypeOriginDestRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($flightItemTypeOriginDestRefIDItem)) {
                $invalidValues[] = is_object($flightItemTypeOriginDestRefIDItem) ? get_class($flightItemTypeOriginDestRefIDItem) : sprintf('%s(%s)', gettype($flightItemTypeOriginDestRefIDItem), var_export($flightItemTypeOriginDestRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The OriginDestRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OriginDestRefID value
     * @throws \InvalidArgumentException
     * @param string[] $originDestRefID
     * @return \StructType\FlightItemType
     */
    public function setOriginDestRefID(array $originDestRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($originDestRefIDArrayErrorMessage = self::validateOriginDestRefIDForArrayConstraintsFromSetOriginDestRefID($originDestRefID))) {
            throw new \InvalidArgumentException($originDestRefIDArrayErrorMessage, __LINE__);
        }
        $this->OriginDestRefID = $originDestRefID;
        return $this;
    }
    /**
     * Add item to OriginDestRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\FlightItemType
     */
    public function addToOriginDestRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The OriginDestRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->OriginDestRefID[] = $item;
        return $this;
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetailType|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * Set FareDetail value
     * @param \StructType\FareDetailType $fareDetail
     * @return \StructType\FlightItemType
     */
    public function setFareDetail(\StructType\FareDetailType $fareDetail = null)
    {
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\PriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\PriceType $price
     * @return \StructType\FlightItemType
     */
    public function setPrice(\StructType\PriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
