<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Flight StructType
 * Meta information extracted from the WSDL
 * - documentation: List of prices offered for this OD and flight component, e.g. 3 PriceClasses are offered:Tango - $200.00Tango Plus - 300.00Executive - 450.00 | Total journey time of the flight(s) for entire OD. Example:. 13:45 | Group of different
 * flight options
 * @subpackage Structs
 */
class Flight extends AbstractStructBase
{
    /**
     * The JourneyTime
     * Meta information extracted from the WSDL
     * - documentation: Total journey time of the flight. Example: 13:45
     * - base: xs:string
     * - maxLength: 5
     * - minLength: 5
     * - minOccurs: 0
     * - pattern: [0-9][0-9]:[0-5][0-9]
     * - ref: JourneyTime
     * @var string
     */
    public $JourneyTime;
    /**
     * The PriceGroup
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - ref: PriceGroup
     * @var \StructType\PriceGroup
     */
    public $PriceGroup;
    /**
     * The Segment
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - ref: Segment
     * @var \StructType\Segment[]
     */
    public $Segment;
    /**
     * Constructor method for Flight
     * @uses Flight::setJourneyTime()
     * @uses Flight::setPriceGroup()
     * @uses Flight::setSegment()
     * @param string $journeyTime
     * @param \StructType\PriceGroup $priceGroup
     * @param \StructType\Segment[] $segment
     */
    public function __construct($journeyTime = null, \StructType\PriceGroup $priceGroup = null, array $segment = array())
    {
        $this
            ->setJourneyTime($journeyTime)
            ->setPriceGroup($priceGroup)
            ->setSegment($segment);
    }
    /**
     * Get JourneyTime value
     * @return string|null
     */
    public function getJourneyTime()
    {
        return $this->JourneyTime;
    }
    /**
     * Set JourneyTime value
     * @param string $journeyTime
     * @return \StructType\Flight
     */
    public function setJourneyTime($journeyTime = null)
    {
        // validation for constraint: string
        if (!is_null($journeyTime) && !is_string($journeyTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($journeyTime, true), gettype($journeyTime)), __LINE__);
        }
        // validation for constraint: maxLength(5)
        if (!is_null($journeyTime) && mb_strlen($journeyTime) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 5', mb_strlen($journeyTime)), __LINE__);
        }
        // validation for constraint: minLength(5)
        if (!is_null($journeyTime) && mb_strlen($journeyTime) < 5) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 5', mb_strlen($journeyTime)), __LINE__);
        }
        // validation for constraint: pattern([0-9][0-9]:[0-5][0-9])
        if (!is_null($journeyTime) && !preg_match('/[0-9][0-9]:[0-5][0-9]/', $journeyTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9][0-9]:[0-5][0-9]', var_export($journeyTime, true)), __LINE__);
        }
        $this->JourneyTime = $journeyTime;
        return $this;
    }
    /**
     * Get PriceGroup value
     * @return \StructType\PriceGroup|null
     */
    public function getPriceGroup()
    {
        return $this->PriceGroup;
    }
    /**
     * Set PriceGroup value
     * @param \StructType\PriceGroup $priceGroup
     * @return \StructType\Flight
     */
    public function setPriceGroup(\StructType\PriceGroup $priceGroup = null)
    {
        $this->PriceGroup = $priceGroup;
        return $this;
    }
    /**
     * Get Segment value
     * @return \StructType\Segment[]|null
     */
    public function getSegment()
    {
        return $this->Segment;
    }
    /**
     * This method is responsible for validating the values passed to the setSegment method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSegment method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSegmentForArrayConstraintsFromSetSegment(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $flightSegmentItem) {
            // validation for constraint: itemType
            if (!$flightSegmentItem instanceof \StructType\Segment) {
                $invalidValues[] = is_object($flightSegmentItem) ? get_class($flightSegmentItem) : sprintf('%s(%s)', gettype($flightSegmentItem), var_export($flightSegmentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Segment property can only contain items of type \StructType\Segment, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\Segment[] $segment
     * @return \StructType\Flight
     */
    public function setSegment(array $segment = array())
    {
        // validation for constraint: array
        if ('' !== ($segmentArrayErrorMessage = self::validateSegmentForArrayConstraintsFromSetSegment($segment))) {
            throw new \InvalidArgumentException($segmentArrayErrorMessage, __LINE__);
        }
        $this->Segment = $segment;
        return $this;
    }
    /**
     * Add item to Segment value
     * @throws \InvalidArgumentException
     * @param \StructType\Segment $item
     * @return \StructType\Flight
     */
    public function addToSegment(\StructType\Segment $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\Segment) {
            throw new \InvalidArgumentException(sprintf('The Segment property can only contain items of type \StructType\Segment, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Segment[] = $item;
        return $this;
    }
}
