<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiledFeeType StructType
 * Meta information extracted from the WSDL
 * - documentation: Filed fee information relating to a coupon, including the Bankers Seller Rate used to convert the filed amount into the currency of payment.
 * @subpackage Structs
 */
class FiledFeeType extends AbstractStructBase
{
    /**
     * The BankersSellerRate
     * Meta information extracted from the WSDL
     * - documentation: The BSR or BBR used to convert the filed fee amount from the filed currency into the currency of payment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\RateType
     */
    public $BankersSellerRate;
    /**
     * The FeeAmount
     * Meta information extracted from the WSDL
     * - documentation: File fee amount. Example: 100 USD.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\AmountType
     */
    public $FeeAmount;
    /**
     * Constructor method for FiledFeeType
     * @uses FiledFeeType::setBankersSellerRate()
     * @uses FiledFeeType::setFeeAmount()
     * @param \StructType\RateType $bankersSellerRate
     * @param \StructType\AmountType $feeAmount
     */
    public function __construct(\StructType\RateType $bankersSellerRate = null, \StructType\AmountType $feeAmount = null)
    {
        $this
            ->setBankersSellerRate($bankersSellerRate)
            ->setFeeAmount($feeAmount);
    }
    /**
     * Get BankersSellerRate value
     * @return \StructType\RateType
     */
    public function getBankersSellerRate()
    {
        return $this->BankersSellerRate;
    }
    /**
     * Set BankersSellerRate value
     * @param \StructType\RateType $bankersSellerRate
     * @return \StructType\FiledFeeType
     */
    public function setBankersSellerRate(\StructType\RateType $bankersSellerRate = null)
    {
        $this->BankersSellerRate = $bankersSellerRate;
        return $this;
    }
    /**
     * Get FeeAmount value
     * @return \StructType\AmountType
     */
    public function getFeeAmount()
    {
        return $this->FeeAmount;
    }
    /**
     * Set FeeAmount value
     * @param \StructType\AmountType $feeAmount
     * @return \StructType\FiledFeeType
     */
    public function setFeeAmount(\StructType\AmountType $feeAmount = null)
    {
        $this->FeeAmount = $feeAmount;
        return $this;
    }
}
