<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FiledCurrencyCode StructType
 * Meta information extracted from the WSDL
 * - documentation: Currency code. Example: USD
 * @subpackage Structs
 */
class FiledCurrencyCode extends AbstractStructBase
{
    /**
     * The NumberOfDecimals
     * Meta information extracted from the WSDL
     * - documentation: Decimal position in fare amount. Example: 2
     * - use: required
     * @var int
     */
    public $NumberOfDecimals;
    /**
     * The _
     * @var \StructType\CurrencyCodeType
     */
    public $_;
    /**
     * Constructor method for FiledCurrencyCode
     * @uses FiledCurrencyCode::setNumberOfDecimals()
     * @uses FiledCurrencyCode::set_()
     * @param int $numberOfDecimals
     * @param \StructType\CurrencyCodeType $_
     */
    public function __construct($numberOfDecimals = null, \StructType\CurrencyCodeType $_ = null)
    {
        $this
            ->setNumberOfDecimals($numberOfDecimals)
            ->set_($_);
    }
    /**
     * Get NumberOfDecimals value
     * @return int
     */
    public function getNumberOfDecimals()
    {
        return $this->NumberOfDecimals;
    }
    /**
     * Set NumberOfDecimals value
     * @param int $numberOfDecimals
     * @return \StructType\FiledCurrencyCode
     */
    public function setNumberOfDecimals($numberOfDecimals = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDecimals) && !(is_int($numberOfDecimals) || ctype_digit($numberOfDecimals))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDecimals, true), gettype($numberOfDecimals)), __LINE__);
        }
        $this->NumberOfDecimals = $numberOfDecimals;
        return $this;
    }
    /**
     * Get _ value
     * @return \StructType\CurrencyCodeType|null
     */
    public function get_()
    {
        return $this->_;
    }
    /**
     * Set _ value
     * @param \StructType\CurrencyCodeType $_
     * @return \StructType\FiledCurrencyCode
     */
    public function set_(\StructType\CurrencyCodeType $_ = null)
    {
        $this->_ = $_;
        return $this;
    }
}
