<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FieldMetadataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Defines implementation specific fields which should be populated.
 * @subpackage Structs
 */
class FieldMetadataType extends AbstractStructBase
{
    /**
     * The MandatoryInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, indicates the associated field is expected to be populated. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $MandatoryInd;
    /**
     * The PathText
     * Meta information extracted from the WSDL
     * - documentation: Message property location using XPATH syntax. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PathText;
    /**
     * Constructor method for FieldMetadataType
     * @uses FieldMetadataType::setMandatoryInd()
     * @uses FieldMetadataType::setPathText()
     * @param bool $mandatoryInd
     * @param string $pathText
     */
    public function __construct($mandatoryInd = null, $pathText = null)
    {
        $this
            ->setMandatoryInd($mandatoryInd)
            ->setPathText($pathText);
    }
    /**
     * Get MandatoryInd value
     * @return bool|null
     */
    public function getMandatoryInd()
    {
        return $this->MandatoryInd;
    }
    /**
     * Set MandatoryInd value
     * @param bool $mandatoryInd
     * @return \StructType\FieldMetadataType
     */
    public function setMandatoryInd($mandatoryInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($mandatoryInd) && !is_bool($mandatoryInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($mandatoryInd, true), gettype($mandatoryInd)), __LINE__);
        }
        $this->MandatoryInd = $mandatoryInd;
        return $this;
    }
    /**
     * Get PathText value
     * @return string|null
     */
    public function getPathText()
    {
        return $this->PathText;
    }
    /**
     * Set PathText value
     * @param string $pathText
     * @return \StructType\FieldMetadataType
     */
    public function setPathText($pathText = null)
    {
        // validation for constraint: string
        if (!is_null($pathText) && !is_string($pathText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pathText, true), gettype($pathText)), __LINE__);
        }
        $this->PathText = $pathText;
        return $this;
    }
}
