<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FareWaiverType StructType
 * Meta information extracted from the WSDL
 * - documentation: Validating carrier-assigned fare rule modification or override information.
 * @subpackage Structs
 */
class FareWaiverType extends AbstractStructBase
{
    /**
     * The FareRuleWaiverCode
     * Meta information extracted from the WSDL
     * - documentation: Code assigned by the validating carrier that allows fare rule modification or override. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FareRuleWaiverCode;
    /**
     * The FareWaiverTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Waiver type code. Examples: ExchangeReissued, FareComponent. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FareWaiverTypeCode;
    /**
     * Constructor method for FareWaiverType
     * @uses FareWaiverType::setFareRuleWaiverCode()
     * @uses FareWaiverType::setFareWaiverTypeCode()
     * @param string $fareRuleWaiverCode
     * @param string $fareWaiverTypeCode
     */
    public function __construct($fareRuleWaiverCode = null, $fareWaiverTypeCode = null)
    {
        $this
            ->setFareRuleWaiverCode($fareRuleWaiverCode)
            ->setFareWaiverTypeCode($fareWaiverTypeCode);
    }
    /**
     * Get FareRuleWaiverCode value
     * @return string
     */
    public function getFareRuleWaiverCode()
    {
        return $this->FareRuleWaiverCode;
    }
    /**
     * Set FareRuleWaiverCode value
     * @param string $fareRuleWaiverCode
     * @return \StructType\FareWaiverType
     */
    public function setFareRuleWaiverCode($fareRuleWaiverCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareRuleWaiverCode) && !is_string($fareRuleWaiverCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRuleWaiverCode, true), gettype($fareRuleWaiverCode)), __LINE__);
        }
        $this->FareRuleWaiverCode = $fareRuleWaiverCode;
        return $this;
    }
    /**
     * Get FareWaiverTypeCode value
     * @return string
     */
    public function getFareWaiverTypeCode()
    {
        return $this->FareWaiverTypeCode;
    }
    /**
     * Set FareWaiverTypeCode value
     * @param string $fareWaiverTypeCode
     * @return \StructType\FareWaiverType
     */
    public function setFareWaiverTypeCode($fareWaiverTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareWaiverTypeCode) && !is_string($fareWaiverTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareWaiverTypeCode, true), gettype($fareWaiverTypeCode)), __LINE__);
        }
        $this->FareWaiverTypeCode = $fareWaiverTypeCode;
        return $this;
    }
}
