<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for FOID_Type StructType
 * Meta information extracted from the WSDL
 * - documentation: Form of identification. Typically used to identify that the passenger is who he says he is. This is the type of FOID as defined in AIRIMP (FF Number, Credit Card Number, etc.).
 * @subpackage Structs
 */
class FOID_Type extends AbstractStructBase
{
    /**
     * The FOID_ID
     * Meta information extracted from the WSDL
     * - documentation: FOID ID value. Example: NY122345 | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FOID_ID;
    /**
     * The FOID_TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Form of identification type code used for booking/ticketing. Examples: PP (passport), CC (credit card), FF (frequent flyer), DL (drivers license) | Enumeration values for Baggage Type. {codeListAgencyName}IATA Code
     * List{/codeListAgencyName} {codeListName}FOID Status, Coded.{/codeListName} {codeListIdentifier}FOID{/codeListIdentifier} | Form of identification. Typically used to identify that the passenger is who he says he is. This is the type of FOID as defined
     * in AIRIMP (FF Number, Credit Card Number, etc.).
     * - base: FormOfIdentificationStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $FOID_TypeCode;
    /**
     * Constructor method for FOID_Type
     * @uses FOID_Type::setFOID_ID()
     * @uses FOID_Type::setFOID_TypeCode()
     * @param string $fOID_ID
     * @param string $fOID_TypeCode
     */
    public function __construct($fOID_ID = null, $fOID_TypeCode = null)
    {
        $this
            ->setFOID_ID($fOID_ID)
            ->setFOID_TypeCode($fOID_TypeCode);
    }
    /**
     * Get FOID_ID value
     * @return string
     */
    public function getFOID_ID()
    {
        return $this->FOID_ID;
    }
    /**
     * Set FOID_ID value
     * @param string $fOID_ID
     * @return \StructType\FOID_Type
     */
    public function setFOID_ID($fOID_ID = null)
    {
        // validation for constraint: string
        if (!is_null($fOID_ID) && !is_string($fOID_ID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOID_ID, true), gettype($fOID_ID)), __LINE__);
        }
        $this->FOID_ID = $fOID_ID;
        return $this;
    }
    /**
     * Get FOID_TypeCode value
     * @return string
     */
    public function getFOID_TypeCode()
    {
        return $this->FOID_TypeCode;
    }
    /**
     * Set FOID_TypeCode value
     * @param string $fOID_TypeCode
     * @return \StructType\FOID_Type
     */
    public function setFOID_TypeCode($fOID_TypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($fOID_TypeCode) && !is_string($fOID_TypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fOID_TypeCode, true), gettype($fOID_TypeCode)), __LINE__);
        }
        $this->FOID_TypeCode = $fOID_TypeCode;
        return $this;
    }
}
