<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExistingServiceType StructType
 * Meta information extracted from the WSDL
 * - documentation: Existing Service node provides Information about current and future statuses of the referred persistent service Ids in the Order
 * @subpackage Structs
 */
class ExistingServiceType extends AbstractStructBase
{
    /**
     * The ServiceRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to another service instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $ServiceRefID;
    /**
     * The FutureDeliveryStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Preview of the Delivery Status of the Service, as it would appear in the resulting Order, once the change is accepted and committed. See ATSB Codeset DeliveryService for possible values | Shows the possible statuses of a service
     * delivery item. {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Delivery Service Status, Coded.{/codeListName} {codeListIdentifier}DELIVERYSERVICE{/codeListIdentifier} | Represents the current status of a service delivery item
     * - base: ServiceDeliveryStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FutureDeliveryStatusCode;
    /**
     * The FutureStatusCode
     * Meta information extracted from the WSDL
     * - documentation: Status of the Order Service Status instance. See ATSB Codeset OrderService for possible values. | The possible statuses of an Order Service {codeListAgencyName}IATA Code List{/codeListAgencyName} {codeListName}Ordered Service
     * Status,coded{/codeListName} {codeListIdentifier}ORDERSERVICE{/codeListIdentifier} | represents the statuses of an Order Service
     * - base: OrderServiceStatusCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FutureStatusCode;
    /**
     * The UnchangedInd
     * Meta information extracted from the WSDL
     * - documentation: Indicated that this service is unchanged after reshopping. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $UnchangedInd;
    /**
     * Constructor method for ExistingServiceType
     * @uses ExistingServiceType::setServiceRefID()
     * @uses ExistingServiceType::setFutureDeliveryStatusCode()
     * @uses ExistingServiceType::setFutureStatusCode()
     * @uses ExistingServiceType::setUnchangedInd()
     * @param string $serviceRefID
     * @param string $futureDeliveryStatusCode
     * @param string $futureStatusCode
     * @param bool $unchangedInd
     */
    public function __construct($serviceRefID = null, $futureDeliveryStatusCode = null, $futureStatusCode = null, $unchangedInd = null)
    {
        $this
            ->setServiceRefID($serviceRefID)
            ->setFutureDeliveryStatusCode($futureDeliveryStatusCode)
            ->setFutureStatusCode($futureStatusCode)
            ->setUnchangedInd($unchangedInd);
    }
    /**
     * Get ServiceRefID value
     * @return string
     */
    public function getServiceRefID()
    {
        return $this->ServiceRefID;
    }
    /**
     * Set ServiceRefID value
     * @param string $serviceRefID
     * @return \StructType\ExistingServiceType
     */
    public function setServiceRefID($serviceRefID = null)
    {
        // validation for constraint: string
        if (!is_null($serviceRefID) && !is_string($serviceRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($serviceRefID, true), gettype($serviceRefID)), __LINE__);
        }
        $this->ServiceRefID = $serviceRefID;
        return $this;
    }
    /**
     * Get FutureDeliveryStatusCode value
     * @return string|null
     */
    public function getFutureDeliveryStatusCode()
    {
        return $this->FutureDeliveryStatusCode;
    }
    /**
     * Set FutureDeliveryStatusCode value
     * @param string $futureDeliveryStatusCode
     * @return \StructType\ExistingServiceType
     */
    public function setFutureDeliveryStatusCode($futureDeliveryStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($futureDeliveryStatusCode) && !is_string($futureDeliveryStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($futureDeliveryStatusCode, true), gettype($futureDeliveryStatusCode)), __LINE__);
        }
        $this->FutureDeliveryStatusCode = $futureDeliveryStatusCode;
        return $this;
    }
    /**
     * Get FutureStatusCode value
     * @return string|null
     */
    public function getFutureStatusCode()
    {
        return $this->FutureStatusCode;
    }
    /**
     * Set FutureStatusCode value
     * @param string $futureStatusCode
     * @return \StructType\ExistingServiceType
     */
    public function setFutureStatusCode($futureStatusCode = null)
    {
        // validation for constraint: string
        if (!is_null($futureStatusCode) && !is_string($futureStatusCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($futureStatusCode, true), gettype($futureStatusCode)), __LINE__);
        }
        $this->FutureStatusCode = $futureStatusCode;
        return $this;
    }
    /**
     * Get UnchangedInd value
     * @return bool|null
     */
    public function getUnchangedInd()
    {
        return $this->UnchangedInd;
    }
    /**
     * Set UnchangedInd value
     * @param bool $unchangedInd
     * @return \StructType\ExistingServiceType
     */
    public function setUnchangedInd($unchangedInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($unchangedInd) && !is_bool($unchangedInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($unchangedInd, true), gettype($unchangedInd)), __LINE__);
        }
        $this->UnchangedInd = $unchangedInd;
        return $this;
    }
}
