<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExistingOrderItemType StructType
 * Meta information extracted from the WSDL
 * - documentation: Existing Order Item node provides information about the current and future statuses of the services in the referred Order Item, following the acceptance of the Reshopped Offer.
 * @subpackage Structs
 */
class ExistingOrderItemType extends AbstractStructBase
{
    /**
     * The OrderItemRefID
     * Meta information extracted from the WSDL
     * - documentation: Carrier assigned Order Item Ref ID which exists uniquely within an Order. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $OrderItemRefID;
    /**
     * The ExistingService
     * Meta information extracted from the WSDL
     * - documentation: Existing Service node provides Information about current and future statuses of the referred persistent service Ids in the Order
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ExistingServiceType[]
     */
    public $ExistingService;
    /**
     * Constructor method for ExistingOrderItemType
     * @uses ExistingOrderItemType::setOrderItemRefID()
     * @uses ExistingOrderItemType::setExistingService()
     * @param string $orderItemRefID
     * @param \StructType\ExistingServiceType[] $existingService
     */
    public function __construct($orderItemRefID = null, array $existingService = array())
    {
        $this
            ->setOrderItemRefID($orderItemRefID)
            ->setExistingService($existingService);
    }
    /**
     * Get OrderItemRefID value
     * @return string
     */
    public function getOrderItemRefID()
    {
        return $this->OrderItemRefID;
    }
    /**
     * Set OrderItemRefID value
     * @param string $orderItemRefID
     * @return \StructType\ExistingOrderItemType
     */
    public function setOrderItemRefID($orderItemRefID = null)
    {
        // validation for constraint: string
        if (!is_null($orderItemRefID) && !is_string($orderItemRefID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($orderItemRefID, true), gettype($orderItemRefID)), __LINE__);
        }
        $this->OrderItemRefID = $orderItemRefID;
        return $this;
    }
    /**
     * Get ExistingService value
     * @return \StructType\ExistingServiceType[]|null
     */
    public function getExistingService()
    {
        return $this->ExistingService;
    }
    /**
     * This method is responsible for validating the values passed to the setExistingService method
     * This method is willingly generated in order to preserve the one-line inline validation within the setExistingService method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateExistingServiceForArrayConstraintsFromSetExistingService(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $existingOrderItemTypeExistingServiceItem) {
            // validation for constraint: itemType
            if (!$existingOrderItemTypeExistingServiceItem instanceof \StructType\ExistingServiceType) {
                $invalidValues[] = is_object($existingOrderItemTypeExistingServiceItem) ? get_class($existingOrderItemTypeExistingServiceItem) : sprintf('%s(%s)', gettype($existingOrderItemTypeExistingServiceItem), var_export($existingOrderItemTypeExistingServiceItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ExistingService property can only contain items of type \StructType\ExistingServiceType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ExistingService value
     * @throws \InvalidArgumentException
     * @param \StructType\ExistingServiceType[] $existingService
     * @return \StructType\ExistingOrderItemType
     */
    public function setExistingService(array $existingService = array())
    {
        // validation for constraint: array
        if ('' !== ($existingServiceArrayErrorMessage = self::validateExistingServiceForArrayConstraintsFromSetExistingService($existingService))) {
            throw new \InvalidArgumentException($existingServiceArrayErrorMessage, __LINE__);
        }
        $this->ExistingService = $existingService;
        return $this;
    }
    /**
     * Add item to ExistingService value
     * @throws \InvalidArgumentException
     * @param \StructType\ExistingServiceType $item
     * @return \StructType\ExistingOrderItemType
     */
    public function addToExistingService(\StructType\ExistingServiceType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ExistingServiceType) {
            throw new \InvalidArgumentException(sprintf('The ExistingService property can only contain items of type \StructType\ExistingServiceType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ExistingService[] = $item;
        return $this;
    }
}
