<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ErrorType StructType
 * Meta information extracted from the WSDL
 * - documentation: Contains information related to errors detected during processing of the preceding request.
 * @subpackage Structs
 */
class ErrorType extends AbstractStructBase
{
    /**
     * The LangCode
     * Meta information extracted from the WSDL
     * - documentation: Language code associated with the error response. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $LangCode;
    /**
     * The TypeCode
     * Meta information extracted from the WSDL
     * - documentation: Uses a bilaterally agreed set of values to indicate the error type. The validating XSD can expect to accept values that it has not been explicitly coded for and process them by using Type = 'unknown'. | A code is a character string
     * of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $TypeCode;
    /**
     * The Code
     * Meta information extracted from the WSDL
     * - documentation: The code corresponding to the processing error as defined by PADIS 9321. | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Code;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Free text description of the provided error. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The ErrorID
     * Meta information extracted from the WSDL
     * - documentation: Unique identifier for this error instance. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ErrorID;
    /**
     * The OwnerName
     * Meta information extracted from the WSDL
     * - documentation: The name of the organization owning the error codelist. | BDT with value constraints for proper, regular names (e.g. Individual Surname, Individual First Name, Company Name, etc.).
     * - base: xs:token
     * - maxLength: 64
     * - maxOccurs: 1
     * - minLength: 1
     * - minOccurs: 0
     * @var string
     */
    public $OwnerName;
    /**
     * The StatusText
     * Meta information extracted from the WSDL
     * - documentation: Document processing status. Recommended values are NotProcessed, Incomplete, Complete, Unknown. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatusText;
    /**
     * The TagText
     * Meta information extracted from the WSDL
     * - documentation: Identifies the tag/XPath which relates to the provided Error. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TagText;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: Link to an online description of the provided Error. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web,
     * using specific protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for ErrorType
     * @uses ErrorType::setLangCode()
     * @uses ErrorType::setTypeCode()
     * @uses ErrorType::setCode()
     * @uses ErrorType::setDescText()
     * @uses ErrorType::setErrorID()
     * @uses ErrorType::setOwnerName()
     * @uses ErrorType::setStatusText()
     * @uses ErrorType::setTagText()
     * @uses ErrorType::setURL()
     * @param string $langCode
     * @param string $typeCode
     * @param string $code
     * @param string $descText
     * @param string $errorID
     * @param string $ownerName
     * @param string $statusText
     * @param string $tagText
     * @param string $uRL
     */
    public function __construct($langCode = null, $typeCode = null, $code = null, $descText = null, $errorID = null, $ownerName = null, $statusText = null, $tagText = null, $uRL = null)
    {
        $this
            ->setLangCode($langCode)
            ->setTypeCode($typeCode)
            ->setCode($code)
            ->setDescText($descText)
            ->setErrorID($errorID)
            ->setOwnerName($ownerName)
            ->setStatusText($statusText)
            ->setTagText($tagText)
            ->setURL($uRL);
    }
    /**
     * Get LangCode value
     * @return string
     */
    public function getLangCode()
    {
        return $this->LangCode;
    }
    /**
     * Set LangCode value
     * @param string $langCode
     * @return \StructType\ErrorType
     */
    public function setLangCode($langCode = null)
    {
        // validation for constraint: string
        if (!is_null($langCode) && !is_string($langCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($langCode, true), gettype($langCode)), __LINE__);
        }
        $this->LangCode = $langCode;
        return $this;
    }
    /**
     * Get TypeCode value
     * @return string
     */
    public function getTypeCode()
    {
        return $this->TypeCode;
    }
    /**
     * Set TypeCode value
     * @param string $typeCode
     * @return \StructType\ErrorType
     */
    public function setTypeCode($typeCode = null)
    {
        // validation for constraint: string
        if (!is_null($typeCode) && !is_string($typeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($typeCode, true), gettype($typeCode)), __LINE__);
        }
        $this->TypeCode = $typeCode;
        return $this;
    }
    /**
     * Get Code value
     * @return string|null
     */
    public function getCode()
    {
        return $this->Code;
    }
    /**
     * Set Code value
     * @param string $code
     * @return \StructType\ErrorType
     */
    public function setCode($code = null)
    {
        // validation for constraint: string
        if (!is_null($code) && !is_string($code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($code, true), gettype($code)), __LINE__);
        }
        $this->Code = $code;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\ErrorType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get ErrorID value
     * @return string|null
     */
    public function getErrorID()
    {
        return $this->ErrorID;
    }
    /**
     * Set ErrorID value
     * @param string $errorID
     * @return \StructType\ErrorType
     */
    public function setErrorID($errorID = null)
    {
        // validation for constraint: string
        if (!is_null($errorID) && !is_string($errorID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($errorID, true), gettype($errorID)), __LINE__);
        }
        $this->ErrorID = $errorID;
        return $this;
    }
    /**
     * Get OwnerName value
     * @return string|null
     */
    public function getOwnerName()
    {
        return $this->OwnerName;
    }
    /**
     * Set OwnerName value
     * @param string $ownerName
     * @return \StructType\ErrorType
     */
    public function setOwnerName($ownerName = null)
    {
        // validation for constraint: string
        if (!is_null($ownerName) && !is_string($ownerName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerName, true), gettype($ownerName)), __LINE__);
        }
        // validation for constraint: maxLength(64)
        if (!is_null($ownerName) && mb_strlen($ownerName) > 64) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be less than or equal to 64', mb_strlen($ownerName)), __LINE__);
        }
        // validation for constraint: minLength(1)
        if (!is_null($ownerName) && mb_strlen($ownerName) < 1) {
            throw new \InvalidArgumentException(sprintf('Invalid length of %s, the number of characters/octets contained by the literal must be greater than or equal to 1', mb_strlen($ownerName)), __LINE__);
        }
        $this->OwnerName = $ownerName;
        return $this;
    }
    /**
     * Get StatusText value
     * @return string|null
     */
    public function getStatusText()
    {
        return $this->StatusText;
    }
    /**
     * Set StatusText value
     * @param string $statusText
     * @return \StructType\ErrorType
     */
    public function setStatusText($statusText = null)
    {
        // validation for constraint: string
        if (!is_null($statusText) && !is_string($statusText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusText, true), gettype($statusText)), __LINE__);
        }
        $this->StatusText = $statusText;
        return $this;
    }
    /**
     * Get TagText value
     * @return string|null
     */
    public function getTagText()
    {
        return $this->TagText;
    }
    /**
     * Set TagText value
     * @param string $tagText
     * @return \StructType\ErrorType
     */
    public function setTagText($tagText = null)
    {
        // validation for constraint: string
        if (!is_null($tagText) && !is_string($tagText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tagText, true), gettype($tagText)), __LINE__);
        }
        $this->TagText = $tagText;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\ErrorType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
