<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EncryptedDataType StructType
 * Meta information extracted from the WSDL
 * - documentation: Payment Card details passed onto airline in an encrypted format.
 * @subpackage Structs
 */
class EncryptedDataType extends AbstractStructBase
{
    /**
     * The CryptographyKey
     * Meta information extracted from the WSDL
     * - documentation: Cryptography Key.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CryptographyKeyType
     */
    public $CryptographyKey;
    /**
     * The CypherData
     * Meta information extracted from the WSDL
     * - documentation: Cypher Data.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\CypherDataType
     */
    public $CypherData;
    /**
     * The EncryptedCardNumber
     * Meta information extracted from the WSDL
     * - documentation: Payment Card Number passed onto airline in an encrypted format using the key provided by the airline.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BinaryObjectType
     */
    public $EncryptedCardNumber;
    /**
     * The EncryptedCardSecurityNumber
     * Meta information extracted from the WSDL
     * - documentation: Payment Card CVV passed onto airline in an encrypted format using the key provided by the airline.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\BinaryObjectType
     */
    public $EncryptedCardSecurityNumber;
    /**
     * The First6DigitsText
     * Meta information extracted from the WSDL
     * - documentation: The first six digits of the Payment Card Number, passed as part of an encrypted card workflow. | BDT to represent the First 6 digits of a payment card.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{6}
     * @var string
     */
    public $First6DigitsText;
    /**
     * The KeyNameText
     * Meta information extracted from the WSDL
     * - documentation: Used to echo back and confirm the name of the key Encryption Key being used. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $KeyNameText;
    /**
     * The Last4DigitsText
     * Meta information extracted from the WSDL
     * - documentation: The last four digits of the Payment Card Number, passed as part of an encrypted card workflow. | BDT to represent the last 4 digits of a payment card.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * - pattern: [0-9]{4}
     * @var string
     */
    public $Last4DigitsText;
    /**
     * Constructor method for EncryptedDataType
     * @uses EncryptedDataType::setCryptographyKey()
     * @uses EncryptedDataType::setCypherData()
     * @uses EncryptedDataType::setEncryptedCardNumber()
     * @uses EncryptedDataType::setEncryptedCardSecurityNumber()
     * @uses EncryptedDataType::setFirst6DigitsText()
     * @uses EncryptedDataType::setKeyNameText()
     * @uses EncryptedDataType::setLast4DigitsText()
     * @param \StructType\CryptographyKeyType $cryptographyKey
     * @param \StructType\CypherDataType $cypherData
     * @param \StructType\BinaryObjectType $encryptedCardNumber
     * @param \StructType\BinaryObjectType $encryptedCardSecurityNumber
     * @param string $first6DigitsText
     * @param string $keyNameText
     * @param string $last4DigitsText
     */
    public function __construct(\StructType\CryptographyKeyType $cryptographyKey = null, \StructType\CypherDataType $cypherData = null, \StructType\BinaryObjectType $encryptedCardNumber = null, \StructType\BinaryObjectType $encryptedCardSecurityNumber = null, $first6DigitsText = null, $keyNameText = null, $last4DigitsText = null)
    {
        $this
            ->setCryptographyKey($cryptographyKey)
            ->setCypherData($cypherData)
            ->setEncryptedCardNumber($encryptedCardNumber)
            ->setEncryptedCardSecurityNumber($encryptedCardSecurityNumber)
            ->setFirst6DigitsText($first6DigitsText)
            ->setKeyNameText($keyNameText)
            ->setLast4DigitsText($last4DigitsText);
    }
    /**
     * Get CryptographyKey value
     * @return \StructType\CryptographyKeyType
     */
    public function getCryptographyKey()
    {
        return $this->CryptographyKey;
    }
    /**
     * Set CryptographyKey value
     * @param \StructType\CryptographyKeyType $cryptographyKey
     * @return \StructType\EncryptedDataType
     */
    public function setCryptographyKey(\StructType\CryptographyKeyType $cryptographyKey = null)
    {
        $this->CryptographyKey = $cryptographyKey;
        return $this;
    }
    /**
     * Get CypherData value
     * @return \StructType\CypherDataType
     */
    public function getCypherData()
    {
        return $this->CypherData;
    }
    /**
     * Set CypherData value
     * @param \StructType\CypherDataType $cypherData
     * @return \StructType\EncryptedDataType
     */
    public function setCypherData(\StructType\CypherDataType $cypherData = null)
    {
        $this->CypherData = $cypherData;
        return $this;
    }
    /**
     * Get EncryptedCardNumber value
     * @return \StructType\BinaryObjectType
     */
    public function getEncryptedCardNumber()
    {
        return $this->EncryptedCardNumber;
    }
    /**
     * Set EncryptedCardNumber value
     * @param \StructType\BinaryObjectType $encryptedCardNumber
     * @return \StructType\EncryptedDataType
     */
    public function setEncryptedCardNumber(\StructType\BinaryObjectType $encryptedCardNumber = null)
    {
        $this->EncryptedCardNumber = $encryptedCardNumber;
        return $this;
    }
    /**
     * Get EncryptedCardSecurityNumber value
     * @return \StructType\BinaryObjectType
     */
    public function getEncryptedCardSecurityNumber()
    {
        return $this->EncryptedCardSecurityNumber;
    }
    /**
     * Set EncryptedCardSecurityNumber value
     * @param \StructType\BinaryObjectType $encryptedCardSecurityNumber
     * @return \StructType\EncryptedDataType
     */
    public function setEncryptedCardSecurityNumber(\StructType\BinaryObjectType $encryptedCardSecurityNumber = null)
    {
        $this->EncryptedCardSecurityNumber = $encryptedCardSecurityNumber;
        return $this;
    }
    /**
     * Get First6DigitsText value
     * @return string
     */
    public function getFirst6DigitsText()
    {
        return $this->First6DigitsText;
    }
    /**
     * Set First6DigitsText value
     * @param string $first6DigitsText
     * @return \StructType\EncryptedDataType
     */
    public function setFirst6DigitsText($first6DigitsText = null)
    {
        // validation for constraint: string
        if (!is_null($first6DigitsText) && !is_string($first6DigitsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($first6DigitsText, true), gettype($first6DigitsText)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{6})
        if (!is_null($first6DigitsText) && !preg_match('/[0-9]{6}/', $first6DigitsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{6}', var_export($first6DigitsText, true)), __LINE__);
        }
        $this->First6DigitsText = $first6DigitsText;
        return $this;
    }
    /**
     * Get KeyNameText value
     * @return string
     */
    public function getKeyNameText()
    {
        return $this->KeyNameText;
    }
    /**
     * Set KeyNameText value
     * @param string $keyNameText
     * @return \StructType\EncryptedDataType
     */
    public function setKeyNameText($keyNameText = null)
    {
        // validation for constraint: string
        if (!is_null($keyNameText) && !is_string($keyNameText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($keyNameText, true), gettype($keyNameText)), __LINE__);
        }
        $this->KeyNameText = $keyNameText;
        return $this;
    }
    /**
     * Get Last4DigitsText value
     * @return string
     */
    public function getLast4DigitsText()
    {
        return $this->Last4DigitsText;
    }
    /**
     * Set Last4DigitsText value
     * @param string $last4DigitsText
     * @return \StructType\EncryptedDataType
     */
    public function setLast4DigitsText($last4DigitsText = null)
    {
        // validation for constraint: string
        if (!is_null($last4DigitsText) && !is_string($last4DigitsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($last4DigitsText, true), gettype($last4DigitsText)), __LINE__);
        }
        // validation for constraint: pattern([0-9]{4})
        if (!is_null($last4DigitsText) && !preg_match('/[0-9]{4}/', $last4DigitsText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [0-9]{4}', var_export($last4DigitsText, true)), __LINE__);
        }
        $this->Last4DigitsText = $last4DigitsText;
        return $this;
    }
}
