<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmployerType StructType
 * Meta information extracted from the WSDL
 * - documentation: An organized structure set up for a particular purpose, such as a business, government body, department, charity, or financial institution.
 * @subpackage Structs
 */
class EmployerType extends AbstractStructBase
{
    /**
     * The TaxDeductedatSourceCapabilityInd
     * Meta information extracted from the WSDL
     * - documentation: Identifies if the Organization has the capability to apply Tax Deduction at Source. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var bool
     */
    public $TaxDeductedatSourceCapabilityInd;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - documentation: Name of the organization | A name is a word or phrase that constitutes the distinctive designation of a person, place, thing or concept
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $Name;
    /**
     * The SalesTaxRegistration
     * Meta information extracted from the WSDL
     * - documentation: The Identification and contact information of a party purchasing goods or services as registered with a Purchase Tax.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\SalesTaxRegistrationType[]
     */
    public $SalesTaxRegistration;
    /**
     * The TaxationExemptionQualifierCode
     * Meta information extracted from the WSDL
     * - documentation: To store Tax exemption qualification status. e.g Organization is in/a SEZ (special economic zone) UN or PSU (Public Sector Undertakings) | This will have an associated ENUM which contains codes to represent the types of tax exemption
     * qualifiying organisations
     * - base: TaxExemptionQualificationCodeContentType
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TaxationExemptionQualifierCode;
    /**
     * Constructor method for EmployerType
     * @uses EmployerType::setTaxDeductedatSourceCapabilityInd()
     * @uses EmployerType::setName()
     * @uses EmployerType::setSalesTaxRegistration()
     * @uses EmployerType::setTaxationExemptionQualifierCode()
     * @param bool $taxDeductedatSourceCapabilityInd
     * @param string $name
     * @param \StructType\SalesTaxRegistrationType[] $salesTaxRegistration
     * @param string $taxationExemptionQualifierCode
     */
    public function __construct($taxDeductedatSourceCapabilityInd = null, $name = null, array $salesTaxRegistration = array(), $taxationExemptionQualifierCode = null)
    {
        $this
            ->setTaxDeductedatSourceCapabilityInd($taxDeductedatSourceCapabilityInd)
            ->setName($name)
            ->setSalesTaxRegistration($salesTaxRegistration)
            ->setTaxationExemptionQualifierCode($taxationExemptionQualifierCode);
    }
    /**
     * Get TaxDeductedatSourceCapabilityInd value
     * @return bool
     */
    public function getTaxDeductedatSourceCapabilityInd()
    {
        return $this->TaxDeductedatSourceCapabilityInd;
    }
    /**
     * Set TaxDeductedatSourceCapabilityInd value
     * @param bool $taxDeductedatSourceCapabilityInd
     * @return \StructType\EmployerType
     */
    public function setTaxDeductedatSourceCapabilityInd($taxDeductedatSourceCapabilityInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($taxDeductedatSourceCapabilityInd) && !is_bool($taxDeductedatSourceCapabilityInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($taxDeductedatSourceCapabilityInd, true), gettype($taxDeductedatSourceCapabilityInd)), __LINE__);
        }
        $this->TaxDeductedatSourceCapabilityInd = $taxDeductedatSourceCapabilityInd;
        return $this;
    }
    /**
     * Get Name value
     * @return string|null
     */
    public function getName()
    {
        return $this->Name;
    }
    /**
     * Set Name value
     * @param string $name
     * @return \StructType\EmployerType
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        $this->Name = $name;
        return $this;
    }
    /**
     * Get SalesTaxRegistration value
     * @return \StructType\SalesTaxRegistrationType[]|null
     */
    public function getSalesTaxRegistration()
    {
        return $this->SalesTaxRegistration;
    }
    /**
     * This method is responsible for validating the values passed to the setSalesTaxRegistration method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSalesTaxRegistration method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSalesTaxRegistrationForArrayConstraintsFromSetSalesTaxRegistration(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $employerTypeSalesTaxRegistrationItem) {
            // validation for constraint: itemType
            if (!$employerTypeSalesTaxRegistrationItem instanceof \StructType\SalesTaxRegistrationType) {
                $invalidValues[] = is_object($employerTypeSalesTaxRegistrationItem) ? get_class($employerTypeSalesTaxRegistrationItem) : sprintf('%s(%s)', gettype($employerTypeSalesTaxRegistrationItem), var_export($employerTypeSalesTaxRegistrationItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The SalesTaxRegistration property can only contain items of type \StructType\SalesTaxRegistrationType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SalesTaxRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesTaxRegistrationType[] $salesTaxRegistration
     * @return \StructType\EmployerType
     */
    public function setSalesTaxRegistration(array $salesTaxRegistration = array())
    {
        // validation for constraint: array
        if ('' !== ($salesTaxRegistrationArrayErrorMessage = self::validateSalesTaxRegistrationForArrayConstraintsFromSetSalesTaxRegistration($salesTaxRegistration))) {
            throw new \InvalidArgumentException($salesTaxRegistrationArrayErrorMessage, __LINE__);
        }
        $this->SalesTaxRegistration = $salesTaxRegistration;
        return $this;
    }
    /**
     * Add item to SalesTaxRegistration value
     * @throws \InvalidArgumentException
     * @param \StructType\SalesTaxRegistrationType $item
     * @return \StructType\EmployerType
     */
    public function addToSalesTaxRegistration(\StructType\SalesTaxRegistrationType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\SalesTaxRegistrationType) {
            throw new \InvalidArgumentException(sprintf('The SalesTaxRegistration property can only contain items of type \StructType\SalesTaxRegistrationType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->SalesTaxRegistration[] = $item;
        return $this;
    }
    /**
     * Get TaxationExemptionQualifierCode value
     * @return string|null
     */
    public function getTaxationExemptionQualifierCode()
    {
        return $this->TaxationExemptionQualifierCode;
    }
    /**
     * Set TaxationExemptionQualifierCode value
     * @param string $taxationExemptionQualifierCode
     * @return \StructType\EmployerType
     */
    public function setTaxationExemptionQualifierCode($taxationExemptionQualifierCode = null)
    {
        // validation for constraint: string
        if (!is_null($taxationExemptionQualifierCode) && !is_string($taxationExemptionQualifierCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($taxationExemptionQualifierCode, true), gettype($taxationExemptionQualifierCode)), __LINE__);
        }
        $this->TaxationExemptionQualifierCode = $taxationExemptionQualifierCode;
        return $this;
    }
}
