<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EmailAddressType StructType
 * Meta information extracted from the WSDL
 * - documentation: The email address which should be used for contact purposes.
 * @subpackage Structs
 */
class EmailAddressType extends AbstractStructBase
{
    /**
     * The EmailAddressText
     * Meta information extracted from the WSDL
     * - documentation: The email address which should be used for contact purposes. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var string
     */
    public $EmailAddressText;
    /**
     * The ContactTypeText
     * Meta information extracted from the WSDL
     * - documentation: PADIS code list: Contact Type (to identify the technical contact type information) | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $ContactTypeText;
    /**
     * Constructor method for EmailAddressType
     * @uses EmailAddressType::setEmailAddressText()
     * @uses EmailAddressType::setContactTypeText()
     * @param string $emailAddressText
     * @param string $contactTypeText
     */
    public function __construct($emailAddressText = null, $contactTypeText = null)
    {
        $this
            ->setEmailAddressText($emailAddressText)
            ->setContactTypeText($contactTypeText);
    }
    /**
     * Get EmailAddressText value
     * @return string
     */
    public function getEmailAddressText()
    {
        return $this->EmailAddressText;
    }
    /**
     * Set EmailAddressText value
     * @param string $emailAddressText
     * @return \StructType\EmailAddressType
     */
    public function setEmailAddressText($emailAddressText = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddressText) && !is_string($emailAddressText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddressText, true), gettype($emailAddressText)), __LINE__);
        }
        $this->EmailAddressText = $emailAddressText;
        return $this;
    }
    /**
     * Get ContactTypeText value
     * @return string|null
     */
    public function getContactTypeText()
    {
        return $this->ContactTypeText;
    }
    /**
     * Set ContactTypeText value
     * @param string $contactTypeText
     * @return \StructType\EmailAddressType
     */
    public function setContactTypeText($contactTypeText = null)
    {
        // validation for constraint: string
        if (!is_null($contactTypeText) && !is_string($contactTypeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($contactTypeText, true), gettype($contactTypeText)), __LINE__);
        }
        $this->ContactTypeText = $contactTypeText;
        return $this;
    }
}
