<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DocNotifType StructType
 * Meta information extracted from the WSDL
 * - documentation: Document information for AirDocNotifRQ.
 * @subpackage Structs
 */
class DocNotifType extends AbstractStructBase
{
    /**
     * The Coupon
     * Meta information extracted from the WSDL
     * - documentation: The portion of the Passenger Ticket and Baggage Check or Excess Baggage Ticket that indicates particular places between which the coupon is good for carriage.
     * - maxOccurs: 4
     * - minOccurs: 1
     * @var \StructType\DocNotifCouponType[]
     */
    public $Coupon;
    /**
     * The Order
     * Meta information extracted from the WSDL
     * - documentation: A uniquely identified record of the agreement of one party with another to receive products and services under specified terms and conditions. Order supports the sale of a flexible range of airline products and services that are not
     * necessarily Journey based (e.g. subscription services). Comment: A 'PNR', 'super PNR' and 'ticket' are all today's versions of airline implementations of aspects of an Order. An Order may support non-homogeneity, i.e. each passenger in an Order may
     * hold different sets of order items at different prices.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\OrderKeyType
     */
    public $Order;
    /**
     * The Pax
     * Meta information extracted from the WSDL
     * - documentation: Any person except members of the crew carried or to be carried with the consent of the carrier, on board of any transport vehicle such as aircraft, train, bus, ship. Holds the attributes specific to a one booking, from shopping to
     * fulfillment.
     * - maxOccurs: 1
     * - minOccurs: 1
     * @var \StructType\PaxType
     */
    public $Pax;
    /**
     * The ContactInfoList
     * Meta information extracted from the WSDL
     * - documentation: Contact info data list definition.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\ContactInfoListType[]
     */
    public $ContactInfoList;
    /**
     * The DatedMarketingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated marketing segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedMarketingSegmentListType
     */
    public $DatedMarketingSegmentList;
    /**
     * The DatedOperatingLegList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating legs used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingLegListType
     */
    public $DatedOperatingLegList;
    /**
     * The DatedOperatingSegmentList
     * Meta information extracted from the WSDL
     * - documentation: A list of dated operating segments used in the contained message.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DatedOperatingSegmentListType
     */
    public $DatedOperatingSegmentList;
    /**
     * The IssueDate
     * Meta information extracted from the WSDL
     * - documentation: The date that the document was originally issued. | A date is a Gregorian calendar representation in various common resolutions: year, month, week, day.
     * - base: xs:date
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $IssueDate;
    /**
     * The TicketDocTypeCode
     * Meta information extracted from the WSDL
     * - documentation: Document type code as defined by PADIS 1001 (Document/ Message Name, coded). | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketDocTypeCode;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - documentation: The document number comprised of the airline code, form code, and serial number. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TicketNumber;
    /**
     * Constructor method for DocNotifType
     * @uses DocNotifType::setCoupon()
     * @uses DocNotifType::setOrder()
     * @uses DocNotifType::setPax()
     * @uses DocNotifType::setContactInfoList()
     * @uses DocNotifType::setDatedMarketingSegmentList()
     * @uses DocNotifType::setDatedOperatingLegList()
     * @uses DocNotifType::setDatedOperatingSegmentList()
     * @uses DocNotifType::setIssueDate()
     * @uses DocNotifType::setTicketDocTypeCode()
     * @uses DocNotifType::setTicketNumber()
     * @param \StructType\DocNotifCouponType[] $coupon
     * @param \StructType\OrderKeyType $order
     * @param \StructType\PaxType $pax
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @param string $issueDate
     * @param string $ticketDocTypeCode
     * @param string $ticketNumber
     */
    public function __construct(array $coupon = array(), \StructType\OrderKeyType $order = null, \StructType\PaxType $pax = null, array $contactInfoList = array(), \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null, \StructType\DatedOperatingLegListType $datedOperatingLegList = null, \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null, $issueDate = null, $ticketDocTypeCode = null, $ticketNumber = null)
    {
        $this
            ->setCoupon($coupon)
            ->setOrder($order)
            ->setPax($pax)
            ->setContactInfoList($contactInfoList)
            ->setDatedMarketingSegmentList($datedMarketingSegmentList)
            ->setDatedOperatingLegList($datedOperatingLegList)
            ->setDatedOperatingSegmentList($datedOperatingSegmentList)
            ->setIssueDate($issueDate)
            ->setTicketDocTypeCode($ticketDocTypeCode)
            ->setTicketNumber($ticketNumber);
    }
    /**
     * Get Coupon value
     * @return \StructType\DocNotifCouponType[]
     */
    public function getCoupon()
    {
        return $this->Coupon;
    }
    /**
     * This method is responsible for validating the values passed to the setCoupon method
     * This method is willingly generated in order to preserve the one-line inline validation within the setCoupon method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateCouponForArrayConstraintsFromSetCoupon(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docNotifTypeCouponItem) {
            // validation for constraint: itemType
            if (!$docNotifTypeCouponItem instanceof \StructType\DocNotifCouponType) {
                $invalidValues[] = is_object($docNotifTypeCouponItem) ? get_class($docNotifTypeCouponItem) : sprintf('%s(%s)', gettype($docNotifTypeCouponItem), var_export($docNotifTypeCouponItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Coupon property can only contain items of type \StructType\DocNotifCouponType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Coupon value
     * @throws \InvalidArgumentException
     * @param \StructType\DocNotifCouponType[] $coupon
     * @return \StructType\DocNotifType
     */
    public function setCoupon(array $coupon = array())
    {
        // validation for constraint: array
        if ('' !== ($couponArrayErrorMessage = self::validateCouponForArrayConstraintsFromSetCoupon($coupon))) {
            throw new \InvalidArgumentException($couponArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($coupon) && count($coupon) > 4) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 4', count($coupon)), __LINE__);
        }
        $this->Coupon = $coupon;
        return $this;
    }
    /**
     * Add item to Coupon value
     * @throws \InvalidArgumentException
     * @param \StructType\DocNotifCouponType $item
     * @return \StructType\DocNotifType
     */
    public function addToCoupon(\StructType\DocNotifCouponType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DocNotifCouponType) {
            throw new \InvalidArgumentException(sprintf('The Coupon property can only contain items of type \StructType\DocNotifCouponType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(4)
        if (is_array($this->Coupon) && count($this->Coupon) >= 4) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 4', count($this->Coupon)), __LINE__);
        }
        $this->Coupon[] = $item;
        return $this;
    }
    /**
     * Get Order value
     * @return \StructType\OrderKeyType
     */
    public function getOrder()
    {
        return $this->Order;
    }
    /**
     * Set Order value
     * @param \StructType\OrderKeyType $order
     * @return \StructType\DocNotifType
     */
    public function setOrder(\StructType\OrderKeyType $order = null)
    {
        $this->Order = $order;
        return $this;
    }
    /**
     * Get Pax value
     * @return \StructType\PaxType
     */
    public function getPax()
    {
        return $this->Pax;
    }
    /**
     * Set Pax value
     * @param \StructType\PaxType $pax
     * @return \StructType\DocNotifType
     */
    public function setPax(\StructType\PaxType $pax = null)
    {
        $this->Pax = $pax;
        return $this;
    }
    /**
     * Get ContactInfoList value
     * @return \StructType\ContactInfoListType[]|null
     */
    public function getContactInfoList()
    {
        return $this->ContactInfoList;
    }
    /**
     * This method is responsible for validating the values passed to the setContactInfoList method
     * This method is willingly generated in order to preserve the one-line inline validation within the setContactInfoList method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateContactInfoListForArrayConstraintsFromSetContactInfoList(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $docNotifTypeContactInfoListItem) {
            // validation for constraint: itemType
            if (!$docNotifTypeContactInfoListItem instanceof \StructType\ContactInfoListType) {
                $invalidValues[] = is_object($docNotifTypeContactInfoListItem) ? get_class($docNotifTypeContactInfoListItem) : sprintf('%s(%s)', gettype($docNotifTypeContactInfoListItem), var_export($docNotifTypeContactInfoListItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType[] $contactInfoList
     * @return \StructType\DocNotifType
     */
    public function setContactInfoList(array $contactInfoList = array())
    {
        // validation for constraint: array
        if ('' !== ($contactInfoListArrayErrorMessage = self::validateContactInfoListForArrayConstraintsFromSetContactInfoList($contactInfoList))) {
            throw new \InvalidArgumentException($contactInfoListArrayErrorMessage, __LINE__);
        }
        $this->ContactInfoList = $contactInfoList;
        return $this;
    }
    /**
     * Add item to ContactInfoList value
     * @throws \InvalidArgumentException
     * @param \StructType\ContactInfoListType $item
     * @return \StructType\DocNotifType
     */
    public function addToContactInfoList(\StructType\ContactInfoListType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ContactInfoListType) {
            throw new \InvalidArgumentException(sprintf('The ContactInfoList property can only contain items of type \StructType\ContactInfoListType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->ContactInfoList[] = $item;
        return $this;
    }
    /**
     * Get DatedMarketingSegmentList value
     * @return \StructType\DatedMarketingSegmentListType|null
     */
    public function getDatedMarketingSegmentList()
    {
        return $this->DatedMarketingSegmentList;
    }
    /**
     * Set DatedMarketingSegmentList value
     * @param \StructType\DatedMarketingSegmentListType $datedMarketingSegmentList
     * @return \StructType\DocNotifType
     */
    public function setDatedMarketingSegmentList(\StructType\DatedMarketingSegmentListType $datedMarketingSegmentList = null)
    {
        $this->DatedMarketingSegmentList = $datedMarketingSegmentList;
        return $this;
    }
    /**
     * Get DatedOperatingLegList value
     * @return \StructType\DatedOperatingLegListType|null
     */
    public function getDatedOperatingLegList()
    {
        return $this->DatedOperatingLegList;
    }
    /**
     * Set DatedOperatingLegList value
     * @param \StructType\DatedOperatingLegListType $datedOperatingLegList
     * @return \StructType\DocNotifType
     */
    public function setDatedOperatingLegList(\StructType\DatedOperatingLegListType $datedOperatingLegList = null)
    {
        $this->DatedOperatingLegList = $datedOperatingLegList;
        return $this;
    }
    /**
     * Get DatedOperatingSegmentList value
     * @return \StructType\DatedOperatingSegmentListType|null
     */
    public function getDatedOperatingSegmentList()
    {
        return $this->DatedOperatingSegmentList;
    }
    /**
     * Set DatedOperatingSegmentList value
     * @param \StructType\DatedOperatingSegmentListType $datedOperatingSegmentList
     * @return \StructType\DocNotifType
     */
    public function setDatedOperatingSegmentList(\StructType\DatedOperatingSegmentListType $datedOperatingSegmentList = null)
    {
        $this->DatedOperatingSegmentList = $datedOperatingSegmentList;
        return $this;
    }
    /**
     * Get IssueDate value
     * @return string|null
     */
    public function getIssueDate()
    {
        return $this->IssueDate;
    }
    /**
     * Set IssueDate value
     * @param string $issueDate
     * @return \StructType\DocNotifType
     */
    public function setIssueDate($issueDate = null)
    {
        // validation for constraint: string
        if (!is_null($issueDate) && !is_string($issueDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($issueDate, true), gettype($issueDate)), __LINE__);
        }
        $this->IssueDate = $issueDate;
        return $this;
    }
    /**
     * Get TicketDocTypeCode value
     * @return string|null
     */
    public function getTicketDocTypeCode()
    {
        return $this->TicketDocTypeCode;
    }
    /**
     * Set TicketDocTypeCode value
     * @param string $ticketDocTypeCode
     * @return \StructType\DocNotifType
     */
    public function setTicketDocTypeCode($ticketDocTypeCode = null)
    {
        // validation for constraint: string
        if (!is_null($ticketDocTypeCode) && !is_string($ticketDocTypeCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketDocTypeCode, true), gettype($ticketDocTypeCode)), __LINE__);
        }
        $this->TicketDocTypeCode = $ticketDocTypeCode;
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return string|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param string $ticketNumber
     * @return \StructType\DocNotifType
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: string
        if (!is_null($ticketNumber) && !is_string($ticketNumber)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
}
