<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DistributionChainType StructType
 * Meta information extracted from the WSDL
 * - documentation: An instance of a distribution channel, which is a chain of intermediaries through which a good or service passes until it reaches the final buyer or the end consumer.
 * @subpackage Structs
 */
class DistributionChainType extends AbstractStructBase
{
    /**
     * The DistributionChainLink
     * Meta information extracted from the WSDL
     * - documentation: An organization playing a participating role in an instance of a distribution channel.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DistributionChainLinkType[]
     */
    public $DistributionChainLink;
    /**
     * Constructor method for DistributionChainType
     * @uses DistributionChainType::setDistributionChainLink()
     * @param \StructType\DistributionChainLinkType[] $distributionChainLink
     */
    public function __construct(array $distributionChainLink = array())
    {
        $this
            ->setDistributionChainLink($distributionChainLink);
    }
    /**
     * Get DistributionChainLink value
     * @return \StructType\DistributionChainLinkType[]
     */
    public function getDistributionChainLink()
    {
        return $this->DistributionChainLink;
    }
    /**
     * This method is responsible for validating the values passed to the setDistributionChainLink method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDistributionChainLink method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDistributionChainLinkForArrayConstraintsFromSetDistributionChainLink(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $distributionChainTypeDistributionChainLinkItem) {
            // validation for constraint: itemType
            if (!$distributionChainTypeDistributionChainLinkItem instanceof \StructType\DistributionChainLinkType) {
                $invalidValues[] = is_object($distributionChainTypeDistributionChainLinkItem) ? get_class($distributionChainTypeDistributionChainLinkItem) : sprintf('%s(%s)', gettype($distributionChainTypeDistributionChainLinkItem), var_export($distributionChainTypeDistributionChainLinkItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DistributionChainLink property can only contain items of type \StructType\DistributionChainLinkType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DistributionChainLink value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionChainLinkType[] $distributionChainLink
     * @return \StructType\DistributionChainType
     */
    public function setDistributionChainLink(array $distributionChainLink = array())
    {
        // validation for constraint: array
        if ('' !== ($distributionChainLinkArrayErrorMessage = self::validateDistributionChainLinkForArrayConstraintsFromSetDistributionChainLink($distributionChainLink))) {
            throw new \InvalidArgumentException($distributionChainLinkArrayErrorMessage, __LINE__);
        }
        $this->DistributionChainLink = $distributionChainLink;
        return $this;
    }
    /**
     * Add item to DistributionChainLink value
     * @throws \InvalidArgumentException
     * @param \StructType\DistributionChainLinkType $item
     * @return \StructType\DistributionChainType
     */
    public function addToDistributionChainLink(\StructType\DistributionChainLinkType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DistributionChainLinkType) {
            throw new \InvalidArgumentException(sprintf('The DistributionChainLink property can only contain items of type \StructType\DistributionChainLinkType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DistributionChainLink[] = $item;
        return $this;
    }
}
