<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiscountType StructType
 * Meta information extracted from the WSDL
 * - documentation: Deduction from the price amount, made in advance of its payment.
 * @subpackage Structs
 */
class DiscountType extends AbstractStructBase
{
    /**
     * The AppText
     * Meta information extracted from the WSDL
     * - documentation: Discount application, e.g. Bag. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AppText;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Discount Description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - documentation: Discount amount applied to a price.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $DiscountAmount;
    /**
     * The DiscountContext
     * Meta information extracted from the WSDL
     * - documentation: Contextual information to further describe something using a key-value pair.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\KeyValuePropertyType[]
     */
    public $DiscountContext;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - documentation: Discount percentage applied to the price. | A percent is a value representing a fraction of one hundred,expressed as a quotient.
     * - base: xs:decimal
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var float
     */
    public $DiscountPercent;
    /**
     * The PreDiscountedAmount
     * Meta information extracted from the WSDL
     * - documentation: The original price on which the discount was applied to.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PreDiscountedAmount;
    /**
     * Constructor method for DiscountType
     * @uses DiscountType::setAppText()
     * @uses DiscountType::setDescText()
     * @uses DiscountType::setDiscountAmount()
     * @uses DiscountType::setDiscountContext()
     * @uses DiscountType::setDiscountPercent()
     * @uses DiscountType::setPreDiscountedAmount()
     * @param string $appText
     * @param string $descText
     * @param \StructType\AmountType $discountAmount
     * @param \StructType\KeyValuePropertyType[] $discountContext
     * @param float $discountPercent
     * @param \StructType\AmountType $preDiscountedAmount
     */
    public function __construct($appText = null, $descText = null, \StructType\AmountType $discountAmount = null, array $discountContext = array(), $discountPercent = null, \StructType\AmountType $preDiscountedAmount = null)
    {
        $this
            ->setAppText($appText)
            ->setDescText($descText)
            ->setDiscountAmount($discountAmount)
            ->setDiscountContext($discountContext)
            ->setDiscountPercent($discountPercent)
            ->setPreDiscountedAmount($preDiscountedAmount);
    }
    /**
     * Get AppText value
     * @return string|null
     */
    public function getAppText()
    {
        return $this->AppText;
    }
    /**
     * Set AppText value
     * @param string $appText
     * @return \StructType\DiscountType
     */
    public function setAppText($appText = null)
    {
        // validation for constraint: string
        if (!is_null($appText) && !is_string($appText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appText, true), gettype($appText)), __LINE__);
        }
        $this->AppText = $appText;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\DiscountType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return \StructType\AmountType|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param \StructType\AmountType $discountAmount
     * @return \StructType\DiscountType
     */
    public function setDiscountAmount(\StructType\AmountType $discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountContext value
     * @return \StructType\KeyValuePropertyType[]|null
     */
    public function getDiscountContext()
    {
        return $this->DiscountContext;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountContext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountContext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountContextForArrayConstraintsFromSetDiscountContext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountTypeDiscountContextItem) {
            // validation for constraint: itemType
            if (!$discountTypeDiscountContextItem instanceof \StructType\KeyValuePropertyType) {
                $invalidValues[] = is_object($discountTypeDiscountContextItem) ? get_class($discountTypeDiscountContextItem) : sprintf('%s(%s)', gettype($discountTypeDiscountContextItem), var_export($discountTypeDiscountContextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountContext property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountContext value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType[] $discountContext
     * @return \StructType\DiscountType
     */
    public function setDiscountContext(array $discountContext = array())
    {
        // validation for constraint: array
        if ('' !== ($discountContextArrayErrorMessage = self::validateDiscountContextForArrayConstraintsFromSetDiscountContext($discountContext))) {
            throw new \InvalidArgumentException($discountContextArrayErrorMessage, __LINE__);
        }
        $this->DiscountContext = $discountContext;
        return $this;
    }
    /**
     * Add item to DiscountContext value
     * @throws \InvalidArgumentException
     * @param \StructType\KeyValuePropertyType $item
     * @return \StructType\DiscountType
     */
    public function addToDiscountContext(\StructType\KeyValuePropertyType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\KeyValuePropertyType) {
            throw new \InvalidArgumentException(sprintf('The DiscountContext property can only contain items of type \StructType\KeyValuePropertyType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountContext[] = $item;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\DiscountType
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get PreDiscountedAmount value
     * @return \StructType\AmountType|null
     */
    public function getPreDiscountedAmount()
    {
        return $this->PreDiscountedAmount;
    }
    /**
     * Set PreDiscountedAmount value
     * @param \StructType\AmountType $preDiscountedAmount
     * @return \StructType\DiscountType
     */
    public function setPreDiscountedAmount(\StructType\AmountType $preDiscountedAmount = null)
    {
        $this->PreDiscountedAmount = $preDiscountedAmount;
        return $this;
    }
}
