<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Discount StructType
 * Meta information extracted from the WSDL
 * - documentation: Deduction from the price amount, made in advance of its payment.
 * @subpackage Structs
 */
class Discount extends AbstractStructBase
{
    /**
     * The AppText
     * Meta information extracted from the WSDL
     * - documentation: Discount application, e.g. Bag. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $AppText;
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Discount Description. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The DiscountAmount
     * Meta information extracted from the WSDL
     * - documentation: Discount amount applied to a price.
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $DiscountAmount;
    /**
     * The DiscountContext
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DiscountContext[]
     */
    public $DiscountContext;
    /**
     * The DiscountPercent
     * Meta information extracted from the WSDL
     * - documentation: Discount percentage applied to the price.
     * - minOccurs: 0
     * @var float
     */
    public $DiscountPercent;
    /**
     * The PreDiscountedAmount
     * Meta information extracted from the WSDL
     * - documentation: The original price on which the discount was applied to.
     * - minOccurs: 0
     * @var \StructType\AmountType
     */
    public $PreDiscountedAmount;
    /**
     * Constructor method for Discount
     * @uses Discount::setAppText()
     * @uses Discount::setDescText()
     * @uses Discount::setDiscountAmount()
     * @uses Discount::setDiscountContext()
     * @uses Discount::setDiscountPercent()
     * @uses Discount::setPreDiscountedAmount()
     * @param string $appText
     * @param string $descText
     * @param \StructType\AmountType $discountAmount
     * @param \StructType\DiscountContext[] $discountContext
     * @param float $discountPercent
     * @param \StructType\AmountType $preDiscountedAmount
     */
    public function __construct($appText = null, $descText = null, \StructType\AmountType $discountAmount = null, array $discountContext = array(), $discountPercent = null, \StructType\AmountType $preDiscountedAmount = null)
    {
        $this
            ->setAppText($appText)
            ->setDescText($descText)
            ->setDiscountAmount($discountAmount)
            ->setDiscountContext($discountContext)
            ->setDiscountPercent($discountPercent)
            ->setPreDiscountedAmount($preDiscountedAmount);
    }
    /**
     * Get AppText value
     * @return string|null
     */
    public function getAppText()
    {
        return $this->AppText;
    }
    /**
     * Set AppText value
     * @param string $appText
     * @return \StructType\Discount
     */
    public function setAppText($appText = null)
    {
        // validation for constraint: string
        if (!is_null($appText) && !is_string($appText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($appText, true), gettype($appText)), __LINE__);
        }
        $this->AppText = $appText;
        return $this;
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\Discount
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get DiscountAmount value
     * @return \StructType\AmountType|null
     */
    public function getDiscountAmount()
    {
        return $this->DiscountAmount;
    }
    /**
     * Set DiscountAmount value
     * @param \StructType\AmountType $discountAmount
     * @return \StructType\Discount
     */
    public function setDiscountAmount(\StructType\AmountType $discountAmount = null)
    {
        $this->DiscountAmount = $discountAmount;
        return $this;
    }
    /**
     * Get DiscountContext value
     * @return \StructType\DiscountContext[]|null
     */
    public function getDiscountContext()
    {
        return $this->DiscountContext;
    }
    /**
     * This method is responsible for validating the values passed to the setDiscountContext method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDiscountContext method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDiscountContextForArrayConstraintsFromSetDiscountContext(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $discountDiscountContextItem) {
            // validation for constraint: itemType
            if (!$discountDiscountContextItem instanceof \StructType\DiscountContext) {
                $invalidValues[] = is_object($discountDiscountContextItem) ? get_class($discountDiscountContextItem) : sprintf('%s(%s)', gettype($discountDiscountContextItem), var_export($discountDiscountContextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DiscountContext property can only contain items of type \StructType\DiscountContext, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DiscountContext value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountContext[] $discountContext
     * @return \StructType\Discount
     */
    public function setDiscountContext(array $discountContext = array())
    {
        // validation for constraint: array
        if ('' !== ($discountContextArrayErrorMessage = self::validateDiscountContextForArrayConstraintsFromSetDiscountContext($discountContext))) {
            throw new \InvalidArgumentException($discountContextArrayErrorMessage, __LINE__);
        }
        $this->DiscountContext = $discountContext;
        return $this;
    }
    /**
     * Add item to DiscountContext value
     * @throws \InvalidArgumentException
     * @param \StructType\DiscountContext $item
     * @return \StructType\Discount
     */
    public function addToDiscountContext(\StructType\DiscountContext $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DiscountContext) {
            throw new \InvalidArgumentException(sprintf('The DiscountContext property can only contain items of type \StructType\DiscountContext, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->DiscountContext[] = $item;
        return $this;
    }
    /**
     * Get DiscountPercent value
     * @return float|null
     */
    public function getDiscountPercent()
    {
        return $this->DiscountPercent;
    }
    /**
     * Set DiscountPercent value
     * @param float $discountPercent
     * @return \StructType\Discount
     */
    public function setDiscountPercent($discountPercent = null)
    {
        // validation for constraint: float
        if (!is_null($discountPercent) && !(is_float($discountPercent) || is_numeric($discountPercent))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($discountPercent, true), gettype($discountPercent)), __LINE__);
        }
        $this->DiscountPercent = $discountPercent;
        return $this;
    }
    /**
     * Get PreDiscountedAmount value
     * @return \StructType\AmountType|null
     */
    public function getPreDiscountedAmount()
    {
        return $this->PreDiscountedAmount;
    }
    /**
     * Set PreDiscountedAmount value
     * @param \StructType\AmountType $preDiscountedAmount
     * @return \StructType\Discount
     */
    public function setPreDiscountedAmount(\StructType\AmountType $preDiscountedAmount = null)
    {
        $this->PreDiscountedAmount = $preDiscountedAmount;
        return $this;
    }
}
