<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DisclosureListType StructType
 * Meta information extracted from the WSDL
 * - documentation: Disclosure data list definition.
 * @subpackage Structs
 */
class DisclosureListType extends AbstractStructBase
{
    /**
     * The Disclosure
     * Meta information extracted from the WSDL
     * - documentation: Information which should be made known.
     * - maxOccurs: unbounded
     * - minOccurs: 1
     * @var \StructType\DisclosureType[]
     */
    public $Disclosure;
    /**
     * Constructor method for DisclosureListType
     * @uses DisclosureListType::setDisclosure()
     * @param \StructType\DisclosureType[] $disclosure
     */
    public function __construct(array $disclosure = array())
    {
        $this
            ->setDisclosure($disclosure);
    }
    /**
     * Get Disclosure value
     * @return \StructType\DisclosureType[]
     */
    public function getDisclosure()
    {
        return $this->Disclosure;
    }
    /**
     * This method is responsible for validating the values passed to the setDisclosure method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDisclosure method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDisclosureForArrayConstraintsFromSetDisclosure(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $disclosureListTypeDisclosureItem) {
            // validation for constraint: itemType
            if (!$disclosureListTypeDisclosureItem instanceof \StructType\DisclosureType) {
                $invalidValues[] = is_object($disclosureListTypeDisclosureItem) ? get_class($disclosureListTypeDisclosureItem) : sprintf('%s(%s)', gettype($disclosureListTypeDisclosureItem), var_export($disclosureListTypeDisclosureItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Disclosure property can only contain items of type \StructType\DisclosureType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Disclosure value
     * @throws \InvalidArgumentException
     * @param \StructType\DisclosureType[] $disclosure
     * @return \StructType\DisclosureListType
     */
    public function setDisclosure(array $disclosure = array())
    {
        // validation for constraint: array
        if ('' !== ($disclosureArrayErrorMessage = self::validateDisclosureForArrayConstraintsFromSetDisclosure($disclosure))) {
            throw new \InvalidArgumentException($disclosureArrayErrorMessage, __LINE__);
        }
        $this->Disclosure = $disclosure;
        return $this;
    }
    /**
     * Add item to Disclosure value
     * @throws \InvalidArgumentException
     * @param \StructType\DisclosureType $item
     * @return \StructType\DisclosureListType
     */
    public function addToDisclosure(\StructType\DisclosureType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DisclosureType) {
            throw new \InvalidArgumentException(sprintf('The Disclosure property can only contain items of type \StructType\DisclosureType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Disclosure[] = $item;
        return $this;
    }
}
