<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DifferentialFareDetailType StructType
 * Meta information extracted from the WSDL
 * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
 * @subpackage Structs
 */
class DifferentialFareDetailType extends AbstractStructBase
{
    /**
     * The AccountCode
     * Meta information extracted from the WSDL
     * - documentation: Corporate ID used for pricing special fares. Example: 675124 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $AccountCode;
    /**
     * The DifferentialFarePriceType
     * Meta information extracted from the WSDL
     * - documentation: A differential specialization of an additional specified fare pricing such as 'Net' and 'Filed'. For 'Sell' or public amounts, use the Price in Fare Details.
     * - maxOccurs: 3
     * - minOccurs: 0
     * @var \StructType\DifferentialFarePriceTypeType[]
     */
    public $DifferentialFarePriceType;
    /**
     * The FareCalculationInfo
     * Meta information extracted from the WSDL
     * - documentation: Information related to the calculation of the Fare amount by applying various rules to determine a final fare for an airline ticket.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\FareCalculationInfoType
     */
    public $FareCalculationInfo;
    /**
     * The FareComponent
     * Meta information extracted from the WSDL
     * - documentation: A portion of an itinerary between two consecutive fare construction points. If the journey has only one fare component, the points of origin and destination are the only fare construction points
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareComponentType[]
     */
    public $FareComponent;
    /**
     * The FareIndCode
     * Meta information extracted from the WSDL
     * - documentation: Fare indicator code. Example: 1 (SYSTEM PRICED WITHOUT MANUAL INTERVENTION) Encoding Scheme: IATA PADIS Code List for data element 5387 - Price Type Qualifier | A code is a character string of letters, numbers, special characters
     * (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareIndCode;
    /**
     * The FareRefText
     * Meta information extracted from the WSDL
     * - documentation: Fare reference key, ex: PQ123456 | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $FareRefText;
    /**
     * The FareWaiver
     * Meta information extracted from the WSDL
     * - documentation: Validating carrier-assigned fare rule modification or override information.
     * - maxOccurs: 5
     * - minOccurs: 0
     * @var \StructType\FareWaiverType[]
     */
    public $FareWaiver;
    /**
     * The FiledFareInd
     * Meta information extracted from the WSDL
     * - documentation: When TRUE, a component of this fare has been priced using filed fare data. If FALSE, dynamic pricing has been applied. | An indicator is a list of two mutually exclusive Boolean values that express the only possible states of a
     * property.
     * - base: xs:boolean
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var bool
     */
    public $FiledFareInd;
    /**
     * The NetReportingCodeText
     * Meta information extracted from the WSDL
     * - documentation: Code indicating if the transaction is subject to a net reporting arrangement. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $NetReportingCodeText;
    /**
     * The PaxRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Passenger ID | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PaxRefID;
    /**
     * The PenaltyRefID
     * Meta information extracted from the WSDL
     * - documentation: Reference to a Penalty ID. | An identifier is a character string used to uniquely identify one instance of an object within an identification scheme that is managed by an agency.
     * - base: xs:token
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var string[]
     */
    public $PenaltyRefID;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: A specialization of price used for price differentials. Price is the amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DifferentialPriceType
     */
    public $Price;
    /**
     * The PricingSystemCodeText
     * Meta information extracted from the WSDL
     * - documentation: IATA assigned code identifying the system used to price the itinerary for the document being issued. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $PricingSystemCodeText;
    /**
     * The StatisticalCodeText
     * Meta information extracted from the WSDL
     * - documentation: Code used for domestic or international sales differentiation. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $StatisticalCodeText;
    /**
     * The TourCode
     * Meta information extracted from the WSDL
     * - documentation: Tour Code. Example: ITGF12 | A code is a character string of letters, numbers, special characters (except escape sequences), and symbols.
     * - base: xs:token
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $TourCode;
    /**
     * Constructor method for DifferentialFareDetailType
     * @uses DifferentialFareDetailType::setAccountCode()
     * @uses DifferentialFareDetailType::setDifferentialFarePriceType()
     * @uses DifferentialFareDetailType::setFareCalculationInfo()
     * @uses DifferentialFareDetailType::setFareComponent()
     * @uses DifferentialFareDetailType::setFareIndCode()
     * @uses DifferentialFareDetailType::setFareRefText()
     * @uses DifferentialFareDetailType::setFareWaiver()
     * @uses DifferentialFareDetailType::setFiledFareInd()
     * @uses DifferentialFareDetailType::setNetReportingCodeText()
     * @uses DifferentialFareDetailType::setPaxRefID()
     * @uses DifferentialFareDetailType::setPenaltyRefID()
     * @uses DifferentialFareDetailType::setPrice()
     * @uses DifferentialFareDetailType::setPricingSystemCodeText()
     * @uses DifferentialFareDetailType::setStatisticalCodeText()
     * @uses DifferentialFareDetailType::setTourCode()
     * @param string $accountCode
     * @param \StructType\DifferentialFarePriceTypeType[] $differentialFarePriceType
     * @param \StructType\FareCalculationInfoType $fareCalculationInfo
     * @param \StructType\FareComponentType[] $fareComponent
     * @param string $fareIndCode
     * @param string $fareRefText
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @param bool $filedFareInd
     * @param string $netReportingCodeText
     * @param string[] $paxRefID
     * @param string[] $penaltyRefID
     * @param \StructType\DifferentialPriceType $price
     * @param string $pricingSystemCodeText
     * @param string $statisticalCodeText
     * @param string $tourCode
     */
    public function __construct($accountCode = null, array $differentialFarePriceType = array(), \StructType\FareCalculationInfoType $fareCalculationInfo = null, array $fareComponent = array(), $fareIndCode = null, $fareRefText = null, array $fareWaiver = array(), $filedFareInd = null, $netReportingCodeText = null, array $paxRefID = array(), array $penaltyRefID = array(), \StructType\DifferentialPriceType $price = null, $pricingSystemCodeText = null, $statisticalCodeText = null, $tourCode = null)
    {
        $this
            ->setAccountCode($accountCode)
            ->setDifferentialFarePriceType($differentialFarePriceType)
            ->setFareCalculationInfo($fareCalculationInfo)
            ->setFareComponent($fareComponent)
            ->setFareIndCode($fareIndCode)
            ->setFareRefText($fareRefText)
            ->setFareWaiver($fareWaiver)
            ->setFiledFareInd($filedFareInd)
            ->setNetReportingCodeText($netReportingCodeText)
            ->setPaxRefID($paxRefID)
            ->setPenaltyRefID($penaltyRefID)
            ->setPrice($price)
            ->setPricingSystemCodeText($pricingSystemCodeText)
            ->setStatisticalCodeText($statisticalCodeText)
            ->setTourCode($tourCode);
    }
    /**
     * Get AccountCode value
     * @return string|null
     */
    public function getAccountCode()
    {
        return $this->AccountCode;
    }
    /**
     * Set AccountCode value
     * @param string $accountCode
     * @return \StructType\DifferentialFareDetailType
     */
    public function setAccountCode($accountCode = null)
    {
        // validation for constraint: string
        if (!is_null($accountCode) && !is_string($accountCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($accountCode, true), gettype($accountCode)), __LINE__);
        }
        $this->AccountCode = $accountCode;
        return $this;
    }
    /**
     * Get DifferentialFarePriceType value
     * @return \StructType\DifferentialFarePriceTypeType[]|null
     */
    public function getDifferentialFarePriceType()
    {
        return $this->DifferentialFarePriceType;
    }
    /**
     * This method is responsible for validating the values passed to the setDifferentialFarePriceType method
     * This method is willingly generated in order to preserve the one-line inline validation within the setDifferentialFarePriceType method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateDifferentialFarePriceTypeForArrayConstraintsFromSetDifferentialFarePriceType(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialFareDetailTypeDifferentialFarePriceTypeItem) {
            // validation for constraint: itemType
            if (!$differentialFareDetailTypeDifferentialFarePriceTypeItem instanceof \StructType\DifferentialFarePriceTypeType) {
                $invalidValues[] = is_object($differentialFareDetailTypeDifferentialFarePriceTypeItem) ? get_class($differentialFareDetailTypeDifferentialFarePriceTypeItem) : sprintf('%s(%s)', gettype($differentialFareDetailTypeDifferentialFarePriceTypeItem), var_export($differentialFareDetailTypeDifferentialFarePriceTypeItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The DifferentialFarePriceType property can only contain items of type \StructType\DifferentialFarePriceTypeType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set DifferentialFarePriceType value
     * @throws \InvalidArgumentException
     * @param \StructType\DifferentialFarePriceTypeType[] $differentialFarePriceType
     * @return \StructType\DifferentialFareDetailType
     */
    public function setDifferentialFarePriceType(array $differentialFarePriceType = array())
    {
        // validation for constraint: array
        if ('' !== ($differentialFarePriceTypeArrayErrorMessage = self::validateDifferentialFarePriceTypeForArrayConstraintsFromSetDifferentialFarePriceType($differentialFarePriceType))) {
            throw new \InvalidArgumentException($differentialFarePriceTypeArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($differentialFarePriceType) && count($differentialFarePriceType) > 3) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 3', count($differentialFarePriceType)), __LINE__);
        }
        $this->DifferentialFarePriceType = $differentialFarePriceType;
        return $this;
    }
    /**
     * Add item to DifferentialFarePriceType value
     * @throws \InvalidArgumentException
     * @param \StructType\DifferentialFarePriceTypeType $item
     * @return \StructType\DifferentialFareDetailType
     */
    public function addToDifferentialFarePriceType(\StructType\DifferentialFarePriceTypeType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DifferentialFarePriceTypeType) {
            throw new \InvalidArgumentException(sprintf('The DifferentialFarePriceType property can only contain items of type \StructType\DifferentialFarePriceTypeType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(3)
        if (is_array($this->DifferentialFarePriceType) && count($this->DifferentialFarePriceType) >= 3) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 3', count($this->DifferentialFarePriceType)), __LINE__);
        }
        $this->DifferentialFarePriceType[] = $item;
        return $this;
    }
    /**
     * Get FareCalculationInfo value
     * @return \StructType\FareCalculationInfoType|null
     */
    public function getFareCalculationInfo()
    {
        return $this->FareCalculationInfo;
    }
    /**
     * Set FareCalculationInfo value
     * @param \StructType\FareCalculationInfoType $fareCalculationInfo
     * @return \StructType\DifferentialFareDetailType
     */
    public function setFareCalculationInfo(\StructType\FareCalculationInfoType $fareCalculationInfo = null)
    {
        $this->FareCalculationInfo = $fareCalculationInfo;
        return $this;
    }
    /**
     * Get FareComponent value
     * @return \StructType\FareComponentType[]|null
     */
    public function getFareComponent()
    {
        return $this->FareComponent;
    }
    /**
     * This method is responsible for validating the values passed to the setFareComponent method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareComponent method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareComponentForArrayConstraintsFromSetFareComponent(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialFareDetailTypeFareComponentItem) {
            // validation for constraint: itemType
            if (!$differentialFareDetailTypeFareComponentItem instanceof \StructType\FareComponentType) {
                $invalidValues[] = is_object($differentialFareDetailTypeFareComponentItem) ? get_class($differentialFareDetailTypeFareComponentItem) : sprintf('%s(%s)', gettype($differentialFareDetailTypeFareComponentItem), var_export($differentialFareDetailTypeFareComponentItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareComponent property can only contain items of type \StructType\FareComponentType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponentType[] $fareComponent
     * @return \StructType\DifferentialFareDetailType
     */
    public function setFareComponent(array $fareComponent = array())
    {
        // validation for constraint: array
        if ('' !== ($fareComponentArrayErrorMessage = self::validateFareComponentForArrayConstraintsFromSetFareComponent($fareComponent))) {
            throw new \InvalidArgumentException($fareComponentArrayErrorMessage, __LINE__);
        }
        $this->FareComponent = $fareComponent;
        return $this;
    }
    /**
     * Add item to FareComponent value
     * @throws \InvalidArgumentException
     * @param \StructType\FareComponentType $item
     * @return \StructType\DifferentialFareDetailType
     */
    public function addToFareComponent(\StructType\FareComponentType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareComponentType) {
            throw new \InvalidArgumentException(sprintf('The FareComponent property can only contain items of type \StructType\FareComponentType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareComponent[] = $item;
        return $this;
    }
    /**
     * Get FareIndCode value
     * @return string|null
     */
    public function getFareIndCode()
    {
        return $this->FareIndCode;
    }
    /**
     * Set FareIndCode value
     * @param string $fareIndCode
     * @return \StructType\DifferentialFareDetailType
     */
    public function setFareIndCode($fareIndCode = null)
    {
        // validation for constraint: string
        if (!is_null($fareIndCode) && !is_string($fareIndCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareIndCode, true), gettype($fareIndCode)), __LINE__);
        }
        $this->FareIndCode = $fareIndCode;
        return $this;
    }
    /**
     * Get FareRefText value
     * @return string|null
     */
    public function getFareRefText()
    {
        return $this->FareRefText;
    }
    /**
     * Set FareRefText value
     * @param string $fareRefText
     * @return \StructType\DifferentialFareDetailType
     */
    public function setFareRefText($fareRefText = null)
    {
        // validation for constraint: string
        if (!is_null($fareRefText) && !is_string($fareRefText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fareRefText, true), gettype($fareRefText)), __LINE__);
        }
        $this->FareRefText = $fareRefText;
        return $this;
    }
    /**
     * Get FareWaiver value
     * @return \StructType\FareWaiverType[]|null
     */
    public function getFareWaiver()
    {
        return $this->FareWaiver;
    }
    /**
     * This method is responsible for validating the values passed to the setFareWaiver method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareWaiver method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareWaiverForArrayConstraintsFromSetFareWaiver(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialFareDetailTypeFareWaiverItem) {
            // validation for constraint: itemType
            if (!$differentialFareDetailTypeFareWaiverItem instanceof \StructType\FareWaiverType) {
                $invalidValues[] = is_object($differentialFareDetailTypeFareWaiverItem) ? get_class($differentialFareDetailTypeFareWaiverItem) : sprintf('%s(%s)', gettype($differentialFareDetailTypeFareWaiverItem), var_export($differentialFareDetailTypeFareWaiverItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType[] $fareWaiver
     * @return \StructType\DifferentialFareDetailType
     */
    public function setFareWaiver(array $fareWaiver = array())
    {
        // validation for constraint: array
        if ('' !== ($fareWaiverArrayErrorMessage = self::validateFareWaiverForArrayConstraintsFromSetFareWaiver($fareWaiver))) {
            throw new \InvalidArgumentException($fareWaiverArrayErrorMessage, __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($fareWaiver) && count($fareWaiver) > 5) {
            throw new \InvalidArgumentException(sprintf('Invalid count of %s, the number of elements contained by the property must be less than or equal to 5', count($fareWaiver)), __LINE__);
        }
        $this->FareWaiver = $fareWaiver;
        return $this;
    }
    /**
     * Add item to FareWaiver value
     * @throws \InvalidArgumentException
     * @param \StructType\FareWaiverType $item
     * @return \StructType\DifferentialFareDetailType
     */
    public function addToFareWaiver(\StructType\FareWaiverType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareWaiverType) {
            throw new \InvalidArgumentException(sprintf('The FareWaiver property can only contain items of type \StructType\FareWaiverType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: maxOccurs(5)
        if (is_array($this->FareWaiver) && count($this->FareWaiver) >= 5) {
            throw new \InvalidArgumentException(sprintf('You can\'t add anymore element to this property that already contains %s elements, the number of elements contained by the property must be less than or equal to 5', count($this->FareWaiver)), __LINE__);
        }
        $this->FareWaiver[] = $item;
        return $this;
    }
    /**
     * Get FiledFareInd value
     * @return bool|null
     */
    public function getFiledFareInd()
    {
        return $this->FiledFareInd;
    }
    /**
     * Set FiledFareInd value
     * @param bool $filedFareInd
     * @return \StructType\DifferentialFareDetailType
     */
    public function setFiledFareInd($filedFareInd = null)
    {
        // validation for constraint: boolean
        if (!is_null($filedFareInd) && !is_bool($filedFareInd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filedFareInd, true), gettype($filedFareInd)), __LINE__);
        }
        $this->FiledFareInd = $filedFareInd;
        return $this;
    }
    /**
     * Get NetReportingCodeText value
     * @return string|null
     */
    public function getNetReportingCodeText()
    {
        return $this->NetReportingCodeText;
    }
    /**
     * Set NetReportingCodeText value
     * @param string $netReportingCodeText
     * @return \StructType\DifferentialFareDetailType
     */
    public function setNetReportingCodeText($netReportingCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($netReportingCodeText) && !is_string($netReportingCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($netReportingCodeText, true), gettype($netReportingCodeText)), __LINE__);
        }
        $this->NetReportingCodeText = $netReportingCodeText;
        return $this;
    }
    /**
     * Get PaxRefID value
     * @return string[]|null
     */
    public function getPaxRefID()
    {
        return $this->PaxRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPaxRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPaxRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePaxRefIDForArrayConstraintsFromSetPaxRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialFareDetailTypePaxRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($differentialFareDetailTypePaxRefIDItem)) {
                $invalidValues[] = is_object($differentialFareDetailTypePaxRefIDItem) ? get_class($differentialFareDetailTypePaxRefIDItem) : sprintf('%s(%s)', gettype($differentialFareDetailTypePaxRefIDItem), var_export($differentialFareDetailTypePaxRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PaxRefID value
     * @throws \InvalidArgumentException
     * @param string[] $paxRefID
     * @return \StructType\DifferentialFareDetailType
     */
    public function setPaxRefID(array $paxRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($paxRefIDArrayErrorMessage = self::validatePaxRefIDForArrayConstraintsFromSetPaxRefID($paxRefID))) {
            throw new \InvalidArgumentException($paxRefIDArrayErrorMessage, __LINE__);
        }
        $this->PaxRefID = $paxRefID;
        return $this;
    }
    /**
     * Add item to PaxRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DifferentialFareDetailType
     */
    public function addToPaxRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PaxRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PaxRefID[] = $item;
        return $this;
    }
    /**
     * Get PenaltyRefID value
     * @return string[]|null
     */
    public function getPenaltyRefID()
    {
        return $this->PenaltyRefID;
    }
    /**
     * This method is responsible for validating the values passed to the setPenaltyRefID method
     * This method is willingly generated in order to preserve the one-line inline validation within the setPenaltyRefID method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $differentialFareDetailTypePenaltyRefIDItem) {
            // validation for constraint: itemType
            if (!is_string($differentialFareDetailTypePenaltyRefIDItem)) {
                $invalidValues[] = is_object($differentialFareDetailTypePenaltyRefIDItem) ? get_class($differentialFareDetailTypePenaltyRefIDItem) : sprintf('%s(%s)', gettype($differentialFareDetailTypePenaltyRefIDItem), var_export($differentialFareDetailTypePenaltyRefIDItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string[] $penaltyRefID
     * @return \StructType\DifferentialFareDetailType
     */
    public function setPenaltyRefID(array $penaltyRefID = array())
    {
        // validation for constraint: array
        if ('' !== ($penaltyRefIDArrayErrorMessage = self::validatePenaltyRefIDForArrayConstraintsFromSetPenaltyRefID($penaltyRefID))) {
            throw new \InvalidArgumentException($penaltyRefIDArrayErrorMessage, __LINE__);
        }
        $this->PenaltyRefID = $penaltyRefID;
        return $this;
    }
    /**
     * Add item to PenaltyRefID value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DifferentialFareDetailType
     */
    public function addToPenaltyRefID($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The PenaltyRefID property can only contain items of type token, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->PenaltyRefID[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\DifferentialPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\DifferentialPriceType $price
     * @return \StructType\DifferentialFareDetailType
     */
    public function setPrice(\StructType\DifferentialPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
    /**
     * Get PricingSystemCodeText value
     * @return string|null
     */
    public function getPricingSystemCodeText()
    {
        return $this->PricingSystemCodeText;
    }
    /**
     * Set PricingSystemCodeText value
     * @param string $pricingSystemCodeText
     * @return \StructType\DifferentialFareDetailType
     */
    public function setPricingSystemCodeText($pricingSystemCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($pricingSystemCodeText) && !is_string($pricingSystemCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($pricingSystemCodeText, true), gettype($pricingSystemCodeText)), __LINE__);
        }
        $this->PricingSystemCodeText = $pricingSystemCodeText;
        return $this;
    }
    /**
     * Get StatisticalCodeText value
     * @return string|null
     */
    public function getStatisticalCodeText()
    {
        return $this->StatisticalCodeText;
    }
    /**
     * Set StatisticalCodeText value
     * @param string $statisticalCodeText
     * @return \StructType\DifferentialFareDetailType
     */
    public function setStatisticalCodeText($statisticalCodeText = null)
    {
        // validation for constraint: string
        if (!is_null($statisticalCodeText) && !is_string($statisticalCodeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statisticalCodeText, true), gettype($statisticalCodeText)), __LINE__);
        }
        $this->StatisticalCodeText = $statisticalCodeText;
        return $this;
    }
    /**
     * Get TourCode value
     * @return string|null
     */
    public function getTourCode()
    {
        return $this->TourCode;
    }
    /**
     * Set TourCode value
     * @param string $tourCode
     * @return \StructType\DifferentialFareDetailType
     */
    public function setTourCode($tourCode = null)
    {
        // validation for constraint: string
        if (!is_null($tourCode) && !is_string($tourCode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tourCode, true), gettype($tourCode)), __LINE__);
        }
        $this->TourCode = $tourCode;
        return $this;
    }
}
