<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiffPriceAndFareDetailsType StructType
 * Meta information extracted from the WSDL
 * - documentation: A specialization of a container for Price and Fare detail information.
 * @subpackage Structs
 */
class DiffPriceAndFareDetailsType extends AbstractStructBase
{
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - documentation: The amount charged by the carrier for the carriage of a passenger and his allowable free baggage.
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\DifferentialFareDetailType[]
     */
    public $FareDetail;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: A specialization of price used for price differentials. Price is the amount of money expected, required, or given in payment for something.
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var \StructType\DifferentialPriceType
     */
    public $Price;
    /**
     * Constructor method for DiffPriceAndFareDetailsType
     * @uses DiffPriceAndFareDetailsType::setFareDetail()
     * @uses DiffPriceAndFareDetailsType::setPrice()
     * @param \StructType\DifferentialFareDetailType[] $fareDetail
     * @param \StructType\DifferentialPriceType $price
     */
    public function __construct(array $fareDetail = array(), \StructType\DifferentialPriceType $price = null)
    {
        $this
            ->setFareDetail($fareDetail)
            ->setPrice($price);
    }
    /**
     * Get FareDetail value
     * @return \StructType\DifferentialFareDetailType[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $diffPriceAndFareDetailsTypeFareDetailItem) {
            // validation for constraint: itemType
            if (!$diffPriceAndFareDetailsTypeFareDetailItem instanceof \StructType\DifferentialFareDetailType) {
                $invalidValues[] = is_object($diffPriceAndFareDetailsTypeFareDetailItem) ? get_class($diffPriceAndFareDetailsTypeFareDetailItem) : sprintf('%s(%s)', gettype($diffPriceAndFareDetailsTypeFareDetailItem), var_export($diffPriceAndFareDetailsTypeFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\DifferentialFareDetailType, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DifferentialFareDetailType[] $fareDetail
     * @return \StructType\DiffPriceAndFareDetailsType
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\DifferentialFareDetailType $item
     * @return \StructType\DiffPriceAndFareDetailsType
     */
    public function addToFareDetail(\StructType\DifferentialFareDetailType $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\DifferentialFareDetailType) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\DifferentialFareDetailType, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\DifferentialPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\DifferentialPriceType $price
     * @return \StructType\DiffPriceAndFareDetailsType
     */
    public function setPrice(\StructType\DifferentialPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
