<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DiffPrice StructType
 * Meta information extracted from the WSDL
 * - documentation: A specialization of a container for Price and Fare detail information.
 * @subpackage Structs
 */
class DiffPrice extends AbstractStructBase
{
    /**
     * The FareDetail
     * Meta information extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * @var \StructType\FareDetail[]
     */
    public $FareDetail;
    /**
     * The Price
     * Meta information extracted from the WSDL
     * - documentation: A specialization of price used for price differentials. Price is the amount of money expected, required, or given in payment for something.
     * - minOccurs: 0
     * @var \StructType\DifferentialPriceType
     */
    public $Price;
    /**
     * Constructor method for DiffPrice
     * @uses DiffPrice::setFareDetail()
     * @uses DiffPrice::setPrice()
     * @param \StructType\FareDetail[] $fareDetail
     * @param \StructType\DifferentialPriceType $price
     */
    public function __construct(array $fareDetail = array(), \StructType\DifferentialPriceType $price = null)
    {
        $this
            ->setFareDetail($fareDetail)
            ->setPrice($price);
    }
    /**
     * Get FareDetail value
     * @return \StructType\FareDetail[]|null
     */
    public function getFareDetail()
    {
        return $this->FareDetail;
    }
    /**
     * This method is responsible for validating the values passed to the setFareDetail method
     * This method is willingly generated in order to preserve the one-line inline validation within the setFareDetail method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateFareDetailForArrayConstraintsFromSetFareDetail(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $diffPriceFareDetailItem) {
            // validation for constraint: itemType
            if (!$diffPriceFareDetailItem instanceof \StructType\FareDetail) {
                $invalidValues[] = is_object($diffPriceFareDetailItem) ? get_class($diffPriceFareDetailItem) : sprintf('%s(%s)', gettype($diffPriceFareDetailItem), var_export($diffPriceFareDetailItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The FareDetail property can only contain items of type \StructType\FareDetail, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetail[] $fareDetail
     * @return \StructType\DiffPrice
     */
    public function setFareDetail(array $fareDetail = array())
    {
        // validation for constraint: array
        if ('' !== ($fareDetailArrayErrorMessage = self::validateFareDetailForArrayConstraintsFromSetFareDetail($fareDetail))) {
            throw new \InvalidArgumentException($fareDetailArrayErrorMessage, __LINE__);
        }
        $this->FareDetail = $fareDetail;
        return $this;
    }
    /**
     * Add item to FareDetail value
     * @throws \InvalidArgumentException
     * @param \StructType\FareDetail $item
     * @return \StructType\DiffPrice
     */
    public function addToFareDetail(\StructType\FareDetail $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FareDetail) {
            throw new \InvalidArgumentException(sprintf('The FareDetail property can only contain items of type \StructType\FareDetail, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->FareDetail[] = $item;
        return $this;
    }
    /**
     * Get Price value
     * @return \StructType\DifferentialPriceType|null
     */
    public function getPrice()
    {
        return $this->Price;
    }
    /**
     * Set Price value
     * @param \StructType\DifferentialPriceType $price
     * @return \StructType\DiffPrice
     */
    public function setPrice(\StructType\DifferentialPriceType $price = null)
    {
        $this->Price = $price;
        return $this;
    }
}
