<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescriptionDetails StructType
 * @subpackage Structs
 */
class DescriptionDetails extends AbstractStructBase
{
    /**
     * The Text
     * Meta information extracted from the WSDL
     * - documentation: Operation description details
     * - maxOccurs: unbounded
     * @var string[]
     */
    public $Text;
    /**
     * Constructor method for DescriptionDetails
     * @uses DescriptionDetails::setText()
     * @param string[] $text
     */
    public function __construct(array $text = array())
    {
        $this
            ->setText($text);
    }
    /**
     * Get Text value
     * @return string[]|null
     */
    public function getText()
    {
        return $this->Text;
    }
    /**
     * This method is responsible for validating the values passed to the setText method
     * This method is willingly generated in order to preserve the one-line inline validation within the setText method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateTextForArrayConstraintsFromSetText(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $descriptionDetailsTextItem) {
            // validation for constraint: itemType
            if (!is_string($descriptionDetailsTextItem)) {
                $invalidValues[] = is_object($descriptionDetailsTextItem) ? get_class($descriptionDetailsTextItem) : sprintf('%s(%s)', gettype($descriptionDetailsTextItem), var_export($descriptionDetailsTextItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Text property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Text value
     * @throws \InvalidArgumentException
     * @param string[] $text
     * @return \StructType\DescriptionDetails
     */
    public function setText(array $text = array())
    {
        // validation for constraint: array
        if ('' !== ($textArrayErrorMessage = self::validateTextForArrayConstraintsFromSetText($text))) {
            throw new \InvalidArgumentException($textArrayErrorMessage, __LINE__);
        }
        $this->Text = $text;
        return $this;
    }
    /**
     * Add item to Text value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \StructType\DescriptionDetails
     */
    public function addToText($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Text property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        $this->Text[] = $item;
        return $this;
    }
}
