<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DescType StructType
 * Meta information extracted from the WSDL
 * - documentation: An account or representation of the certain or major aspects, characteristics, or features of a person, object, or event.
 * @subpackage Structs
 */
class DescType extends AbstractStructBase
{
    /**
     * The DescText
     * Meta information extracted from the WSDL
     * - documentation: Description text value. | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $DescText;
    /**
     * The MarkupStyleText
     * Meta information extracted from the WSDL
     * - documentation: Mark-up Style of the Description Text. Example: HTML | Text is a character string such as a finite set of characters generally in the form of words of a language.
     * - base: xs:string
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $MarkupStyleText;
    /**
     * The URL
     * Meta information extracted from the WSDL
     * - documentation: URL to description information source. | A string of characters used to identify a resource. Such identification enables interaction with representations of the resource over a network, typically the World Wide Web, using specific
     * protocols.
     * - base: xs:anyURI
     * - maxOccurs: 1
     * - minOccurs: 0
     * @var string
     */
    public $URL;
    /**
     * Constructor method for DescType
     * @uses DescType::setDescText()
     * @uses DescType::setMarkupStyleText()
     * @uses DescType::setURL()
     * @param string $descText
     * @param string $markupStyleText
     * @param string $uRL
     */
    public function __construct($descText = null, $markupStyleText = null, $uRL = null)
    {
        $this
            ->setDescText($descText)
            ->setMarkupStyleText($markupStyleText)
            ->setURL($uRL);
    }
    /**
     * Get DescText value
     * @return string|null
     */
    public function getDescText()
    {
        return $this->DescText;
    }
    /**
     * Set DescText value
     * @param string $descText
     * @return \StructType\DescType
     */
    public function setDescText($descText = null)
    {
        // validation for constraint: string
        if (!is_null($descText) && !is_string($descText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($descText, true), gettype($descText)), __LINE__);
        }
        $this->DescText = $descText;
        return $this;
    }
    /**
     * Get MarkupStyleText value
     * @return string|null
     */
    public function getMarkupStyleText()
    {
        return $this->MarkupStyleText;
    }
    /**
     * Set MarkupStyleText value
     * @param string $markupStyleText
     * @return \StructType\DescType
     */
    public function setMarkupStyleText($markupStyleText = null)
    {
        // validation for constraint: string
        if (!is_null($markupStyleText) && !is_string($markupStyleText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($markupStyleText, true), gettype($markupStyleText)), __LINE__);
        }
        $this->MarkupStyleText = $markupStyleText;
        return $this;
    }
    /**
     * Get URL value
     * @return string|null
     */
    public function getURL()
    {
        return $this->URL;
    }
    /**
     * Set URL value
     * @param string $uRL
     * @return \StructType\DescType
     */
    public function setURL($uRL = null)
    {
        // validation for constraint: string
        if (!is_null($uRL) && !is_string($uRL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($uRL, true), gettype($uRL)), __LINE__);
        }
        $this->URL = $uRL;
        return $this;
    }
}
